//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisTimeLineView.m
//  Elis Colors
//
//  Created by 柳 on 09/09/12.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisTimeLineView.h"


@implementation ElisTimeLineView

- (void)awakeFromNib
{
    [self registerForDraggedTypes:[NSArray arrayWithObject:NSFilenamesPboardType]];
    [self registerForDraggedTypes:[NSArray arrayWithObject:NSStringPboardType]];
    leftCursorRect = NSZeroRect;
    rightCursorRect = NSZeroRect;
}

// ここにドラッグし終えた時の処理を書く。
- (BOOL)performDragOperation:(id)sender
{
//    [compositionView draggingEndFromBrowser];
//    dragMedia = nil;
    [_timeLineController draggingDone];
    return YES;
}

// 何かがドラッグされてきた。ここではその準備。
- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender
{
    NSPasteboard* board = [sender draggingPasteboard];
    NSData *data;
    NSString *path, *errorDescription;
    NSWorkspace *sharedWorkspace = [NSWorkspace sharedWorkspace];
    
    data = [board dataForType:NSFilenamesPboardType];
    if(data == nil){
//        NSLog([[NSString alloc] initWithData:[board dataForType:NSStringPboardType] encoding:NSUTF8StringEncoding]);
        data = [board dataForType:NSStringPboardType];
        [_timeLineController addText:[[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding]];
    }
    else{
    NSArray *filenames = [NSPropertyListSerialization propertyListFromData:data 
                                                          mutabilityOption:kCFPropertyListImmutable 
                                                                    format:nil 
                                                          errorDescription:&errorDescription];
    
    path = [filenames objectAtIndex:0];
    [_timeLineController addMedia:path];
    }
    [_timeLineController readyInDrag:[self convertPoint:[sender draggingLocation] fromView:nil]];
    return 1;
}

- (unsigned int)draggingUpdated:(id <NSDraggingInfo>)sender
{
    [_timeLineController dragging:[self convertPoint:[sender draggingLocation] fromView:nil]];
    return 1;
}

- (void)draggingExited:(id <NSDraggingInfo>)sender
{
    [_mainController deleteSelectLayer:nil];
}

- (void)mouseDown:(NSEvent *)theEvent
{
    NSPoint event_location = [theEvent locationInWindow];
    NSPoint local_point = [self convertPoint:event_location fromView:nil];
    
    if([self isInclude:leftCursorRect point:local_point])
        [_timeLineController stretchLeft];
    else if([self isInclude:rightCursorRect point:local_point])
        [_timeLineController stretchRight];
    else
        [_timeLineController clicked:local_point];
}

- (void)mouseDragged:(NSEvent *)theEvent
{
    NSPoint event_location = [theEvent locationInWindow];
    NSPoint local_point = [self convertPoint:event_location fromView:nil];
    [_timeLineController dragging:local_point];
}

- (void)mouseUp:(NSEvent *)theEvent
{
    NSPoint event_location = [theEvent locationInWindow];
    NSPoint local_point = [self convertPoint:event_location fromView:nil];
    if([theEvent clickCount] == 2)
        [_timeLineController doubleClicked];
    else
        [_timeLineController draggingDone];
}

- (void)setCursorRect:(CGRect)rect
{
    leftCursorRect = NSMakeRect(rect.origin.x-4, rect.origin.y, 9, rect.size.height);
    rightCursorRect = NSMakeRect(rect.origin.x+rect.size.width-4, rect.origin.y, 9, rect.size.height);
    [self resetCursorRects];
}

- (void)resetCursorRects
{
    [self addCursorRect:rightCursorRect cursor:[NSCursor resizeLeftRightCursor]];
    [self addCursorRect:leftCursorRect cursor:[NSCursor resizeLeftRightCursor]];
}

- (BOOL)isInclude:(NSRect)r point:(NSPoint)point
{
    return r.origin.x <= point.x && point.x <= r.origin.x + r.size.width
        && r.origin.y <= point.y && point.y <= r.origin.y + r.size.height;
}

@end
