//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisTimeLineController.h
//  Elis Colors
//
//  Created by 柳 on 09/09/12.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

// タイムラインのコントローラ兼モデル。Core Animation Layerを一括管理。

// MainControllerへの再描画の要求は手動で。

#import <Cocoa/Cocoa.h>
#import "ElisBase.h"
#import "ElisLayer.h"
//#import "ElisPropertyTableController.h"
#import "ElisAnimationLayerFactory.h"
#import "ElisPropertyTableController.h"

#define TRACK_MAX 16

#define STRETCH_RIGHT 1
#define STRETCH_LEFT 2

float timeLineScale;

@interface ElisTimeLineController : NSObject {
    CALayer* rootLayer, *timeLine, *playbackBar;
    IBOutlet id _timeLineView;
    IBOutlet id _mainController;
    IBOutlet id _tableController;
    IBOutlet id _undoManager;
    IBOutlet id _textLayerFiled;
    CALayer* draggingLayer;
    
    NSPoint clickedPosition;
    CGPoint clickedLayerPosition;
    BOOL dragging;
    int stretch;
    
    ElisAnimationLayerFactory* _layerFactory;
}

- (IBAction)add:(id)sender; // テスト用
- (void)changeLayerPosition:(CALayer*)layer position:(NSPoint)point;
- (void)movePlaybackBar:(float)p;
- (void)clicked:(NSPoint)point;
- (void)dragging:(NSPoint)point;
- (BOOL)isInclude:(CALayer*)layer point:(NSPoint)point;
- (void)changeLayerPosition:(CALayer*)layer position:(NSPoint)point;
- (BOOL)canDeleteLayer;

@end
