//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisMediaBrowserController.m
//  Elis Colors
//
//  Created by 柳 on 09/09/17.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisMediaBrowserController.h"

/* openFiles is a simple C function that open an NSOpenPanel and return an array of selected filepath */
static NSArray *openFiles()
{ 
    NSOpenPanel *panel;
    
    panel = [NSOpenPanel openPanel];        
    [panel setFloatingPanel:YES];
    [panel setCanChooseDirectories:YES];
    [panel setCanChooseFiles:YES];
    [panel setAllowsMultipleSelection:YES];
	int i = [panel runModalForTypes:nil];
	if(i == NSOKButton){
		return [panel filenames];
    }
    
    return nil;
}    


@implementation myImageObject

//- (void) dealloc
//{
//    [_path release];
//    [super dealloc];
//}

/* our datasource object is just a filepath representation */
- (void) setPath:(NSString *) path
{
    _path = path;
    flag = NO;
}

- (void)setMoviePath:(NSString*)path
{
    _path = path;
    flag = YES;
}


/* required methods of the IKImageBrowserItem protocol */
#pragma mark -
#pragma mark item data source protocol

/* let the image browser knows we use a path representation */
- (NSString *)  imageRepresentationType
{
    if(flag)
        return IKImageBrowserQTMoviePathRepresentationType;
    else
        return IKImageBrowserQuickLookPathRepresentationType;
    //    return IKImageBrowserPathRepresentationType;
}

/* give our representation to the image browser */
- (id)  imageRepresentation
{
	return _path;
}

/* use the absolute filepath as identifier */
- (NSString *) imageUID
{
    return _path;
}

- (NSString *)imageTitle
{
    return [_path lastPathComponent];
}

@end



/* the controller */
@implementation ElisMediaBrowserController

- (void) dealloc
{
    [_images release];
    [_importedImages release];
    [super dealloc];
}

- (void) awakeFromNib
{
	/* create two arrays : the first one is our datasource representation, the second one are temporary imported images (for thread safeness ) 
     */
    _images = [[NSMutableArray alloc] init];
    _importedImages = [[NSMutableArray alloc] init];
    _tempArray = [[NSMutableArray alloc] init];
    
    //allow reordering, animations et set draggind destination delegate
    [_mediaBrowser setAllowsReordering:YES];
    [_mediaBrowser setAnimates:YES];
    [_mediaBrowser setDraggingDestinationDelegate:self];
//    [_mediaBrowser setBackgroundColor:[NSColor grayColor]];
    
    lock = [[NSRecursiveLock alloc] init];
}

/* entry point for reloading image-browser's data and setNeedsDisplay */
- (void) updateDatasource
{
    //-- update our datasource, add recently imported items
    [_images addObjectsFromArray:_importedImages];
	
	//-- empty our temporary array
    [_importedImages removeAllObjects];
    
    //-- reload the image browser and set needs display
    [_mediaBrowser reloadData];
}

#pragma mark -
#pragma mark import images from file system

/* code that parse a repository and add all items in an independant array,
 When done, call updateDatasource, add these items to our datasource array
 This code is performed in an independant thread.
 */

- (BOOL)canInitQT:(NSString*)path
{
    canRead = [QTMovie canInitWithFile:path];
}

- (void) addAnImageWithPath:(NSString *) path
{   
    myImageObject *p;
    NSWorkspace* sharedWorkspace = [NSWorkspace sharedWorkspace];
    
 
    
    // 読めるメディアかチェック
    if([sharedWorkspace type:[sharedWorkspace typeOfFile:path error:nil] 
              conformsToType:@"public.image"]) {
           
           /* add a path to our temporary array */
        CIImage* ci = [CIImage imageWithContentsOfURL:[NSURL fileURLWithPath:path]];
        if(ci == nil) return;
           p = [[myImageObject alloc] init];
           [p setPath:path];
           [_importedImages addObject:p];
    }
    else{
        [lock lock];
           [self performSelectorOnMainThread:@selector(canInitQT:) withObject:path waitUntilDone:YES];
        [lock unlock];
        if(canRead
//            [sharedWorkspace type:[sharedWorkspace typeOfFile:path error:nil] 
//                   conformsToType:@"public.movie"] ||
//            [sharedWorkspace type:[sharedWorkspace typeOfFile:path error:nil] 
//                   conformsToType:@"public.audio"] ||
//            [sharedWorkspace type:[sharedWorkspace typeOfFile:path error:nil] 
//                   conformsToType:@"com.apple.quartz-composer-composition"]
            )
    {
        p = [[myImageObject alloc] init];
        [p setMoviePath:path];
        [_importedImages addObject:p];
    }
    }
}

- (void) addImagesWithPath:(NSString *) path recursive:(BOOL) recursive
{
    int i, n;
    BOOL dir;
    
    [[NSFileManager defaultManager] fileExistsAtPath:path isDirectory:&dir];
    
    if(dir){
        NSArray *content = [[NSFileManager defaultManager] directoryContentsAtPath:path];
        
        n = [content count];
        
		/* parse the directory content*/
        for(i=0; i<n; i++){
            //            NSLog(@"%d", i);
            if(recursive)
                [self addImagesWithPath:[path stringByAppendingPathComponent:[content objectAtIndex:i]] recursive:YES];
            else
                [self addAnImageWithPath:[path stringByAppendingPathComponent:[content objectAtIndex:i]]];
        }
    }
    else
        [self addAnImageWithPath:path];
}

/* performed in an independant thread, parse all paths in "paths" and add these paths in our temporary array */
- (void) addImagesWithPaths:(NSArray *) paths
{   
    int i, n;
    
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
    
    n = [paths count];
    for(i=0; i<n; i++){
        NSString *path = [paths objectAtIndex:i];
        [self addImagesWithPath:path recursive:NO];
    }
    
	/* update the datasource in the main thread */
    [self performSelectorOnMainThread:@selector(updateDatasource) withObject:nil waitUntilDone:YES];
    
    _tempArray = [_images copy];
    
    [pool release];
}

#pragma mark -
#pragma mark actions

/* "add" button was clicked */
- (IBAction) addImageMenuClicked:(id) sender
{   
    NSArray *path = openFiles();
    
    if(!path){ 
        NSLog(@"No path selected, return..."); 
        return; 
    }
	
	/* launch import in an independent thread */
    [NSThread detachNewThreadSelector:@selector(addImagesWithPaths:) toTarget:self withObject:path];
}

/* action called when the zoom slider did change */
- (IBAction) zoomSliderDidChange:(id)sender
{
	/* update the zoom value to scale images */
    [_mediaBrowser setZoomValue:[sender floatValue]];
	
	/* redisplay */
    [_mediaBrowser setNeedsDisplay:YES];
}

#pragma mark -
#pragma mark IKImageBrowserDataSource

/* implement image-browser's datasource protocol 
 Our datasource representation is a simple mutable array
 */

- (int) numberOfItemsInImageBrowser:(IKImageBrowserView *) view
{
	/* item count to display is our datasource item count */
    return [_images count];
}

- (id) imageBrowser:(IKImageBrowserView *) view itemAtIndex:(int) index
{
    return [_images objectAtIndex:index];
}

/* implement some optional methods of the image-browser's datasource protocol to be able to remove and reoder items */

/*	remove
 The user wants to delete images, so remove these entries from our datasource.	
 */
- (void) imageBrowser:(IKImageBrowserView *) view removeItemsAtIndexes: (NSIndexSet *) indexes
{
	[_images removeObjectsAtIndexes:indexes];
}

/* reordering 
 The user wants to reorder images, update our datasource and the browser will reflect our changes
 */
- (BOOL) imageBrowser:(IKImageBrowserView *) view  moveItemsAtIndexes: (NSIndexSet *)indexes toIndex:(unsigned int)destinationIndex
{
    int index;
    NSMutableArray *temporaryArray;
    
    temporaryArray = [[[NSMutableArray alloc] init] autorelease];
    
    /* first remove items from the datasource and keep them in a temporary array */
    for(index=[indexes lastIndex]; index != NSNotFound; index = [indexes indexLessThanIndex:index]){
        if (index < destinationIndex)
            destinationIndex --;
        
        id obj = [_images objectAtIndex:index];
        [temporaryArray addObject:obj];
        [_images removeObjectAtIndex:index];
    }
    
    /* then insert removed items at the good location */
    int n = [temporaryArray count];
    for(index=0; index < n; index++){
        [_images insertObject:[temporaryArray objectAtIndex:index] atIndex:destinationIndex];
    }
	
    return YES;
}

#pragma mark -
#pragma mark drag n drop 

/* Drag'n drop support, accept any kind of drop */
- (NSDragOperation)draggingEntered:(id <NSDraggingInfo>)sender
{
    return NSDragOperationCopy;
}

- (NSDragOperation)draggingUpdated:(id <NSDraggingInfo>)sender
{
    return NSDragOperationCopy;
}

- (BOOL) performDragOperation:(id <NSDraggingInfo>)sender
{
    NSData *data = nil;
    NSString *errorDescription;
	
    NSPasteboard *pasteboard = [sender draggingPasteboard];
    
	/* look for paths in pasteboard */
    if ([[pasteboard types] containsObject:NSFilenamesPboardType]) 
        data = [pasteboard dataForType:NSFilenamesPboardType];
    
    if(data){
		/* retrieves paths */
        NSArray *filenames = [NSPropertyListSerialization propertyListFromData:data 
                                                              mutabilityOption:kCFPropertyListImmutable 
                                                                        format:nil 
                                                              errorDescription:&errorDescription];
        
        
		/* add paths to our datasource */
        int i;
        int n = [filenames count];
        for(i=0; i<n; i++){
            [self addAnImageWithPath:[filenames objectAtIndex:i]];
        }
		
		/* make the image browser reload our datasource */
        [self updateDatasource];
    }
    
	/* we accepted the drag operation */
	return YES;
}

- (IBAction)searchFieldUpdate:(id)sender
{
    NSMutableArray* tempArray = [[NSMutableArray alloc] init];
    NSString* searchString = [sender stringValue];
        
    NSRange r;
    id image;
    
    if([searchString length] == 0){
//        _importedImages = _tempArray;
//        [self updateDatasource];
        _images = _tempArray;
        [_mediaBrowser reloadData];
        return;
    }
    
    for(image in _tempArray){
        r = [[image imageTitle] rangeOfString:searchString];
        if(r.length != 0)
            [_importedImages addObject:image];
    }
    
    [_images removeAllObjects];
    _images = [_importedImages copy];
//    [_importedImages removeAllObjects];
    [_mediaBrowser reloadData];
//    [self updateDatasource];
    
}

@end

