//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisCustomFilter.m
//  Elis
//
//  Created by 柳 on 09/09/02.
//  Copyright 2009 Yanagi Entertainment. All rights reserved.
//

#import "ElisCustomFilter.h"

@implementation ElisCustomFilter

static CIKernel* s_opacityKernel = nil; 

- (id)init
{
    if(s_opacityKernel == nil){
//        NSBundle *bundle = [NSBundle bundleForClass:[self class]];
        NSBundle* bundle = [NSBundle mainBundle];
        NSString *code = [NSString stringWithContentsOfFile:[bundle pathForResource:@"ElisCoreImageKernel" ofType:@"cikernel"]];
        NSLog(code);
        NSArray *kernels = [CIKernel kernelsWithString:code];
        s_opacityKernel = [[kernels objectAtIndex:0] retain];
    }
    
    return [super init];
}

+ (void)initialize
{
    NSLog(@"Initializing Custom Filter ...");
    
    [CIFilter registerFilterName:@"CHOpacity"
                     constructor:self
                 classAttributes:[NSDictionary dictionaryWithObjectsAndKeys:@"Change", kCIAttributeFilterDisplayName,
                                  [NSArray arrayWithObjects:kCICategoryColorAdjustment, kCICategoryVideo, kCICategoryStillImage,
                                   kCICategoryNonSquarePixels, nil], kCIAttributeFilterCategories, nil]];
//                                  [NSDictionary dictionaryWithObjectsAndKeys:
//                                   [NSNumber numberWithDouble:0.0], kCIAttributeMin,
//                                   [NSNumber numberWithDouble:1.0], kCIAttributeMax,
//                                   [NSNumber numberWithDouble:0.0], kCIAttributeSliderMin,
//                                   [NSNumber numberWithDouble:1.0], kCIAttributeSliderMax,
//                                   [NSNumber numberWithDouble:1.0], kCIAttributeDefault,
//                                   [NSNumber numberWithDouble:1.0], kCIAttributeIdentity,
//                                   kCIAttributeTypeScalar, kCIAttributeType, nil], @"inputOpacity", nil]];
}
     
- (NSDictionary*)customAttributes
{
    return [NSDictionary dictionaryWithObjectsAndKeys:
            [NSDictionary dictionaryWithObjectsAndKeys:
             [NSNumber numberWithDouble:0.0], kCIAttributeMin,
             [NSNumber numberWithDouble:1.0], kCIAttributeMax,
             [NSNumber numberWithDouble:0.0], kCIAttributeSliderMin,
             [NSNumber numberWithDouble:1.0], kCIAttributeSliderMax,
             [NSNumber numberWithDouble:1.0], kCIAttributeDefault,
             [NSNumber numberWithDouble:1.0], kCIAttributeIdentity,
             kCIAttributeTypeScalar, kCIAttributeType, nil], @"inputOpacity", nil];
}

- (CIImage*)outputImage
{
    CISampler *src = [CISampler samplerWithImage:inputImage];
    
    return [self apply:s_opacityKernel, src, inputOpacity, kCIApplyOptionDefinition, [src definition], nil];
}

+ (CIFilter*)filterWithName:(NSString *)name
{
    CIFilter *filter;
    
    filter = [[self alloc] init];
    return [filter autorelease];
}

@end
