//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisController.h
//  Elis Colors
//
//  Created by 柳 on 09/09/12.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

// Elisの一番たいせつなコントローラ。
// ElisLayerへのアクセスはここを経由して。(KVO以外)

// もう一段モデルを噛ませたほうがよかったなあといまさら。

// アウトレットが山のようにあるので、ちゃんと変数型を明記しましよう。
// @classを使えばid使う必要ないよね。

#import <Cocoa/Cocoa.h>
#import "ElisBase.h"
#import "ElisMedia.h"
#import "ElisLayer.h"
#import "ElisAnimationLayerFactory.h"
#import "ElisTimeLineController.h"
#import "ElisCustomFilter.h"
#import "ElisWriterLegacy.h"
#import "ElisUndoManager.h"
#import "ElisMovieSizeWindowController.h"
#import "ElisPreferenceController.h"
#import "ElisMovieSpeedController.h"
#import "ElisAudioWriter.h"

@class ElisMainView, ElisTimeLineController, ElisPropertyTableController;

CGRect ProjectMovieSize;
QTTime globalCurrentTime;
BOOL recording;
int timeLineXShift;
BOOL usingStampMode;

@interface ElisController : NSObject {
    NSMutableArray* layers;  // 全てのレイヤーはここに束縛
    IBOutlet ElisMainView* _mainView;
    ElisAnimationLayerFactory* _animationLayerFactory;
    IBOutlet ElisTimeLineController* _timeLineController;
    IBOutlet ElisPropertyTableController* _tableController;
    IBOutlet NSWindow* _mainWindow;
    IBOutlet ElisUndoManager* _undoManager;
    IBOutlet NSTextView* _textLayerField;
    IBOutlet NSButton* _playstopButton;
    
    float hipTime;
    QTTime _currentTime;
    BOOL playing; // YES = 再生中
    NSGarbageCollector* collector; // GCの制御用。
    NSString* savePath;
    
    IBOutlet NSSlider* timeSlider;
    IBOutlet NSTextField* timeCodeField;
    
#ifdef __SNOW_LEOPARD_GCD__
    dispatch_queue_t diq;
#endif
}

- (float)getHipTime;

- (IBAction)playStop:(id)sender;
- (IBAction)startPlay:(id)sender;
- (IBAction)stopPlay:(id)sender;
- (IBAction)timeSliderChanged:(id)sender;
- (void)moveSliderTo:(QTTime)time;
- (void)refresh;
- (void)getSoundTrack:(NSMutableArray*)soundTrack;
- (IBAction)deleteSelectLayer:(id)sender;
- (IBAction)recordingStateChanged:(id)sender;
- (IBAction)removeAllKeyFrame:(id)sender;
- (IBAction)removeEffect:(id)sender;

- (IBAction)writeToFile:(id)sender;
- (IBAction)openProjectSaveDialog:(id)sender;
- (IBAction)openProjectLoadDialog:(id)sender;
- (IBAction)rewriteProject:(id)sender;
- (IBAction)undo:(id)sender;
- (IBAction)redo:(id)sender;
- (IBAction)changeMovieSize:(id)sender;
- (IBAction)preference:(id)sender;

- (IBAction)changeToSmallWindiw:(id)sender;
- (IBAction)changeMovieSpeed:(id)sender;
- (IBAction)gotoNextKeyTime:(id)sender;
- (IBAction)gotoPrevKeyTime:(id)sender;
- (IBAction)cutLayerAtCurrentTime:(id)sender;

@end
