//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisAnimationLayerFactory.m
//  Elis Colors
//
//  Created by 柳 on 09/09/12.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisAnimationLayerFactory.h"


@implementation ElisAnimationLayerFactory

- (id)init
{
    bundle = [NSBundle mainBundle];
    mediaImage = [[NSBitmapImageRep imageRepWithContentsOfFile:[bundle pathForResource:@"skyblue" ofType:@"jpg"]] CGImage];
    
    return self;
}

- (CALayer*)createNewAnimationLayer:(float)d name:(NSString*)name type:(NSString*)t_type
{
    CALayer* layer = [CALayer layer];
//    layer.contents = mediaImage;
    // なぜかGCされる
    
    if([t_type isEqualToString:@"movie"])
        mediaImage = [[NSBitmapImageRep imageRepWithContentsOfFile:[bundle pathForResource:@"skyblue" ofType:@"jpg"]] CGImage];
    else if([t_type isEqualToString:@"sound"])
        mediaImage = [[NSBitmapImageRep imageRepWithContentsOfFile:[bundle pathForResource:@"orange" ofType:@"jpg"]] CGImage];
    else if([t_type isEqualToString:@"image"])
        mediaImage = [[NSBitmapImageRep imageRepWithContentsOfFile:[bundle pathForResource:@"lightgreen" ofType:@"jpg"]] CGImage];
    else if([t_type isEqualToString:@"text"])
        mediaImage = [[NSBitmapImageRep imageRepWithContentsOfFile:[bundle pathForResource:@"lightgreen" ofType:@"jpg"]] CGImage];
    layer.contents = (id)mediaImage;
    layer.opacity = 0.75;
//    [layer setValue:(id)mediaImage forKey:@"contents"];
    layer.frame = CGRectMake(0, 0, d*timeLineScale, 50);
    
    CATextLayer* textLayer = [CATextLayer layer];
    textLayer.string = name;
    textLayer.font = @"HiraKakuPro-W3";
    textLayer.fontSize = 26.0;
    textLayer.foregroundColor = CGColorCreateGenericRGB(1.0, 1.0, 1.0, 1.0);
    textLayer.frame = layer.frame;
    
    layer.masksToBounds = NO;
    [layer addSublayer:textLayer];
    [layer setValue:[NSNumber numberWithBool:NO] forKey:@"have keyframeLayer"];
    
    return layer;
}

- (CALayer*)createKeyframeLayerWithLayer:(CALayer*)layer
{
    CALayer* newLayer = [CALayer layer];
    CGRect r = layer.frame;
    
    r.origin.y = r.size.height;
    r.size.height = r.size.height*2;
    r.origin.x = 0;
    newLayer.frame = r;
    parentLayer = layer;
    
    return newLayer;
}

- (CALayer*)createKeyframeLevelLayer
{
    CALayer* miniLayer = [CALayer layer];
    miniLayer.frame = CGRectMake(0, 0, MINI_LAYER_WIDTH, 0);
    miniLayer.contents = parentLayer.contents;
    miniLayer.opacity = 0.6;
    
    return miniLayer;
}

- (void)removeParentLayer
{
    parentLayer = nil; // 参照を切る
}
@end
