//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisPropertyTableController.m
//  Elis Colors
//
//  Created by 柳 on 09/09/15.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisPropertyTableController.h"


@implementation ElisPropertyTableController

- (void)awakeFromNib
{
    effects = [[NSMutableArray alloc] init];
    propertyNames = [[NSMutableArray alloc] init];
    valueNames = [[NSMutableArray alloc] init];
}

- (void)createPropertyTable:(ElisLayer*)layer
{
    interestLayer = layer;
    
    [effects removeAllObjects];
    [propertyNames removeAllObjects];
    [valueNames removeAllObjects];
    
    [layer createPropertyTableDataSource:effects property:propertyNames value:valueNames];
}

- (int)numberOfRowsInTableView:(NSTableView*)aTableView
{
    return [effects count];
}

- (id)tableView:(NSTableView *)tableView 
        objectValueForTableColumn:(NSTableColumn*)aTableColumn
        row:(int)rowIndex
{
    NSPoint p;
    NSString* propertyName = [propertyNames objectAtIndex:rowIndex];
    QTTime localCurrentTime = [interestLayer convertToInnnerTime:globalCurrentTime];
    
    if([effects count] != 1){
    
    // スライダーのカラム
    if([[aTableColumn identifier] isEqualToString:@"slider"]){
        if([propertyName isEqualToString:@"Position X"]){
            p = [[effects objectAtIndex:rowIndex] getPositionForTime:localCurrentTime];
            return [NSNumber numberWithFloat:0.5 + (float)p.x/(2.0*ProjectMovieSize.size.width)];
        } else if([propertyName isEqualToString:@"Position Y"]){
            p = [[effects objectAtIndex:rowIndex] getPositionForTime:localCurrentTime];
            return [NSNumber numberWithFloat:0.5 + (float)p.y/(2.0*ProjectMovieSize.size.height)];
        } else {
            return [NSNumber numberWithFloat:[[effects objectAtIndex:rowIndex] 
                                              getEffectValue:[valueNames objectAtIndex:rowIndex] 
                                              forTime:localCurrentTime]];
        }
    }        

    // 数字を表示するラベルのカラム
    if([[aTableColumn identifier] isEqualToString:@"number"]){
        if([propertyName isEqualToString:@"Position X"]){
            p = [[effects objectAtIndex:rowIndex] getPositionForTime:localCurrentTime];
            return [NSNumber numberWithFloat:p.x];
        } else if([propertyName isEqualToString:@"Position Y"]){
            p = [[effects objectAtIndex:rowIndex] getPositionForTime:localCurrentTime];
            return [NSNumber numberWithFloat:p.y];
        } else {
            return [NSNumber numberWithFloat:[[effects objectAtIndex:rowIndex]
                                              getEffectTrueValue:[valueNames objectAtIndex:rowIndex]
                                              forTime:localCurrentTime]];
        }
    }
    
    // 項目名のカラム
    return propertyName;
        
    }else{
        if([[aTableColumn identifier] isEqualToString:@"slider"])
            return [NSNumber numberWithFloat:[[effects lastObject] getVolumeForTime:globalCurrentTime]];
        if([[aTableColumn identifier] isEqualToString:@"number"])
            return [NSNumber numberWithFloat:[[effects lastObject] getVolumeForTime:globalCurrentTime]];
        
        return @"Volume";
    }
}

// slider cellの変更通知を受け取るところ。一括処理。
- (IBAction)sliderChanged:(id)sender
{
    NSString* propertyName;
    QTTime localCurrentTime;
    float x, y;
    int i = [_propertyView selectedRow];
    NSString* name = [propertyNames objectAtIndex:i];
    
    if(recording)
        localCurrentTime = [interestLayer convertToInnnerTime:globalCurrentTime];
    else 
        localCurrentTime = QTZeroTime;

    if([effects count] != 1){
    
    if([name isEqualToString:@"Position X"]){
//        p = [[effects objectAtIndex:i] getPositionForTime:localCurrentTime];
        x = [sender floatValue] * 2.0 * ProjectMovieSize.size.width - ProjectMovieSize.size.width;
//        [[effects objectAtIndex:i] setPosition:p forTime:localCurrentTime];
        [[effects objectAtIndex:i] setPositionX:x forTime:localCurrentTime];
    } else if([name isEqualToString:@"Position Y"]){
//        p = [[effects objectAtIndex:i] getPositionForTime:localCurrentTime];
        y = [sender floatValue] * 2.0 * ProjectMovieSize.size.height - ProjectMovieSize.size.height;
        [[effects objectAtIndex:i] setPositionY:y forTime:localCurrentTime];
    } else {
        [[effects objectAtIndex:i] setEffectValueForTime:[valueNames objectAtIndex:i] 
                                                   value:[sender floatValue] time:localCurrentTime];
    }
    }else {
        [[effects objectAtIndex:0] setVolume:[sender floatValue] forTime:localCurrentTime];
    }
    
        
    [_mainController refresh];
    [_timeLineController updateKeyframeLayer];
//    [_propertyView reloadData];
}

- (void)reload
{
    [_propertyView reloadData];
}

- (float)getSelectedValueForTime:(float)time
{
//    QTTime now = QTMakeTime(time*DEFAULT_FPS/timeLineScale, DEFAULT_FPS);
    QTTime now = [interestLayer plusOffsetTime:QTMakeTime(time*DEFAULT_FPS/timeLineScale, DEFAULT_FPS)];
//    int _rowIndex = [_propertyView selectedRow];
    NSPoint p;
    
    if([effects count] != 1){

    if([[propertyNames objectAtIndex:_rowIndex] isEqualToString:@"Position X"]){
        p = [[effects objectAtIndex:_rowIndex] getPositionForTime:now];
        return 0.5 + (float)p.x/(2.0*ProjectMovieSize.size.width);
    }

    if([[propertyNames objectAtIndex:_rowIndex] isEqualToString:@"Position Y"]){
        p = [[effects objectAtIndex:_rowIndex] getPositionForTime:now];
        return 0.5 + (float)p.y/(2.0*ProjectMovieSize.size.height);
    }
    
    return [[effects objectAtIndex:_rowIndex] getEffectValue:[valueNames objectAtIndex:_rowIndex] forTime:now];
        
    }else{
        return [[effects objectAtIndex:0] getVolumeForInnerTime:now];
    }
}

- (BOOL)isSelected
{
    return [_propertyView selectedRow] != -1;
}


-(BOOL)tableView:(NSTableView *)aTableView shouldSelectRow:(int)rowIndex
{
    _rowIndex = rowIndex;
    [_timeLineController updateKeyframeLayer];
    if(interestLayer) [_undoManager pushOperation:interestLayer];
    return YES;
}

- (void)removeAllKeyframe
{
    int index = [_propertyView selectedRow];

    if([effects count] != 1){
    
    if(interestLayer){
        [_undoManager pushOperation:interestLayer];
        if(index == 0)
            [interestLayer removePositionXKeyframe];
        else if(index == 1)
            [interestLayer removePositionYKerframe];
        else if(index == -1)
            return;
        else {
            [[effects objectAtIndex:index] removeKeyframe:[valueNames objectAtIndex:index]];
        }
        [_timeLineController updateKeyframeLayer];
    }
        
    }else{
            [_undoManager pushOperation:interestLayer];
    [interestLayer removeVolumeKeyframe];
            [_timeLineController updateKeyframeLayer];
    }
}

- (void)removeEffect
{
    int index = [_propertyView selectedRow];
    
    if(interestLayer){
        [_undoManager pushOperation:interestLayer];
        if(index <= 2) return;
        [interestLayer removeEffect:[effects objectAtIndex:index]];
        [self createPropertyTable:interestLayer];
        [self reload];
        [_timeLineController updateKeyframeLayer];
    }
}

- (BOOL)canRemoveAllKeyframe
{
    return [_propertyView selectedRow] > 2;
}

- (BOOL)canRemoveEffect
{
    return [_propertyView selectedRow] >= 5;
}

- (void)selectDefault
{
    _rowIndex = 0;
}

- (void)tableViewSelectionIsChanging:(NSNotification*)n
{

}

- (void)controlTextDidEndEditing:(NSNotification*)n
{
    int rowIndex = [_propertyView selectedRow];
    float x, y;
    NSString* name = [propertyNames objectAtIndex:rowIndex];
    QTTime localCurrentTime;
    float value = [[n object] floatValue];
    
    if(recording)
        localCurrentTime = [interestLayer convertToInnnerTime:globalCurrentTime];
    else 
        localCurrentTime = QTZeroTime;
    
    if([name isEqualToString:@"Position X"]){
//        x = [sender floatValue] * 2.0 * ProjectMovieSize.size.width - ProjectMovieSize.size.width;
        [[effects objectAtIndex:rowIndex] setPositionX:value forTime:localCurrentTime];
    } else if([name isEqualToString:@"Position Y"]){
//        y = [sender floatValue] * 2.0 * ProjectMovieSize.size.height - ProjectMovieSize.size.height;
        [[effects objectAtIndex:rowIndex] setPositionY:value forTime:localCurrentTime];
    } else {
        [[effects objectAtIndex:rowIndex] setEffectTrueValueForTime:[valueNames objectAtIndex:rowIndex] 
                                                              value:value time:localCurrentTime];
    }
    [self reload];
    [_mainController refresh];
}

@end
