//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisMovieSpeedController.m
//  Elis Colors
//
//  Created by 柳 on 09/09/29.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisMovieSpeedController.h"


@implementation ElisMovieSpeedController

- (id)init
{
    [NSBundle loadNibNamed:@"speed" owner:self];
    return self;
}

- (void)setMainWindow:(id)w
{
    _mainWindow = w;
}

- (void)setLayer:(ElisLayer*)l
{
    layer = l;
}

- (void)run
{
    float s = [layer speed];
    [_speedField setFloatValue:s*100];
    
    [NSApp beginSheet:_sheet modalForWindow:_mainWindow
        modalDelegate:self didEndSelector:nil contextInfo:nil];
}

- (IBAction)pushedOK:(id)sender
{
    float s = [_speedField floatValue];
    [layer setSpeed:s/100.0];
    
    [_sheet close];
    [NSApp endSheet:_sheet];
}

- (IBAction)pushedCancel:(id)sender
{
    [_sheet close];
    [NSApp endSheet:_sheet];
}

@end
