//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisMovieSizeWindowController.m
//  Elis Colors
//
//  Created by 柳 on 09/09/26.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisMovieSizeWindowController.h"


@implementation ElisMovieSizeWindowController

- (id)init
{
    [NSBundle loadNibNamed:@"movieSizeWindow" owner:self];
    return self;
}

- (void)run
{
    [_widthField setIntValue:(int)ProjectMovieSize.size.width];
    [_heightField setIntValue:(int)ProjectMovieSize.size.height];
    
    [NSApp beginSheet:_window modalForWindow:_mainWindow 
        modalDelegate:self didEndSelector:nil contextInfo:nil];
}

- (IBAction)pushedOK:(id)sender
{
    int x, y;
    x = [_widthField intValue];
    y = [_heightField intValue];
    
    if(x > 0 && y > 0){
        ProjectMovieSize.size.width = x;
        ProjectMovieSize.size.height = y;
    }
    
    [_window close];
    [NSApp endSheet:_window returnCode:NSCancelButton];
    
    [_mainView reshape];
}

- (IBAction)pushedCancel:(id)sender
{
    [_window close];
    [NSApp endSheet:_window];
}

- (void)setMainWindow:(NSWindow *)w
{
    _mainWindow = w;
}

- (void)setMainView:(id)v
{
    _mainView = v;
}

@end
