//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisMainView.m
//  Elis Colors
//
//  Created by 柳 on 09/09/12.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisMainView.h"

#import <objc/objc-auto.h>

#pragma mark Render Callback
static CVReturn MyRenderCallback(CVDisplayLinkRef displayLink, 
								 const CVTimeStamp *inNow, 
								 const CVTimeStamp *inOutputTime, 
								 CVOptionFlags flagsIn, 
								 CVOptionFlags *flagsOut, 
                                 void *displayLinkContext)
{
	return [(ElisMainView *)displayLinkContext getFrameForTime:inOutputTime flagsOut:flagsOut];
}

@implementation ElisMainView

- (void)awakeFromNib
{
    mainView = self;
    lock = [[NSRecursiveLock alloc] init];
    timeOffset = QTZeroTime;
//    layerSet = malloc(sizeof(void*) * TRACK_SIZE);
    layerSet = [[NSMutableArray alloc] init];
    sortedLayerSet = malloc(sizeof(void*) * TRACK_SIZE);
    printBorderLine = YES;
    rendering = NO;
    
//    [[NSGarbageCollector defaultCollector] disableCollectorForPointer:layerSet];
}

- (void)prepareOpenGL
{
    NSLog(@"Initializing OpenGL ...");
	GLint swapInterval = 1;
    
    glClearColor(0.0f, 0.0f, 0.0f, 0.0f);   // black background
	[[self openGLContext] setValues:&swapInterval forParameter:NSOpenGLCPSwapInterval];
    
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();
//    CGColorSpaceRef colorSpace = CGColorSpaceCreateWithName(kCGColorSpaceSRGB);
    ciContext = [CIContext contextWithCGLContext:[[self openGLContext] CGLContextObj]
                                      pixelFormat:[[self pixelFormat] CGLPixelFormatObj]
                                          options:[NSDictionary dictionaryWithObjectsAndKeys:(id)colorSpace, kCIContextOutputColorSpace,
                                                   (id)colorSpace, kCIContextWorkingColorSpace, nil]];
    
    CGColorSpaceRelease(colorSpace);
    
    CVDisplayLinkCreateWithCGDisplay(kCGDirectMainDisplay, &displayLink);
    if (NULL != displayLink) {
    	CVDisplayLinkSetCurrentCGDisplay(displayLink, kCGDirectMainDisplay);
        CVDisplayLinkSetOutputCallback(displayLink, &MyRenderCallback, self);
    }
    
    scale = 1.0;

//    [self setFrame:NSMakeRect(0, 0, 640/2, 480/2)];
    
    NSLog(@"Elis Colors, Stand by ready.");
}

#pragma mark Display Link
- (CVReturn)getFrameForTime:(CVTimeStamp*)timeStamp flagsOut:(CVOptionFlags*)flagsOut
{
    QTTime qt;
    NSDate* now;
    NSTimeInterval duration;
    now = [[NSDate alloc] init];
    duration = [now timeIntervalSinceDate:startTime]; // 再生を開始した時間と今の時間から経過時間を得る。
    qt = QTMakeTime(duration*600, 600); // 経過時間をQTTimeに変換。
    _qt = QTTimeIncrement(qt, timeOffset); // オフセットを足す。
    
    stamp = timeStamp;

    [layerSet removeAllObjects];
    [_mainController getFrameForTime:_qt result:layerSet];
    [self drawRect:NSZeroRect];

//    int i, size = [layerSet count];
//    for(i = 0; i < size; i++)
//        [[layerSet objectAtIndex:i] releaseContext];
    
    return kCVReturnSuccess;
}

- (void)getFrameForQTTime:(QTTime)time
{
    [layerSet removeAllObjects];
    [_mainController getFrameForTime:time result:layerSet];
    [self drawRectWithoutStamp:NSZeroRect forTime:time];
    
//    int i, size = [layerSet count];
//    for(i = 0; i < size; i++)
//        [[layerSet objectAtIndex:i] releaseContext];
}

- (void)drawRectWithoutStamp:(NSRect)rect forTime:(QTTime)time
{
    [lock lock];
    
    [[self openGLContext] makeCurrentContext];
    glClear(GL_COLOR_BUFFER_BIT);
    
    int i, size = [layerSet count];
    CIImage* ci, *ci_tr;
    NSPoint point;
    CGRect imageRect;
    CGPoint cp;
    NSRect frame = [self frame];
    NSSize originSize;
    float dx, dy;
    
    dx = (frame.size.width - ProjectMovieSize.size.width)/2;
    dy = (frame.size.height - ProjectMovieSize.size.height)/2;

    void** transition = malloc(sizeof(void*) * TRACK_SIZE);
    memset(transition, 0, sizeof(void*) * TRACK_SIZE);
    
    // トラック番号順にバケットソート
    memset(sortedLayerSet, 0, sizeof(void*) * TRACK_SIZE);
    for(i = 0; i < size; i++){
        if(sortedLayerSet[[[layerSet objectAtIndex:i] trackNumber]] == 0)
            sortedLayerSet[[[layerSet objectAtIndex:i] trackNumber]] = [layerSet objectAtIndex:i];
        else
            transition[[[layerSet objectAtIndex:i] trackNumber]] = [layerSet objectAtIndex:i];
    }
    
    for(i = 0; i < TRACK_SIZE; i++){
        if(sortedLayerSet[i] == 0) continue;
        
        ci = [sortedLayerSet[i] getEffectedImageWithoutStamp:time]; // 違いはここ。
        point = [sortedLayerSet[i] getPositionForTime:[sortedLayerSet[i] convertToInnnerTime:time]];
        originSize = [sortedLayerSet[i] originSize];
        if(ci == nil) continue; // サウンドレイヤーはスキップ
        if(transition[i] != 0){
//            ci_tr = [transition[i] getEffectedImageWithoutStamp:time];
//            CIFilter* tr = [CIFilter filterWithName:@"CIDissolveTransition"];
//            [tr setDefaults];
//            [tr setValue:ci forKey:@"inputImage"];
//            [tr setValue:ci_tr forKey:@"inputTargetImage"];
//            [tr setValue:[NSNumber numberWithFloat:0.5] forKey:@"inputTime"];
//            ci = [tr valueForKey:@"outputImage"];
        }
        imageRect = [ci extent];
        if(imageRect.size.width >= 4000){
            imageRect = CGRectMake(0.0, 0.0, 4000, 3000);
        }
        
        cp = *(CGPoint*)&point;
        if(rendering == NO){
            cp.x += dx;
            cp.y += dy;
        }
        cp.x -= (imageRect.size.width - originSize.width)/2;
        cp.y -= (imageRect.size.height - originSize.height)/2;
//        [ciContext drawImage:ci inRect:CGRectMake(point.x, point.y, imageRect.size.width, imageRect.size.height) fromRect:imageRect];
        [ciContext drawImage:ci atPoint:cp fromRect:imageRect];        
//        [ciContext drawImage:ci inRect:CGRectMake(point.x, point.y, 640, 480) fromRect:CGRectMake(0, 0, 640, 480)];
    }
    
    // 境界線を引く
    if(printBorderLine && rendering == NO){
        glBegin(GL_LINE_LOOP);
        glColor3d(0.7, 0.7, 0.7);
        glVertex2i(dx+1, dy+1);
        glVertex2i(ProjectMovieSize.size.width+1+dx, dy+1);
        glVertex2i(ProjectMovieSize.size.width+1+dx, ProjectMovieSize.size.height+1+dy);
        glVertex2i(dx+1, ProjectMovieSize.size.height+1+dy);
        glEnd();
    }
    
    glFlush();
    
    free(transition);
    
    // あとかたづけ
    for(i = 0; i < size; i++)
        [[layerSet objectAtIndex:i] releaseContext];
    
    [layerSet removeAllObjects];

    [lock unlock];
}

- (void)drawRect:(NSRect)rect
{
    [lock lock];
    
    [[self openGLContext] makeCurrentContext];
    glClear(GL_COLOR_BUFFER_BIT);

    int i, size = [layerSet count];
    CIImage* ci;
    NSPoint point;
    CGRect imageRect;
    CGPoint cp;
    NSRect frame = [self frame];
    NSSize originSize;
    float dx, dy;
    
    dx = (frame.size.width - ProjectMovieSize.size.width)/2;
    dy = (frame.size.height - ProjectMovieSize.size.height)/2;
    
    // トラック番号順にバケットソート
    memset(sortedLayerSet, 0, sizeof(void*) * TRACK_SIZE);
    for(i = 0; i < size; i++)
        sortedLayerSet[[[layerSet objectAtIndex:i] trackNumber]] = [layerSet objectAtIndex:i];

    for(i = 0; i < TRACK_SIZE; i++){
        if(sortedLayerSet[i] == 0) continue;

        ci = [sortedLayerSet[i] getEffectedImage:stamp forTime:_qt];
//        [[NSGarbageCollector defaultCollector] disableCollectorForPointer:ci];
        point = [sortedLayerSet[i] getPositionForTime:[sortedLayerSet[i] convertToInnnerTime:_qt]];
        originSize = [sortedLayerSet[i] originSize];
        if(ci == nil) continue; // サウンドレイヤーはスキップ
        
        imageRect = [ci extent];
        if(imageRect.size.width >= 4000){
            imageRect = CGRectMake(0, 0, 4000, 3000);
        }

        cp = *(CGPoint*)&point;
        cp.x += dx - (imageRect.size.width - originSize.width)/2;
        cp.y += dy - (imageRect.size.height - originSize.height)/2;
//        [ciContext drawImage:ci inRect:imageRect fromRect:CGRectMake(point.x, point.y, ProjectMovieSize.size.width, ProjectMovieSize.size.height)];
        [ciContext drawImage:ci atPoint:cp fromRect:imageRect];
        ci = nil;

//        [ciContext drawImage:ci inRect:CGRectMake(point.x, point.y, imageRect.size.width, imageRect.size.height)
//                    fromRect:imageRect];
    }
    
    // 境界線を引く
    if(printBorderLine){
        glBegin(GL_LINE_LOOP);
        glColor3d(0.7, 0.7, 0.7);
        glVertex2i(dx+1, dy+1);
        glVertex2i(ProjectMovieSize.size.width+1+dx, dy+1);
        glVertex2i(ProjectMovieSize.size.width+1+dx, ProjectMovieSize.size.height+1+dy);
        glVertex2i(dx+1, ProjectMovieSize.size.height+1+dy);
        glEnd();
    }
    
    glFlush();
    
    // あとかたづけ
    for(i = 0; i < size; i++)
        [[layerSet objectAtIndex:i] releaseContext];
    
    [layerSet removeAllObjects];

//    [[NSGarbageCollector defaultCollector] collectExhaustively];
    objc_collect(OBJC_RATIO_COLLECTION);
    
    [lock unlock];
}

- (void)reshape
{ 
	GLfloat minX, minY, maxX, maxY;
    
    NSRect sceneBounds = [self bounds];
 	NSRect frame = [self frame];
	
    minX = NSMinX(sceneBounds);
	minY = NSMinY(sceneBounds);
	maxX = NSMaxX(sceneBounds);
	maxY = NSMaxY(sceneBounds);
    
//    if(rendering)
//        glViewport(0, 0, (GLsizei)ProjectMovieSize.size.width, (GLsizei)ProjectMovieSize.size.height);
//    else
        glViewport(0, 0, (GLsizei)frame.size.width, (GLsizei)frame.size.height);	// set the viewport
    
    glMatrixMode(GL_MODELVIEW);    // select the modelview matrix
    glLoadIdentity();              // reset it
    
    glMatrixMode(GL_PROJECTION);   // select the projection matrix
    glLoadIdentity();              // reset it
    
//    if(rendering)
//        gluOrtho2D(minX, minX + ProjectMovieSize.size.width, minY, minY + ProjectMovieSize.size.height);
//    else
        gluOrtho2D(minX, maxX, minY, maxY);	// define a 2-D orthographic projection matrix
    
//    float scale;
//    if(frame.size.height < frame.size.width)
//        scale = frame.size.height/ProjectMovieSize.size.height;
//    else 
//        scale = frame.size.width/ProjectMovieSize.size.width;
    
//    glScalef(scale, scale, 1.0);
    
	glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);

}

- (void)stopDisplayLink
{
    [startTime release];
    startTime = nil;
    CVDisplayLinkStop(displayLink);
}

- (void)startDisplayLink
{
    startTime = [[NSDate alloc] init];
    CVDisplayLinkStart(displayLink);
}

- (void)seek:(QTTime)time
{
    timeOffset = time;
}

- (void)getCurrentPixelData:(NSRect)rect buffer:(void*)buffer
{    
    glPushClientAttrib(GL_CLIENT_PIXEL_STORE_BIT);
    glPixelStorei(GL_PACK_ALIGNMENT, 4);	
    glPixelStorei(GL_PACK_ROW_LENGTH, 0);
    glPixelStorei(GL_PACK_SKIP_ROWS, 0);
    glPixelStorei(GL_PACK_SKIP_PIXELS, 0);
    
    // これが公式の方法とかマジないわー。
    glReadPixels(0, 0, rect.size.width, rect.size.height, GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, buffer);
    
    glPopClientAttrib();
}

@end
