// utility for Windows		(C) H.Niwa 1993 - 2013

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */


#include "config.h"

#include <stdio.h>
#include <string>

#ifdef __MINGW32__
#include <windows.h>


void clswin(void)
{
	HANDLE hDisp;
	COORD dwWriteCoord;
	DWORD nLen;
	CONSOLE_SCREEN_BUFFER_INFO cinfo;

	hDisp = GetStdHandle(STD_OUTPUT_HANDLE);
	GetConsoleScreenBufferInfo(hDisp, &cinfo);

	nLen = cinfo.dwSize.X * cinfo.dwSize.Y;

	dwWriteCoord.X = dwWriteCoord.Y = 0;
	SetConsoleCursorPosition(hDisp, dwWriteCoord);

	FillConsoleOutputCharacter(hDisp, ' ', nLen, dwWriteCoord, NULL);
	FillConsoleOutputAttribute(hDisp,
			(FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE)
					, nLen, dwWriteCoord, NULL);

	SetConsoleTextAttribute(hDisp, cinfo.wAttributes);

}

int MemInfo(int& total, int& active)
{
	MEMORYSTATUS ms;

	GlobalMemoryStatus(&ms); 

	total = ms.dwTotalPhys;
	active = total - ms.dwAvailPhys;
	return 0;
}

#endif /* __MINGW32__ */

