/*
 * lexical code operation
 *
 *			(C) H.Niwa 1993-2010
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __PLLEX_H
#define __PLLEX_H

extern int Char;

#ifndef MAXPATHLEN
#define MAXPATHLEN  (4096)
#endif

#define	TOKEN_LEN	4096

extern const char* MESG;

extern long FilePointSave();
extern void FilePointResume(long tellpt);
extern int  NotSkipSpCOMP(const char* Pt);
extern int  COMP(const char* Pt);
extern int  LineNumber();
extern void ErrorStop(const char* fmt, ...);
extern void UNTIL(const char* s);
extern void SKIP(const char* s);
extern int  NotSkipSpNOT(const char* s);
extern int  NOT(const char* s);
extern int  C();
extern int  Eof();
extern int  NotEof();
extern int  N();
extern int  J();
extern int  A();
extern int  AN();
#undef SPACE
extern int  SPACE();
extern int  JA();
extern int  ANY();
extern int  WRD();
extern int  NUM();
extern int  ID();
extern int  CSTRINGS();
extern int  STRINGS();
extern int  CR();

void SetToken(int c);
void SkipSpace();

#endif  /* __PLLEX_H */
