/*
 * token operation program copyright (C) 2009 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __TOKEN_H
#define __TOKEN_H

extern int token(Context* cx, Node* goals, List* module);
extern void tokenSkipSpace(Context* cx);

extern int tokenCmpDirect(Context* cx, Node* goalscar, Node* goals, Node* md);

extern int tokenC(Context* cx, Node* goals);
extern int tokenEof(Context* cx, Node* goals);
extern int tokenN(Context* cx, Node* goals);
extern int tokenA(Context* cx, Node* goals);
extern int tokenAN(Context* cx, Node* goals);
extern int tokenCR(Context* cx, Node* goals);
extern int tokenCNTL(Context* cx, Node* goals);
extern int tokenSpace(Context* cx, Node* goals);
extern int tokenPunct(Context* cx, Node* goals);
extern int tokenStrings(Context* cx, Node* goals);
extern int tokenWORD(Context* cx, Node* goals);
extern int tokenNum(Context* cx, Node* goals);
extern int tokenFNum(Context* cx, Node* goals);
extern int tokenID(Context* cx, Node* goals);
extern int tokenRange(Context* cx, Node* goals);
extern int tokenNonRange(Context* cx, Node* goals);
extern int tokenGettoken(Context* cx, Node* goalscar);

#endif
