#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <map>
using namespace std;
#include "nwcc.h"
#include "nwcclex.h"

/*
 * parse program copyright (C) 2009 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <setjmp.h>

#include "syserr.h"
#include "pllex.h"

#include "bin_node.h"
#include "gc.h"
#include "var.h"
#include "pred.h"
#include "module.h"
#include "context.h"
#include "unify.h"
#include "func.h"

jmp_buf program_jb;

Node *r_head;
Node *r_literal;
Node *r_body;
Node *r_clause;
Node *r_defobj;
Node *r_inherit;
Node *r_pred;
Node *r_proc;
Node *r_node;
Node *r_term_node;
Node *r_list;
Node *r_loop;
Node *r_alt;
Node *r_var;
Node *r_obj;
Node *r_class;
Node *r_term;
Node *r_name;
Node *r_expression;
Node *r_exp_plsmns;
Node *r_exp_muldiv;
Node *r_proc_letf;
Node *r_proc_leti;
Node *r_proc_rpnf;
Node *r_proc_rpni;
Node *r_proc_comparef;
Node *r_proc_comparei;
Node *r_comparing;
Node *r_comp_and;
Node *r_comp_not;
Node *r_comp_gl;

Node *varlist = Nil;

void
RegisterVar (Var * v)
{
  varlist = Cons (v, varlist);
}

Var *
SearchVar (char *s)
{
  Node *p;
  for (p = varlist; p != Nil; p = p->Cdr ())
    {
      if (((Var *) (p->Car ()))->Name () == s)
	{
	  return ((Var *) p->Car ());
	}
    }
  return NULL;
}

Var *
GetVar (char *s)
{
  if (strcmp (s, "_") != 0)
    {
      Var *v = SearchVar (s);
      if (v != NULL)
	{
	  return v;
	}
    }
  Var *r = new Var (s);
  RegisterVar (r);
  return r;
}

void
ClearVar ()
{
  varlist = Nil;
}

int
NOTSPACE ()
{
  extern int Char;
  extern int pllexCkSpace (int c);

  C ();

  switch (Char)
    {
    case '\"':
    case '\'':
    case '!':
    case '#':
    case '&':
    case '\%':
    case '(':
    case ')':
    case '*':
    case '+':
    case '-':
    case '/':
    case ':':
    case ';':
    case '<':
    case '=':
    case '>':
    case '?':
    case '[':
    case ']':
    case '{':
    case '}':
    case '|':
      UnGetChar (Char);
      return -1;
    }


  if (Char <= ' ')
    {
      UnGetChar (Char);
      return -1;
    }

  if (pllexCkSpace (Char))
    {
      UnGetChar (Char);
      return -1;
    }


  return 0;
}

int
HEXNUM ()
{
  extern int Char;
  extern int C ();

  SkipSpace ();

  tokenPt = 0;

  C ();
  if (Char != '0')
    {
      UnGetChar (Char);
      return -1;
    }
  SetToken (Char);

  C ();
  if (Char != 'x')
    {
      UnGetChar (Char);
      UnGetChar ('0');
      return -1;
    }
  SetToken (Char);

  for (;;)
    {
      C ();
      if (isdigit (Char)
	  || ((Char >= 'a') && (Char <= 'f'))
	  || ((Char >= 'A') && (Char <= 'F')))
	{
	  SetToken (Char);
	}
      else
	{
	  UnGetChar (Char);
	  SetToken ('\0');
	  break;
	}
    }
  unsigned long long n = strtoll (TOKEN, (char **) NULL, 16);
  snprintf (TOKEN, TOKEN_LEN, "%lld\0", n);
  return 0;
}


char *InputSuffics = "pl";
char *OutputSuffics = "c";
int
NwccMain ()
{
  int program ();
  ErrorFlg = program ();
  if (ErrorFlg)
    ErrorStop (MESG);
  return 0;
}

int
program ()
{

  extern int ErrorStopFlag;
  ErrorStopFlag = 0;

  if (setjmp (program_jb) != 0)
    {
      CXNode = NULL;
      ErrorStopFlag = 0;
//                                      printf("# %d : error\n", LineNumber());
      return 0;
    }

  ErrorFlg = 0;
  MESG = NULL;
  do
    {
      long chktell1, chktell2;
      chktell1 = FilePointSave ();
      ErrorFlg = COMP (";");
      MESG = "\";\" is missing ";
      if (ErrorFlg)
	{
	}
      if (!ErrorFlg)
	{
	}
      if (ErrorFlg)
	{
	  int goal ();
	  ErrorFlg = goal ();
	  MESG = "goal is missing ";
	  if (ErrorFlg)
	    {
	    }
	  if (!ErrorFlg)
	    {
	    }
	}
      if (ErrorFlg)
	{
	  int declare ();
	  ErrorFlg = declare ();
	  MESG = "declare is missing ";
	  if (ErrorFlg)
	    {
	    }
	  if (!ErrorFlg)
	    {
	    }
	}
      chktell2 = FilePointSave ();
      if ((chktell1 == chktell2) && !ErrorFlg)
	ErrorStop ("endless loop occured");
    }
  while (!ErrorFlg);
  ErrorFlg = 0;
  MESG = NULL;
  if (!ErrorFlg)
    {
    }
  return ErrorFlg;
}

int
goal ()
{
  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("?");
  MESG = "\"?\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {

      Node *l_goalnodes;
      int orflag = 0;
      Node *l_goal = Nil;
      int r;
      ClearVar ();

      int node ();
      ErrorFlg = node ();
      MESG = "node is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      l_goal = MkList (r_node);
      do
	{
	  long chktell1, chktell2;
	  chktell1 = FilePointSave ();
	  {
	    int nloop = 0;
	    do
	      {
		long chktell1, chktell2;
		chktell1 = FilePointSave ();
		ErrorFlg = COMP ("|");
		MESG = "\"|\" is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {

		    orflag++;
		    if (orflag == 1)
		      {
			l_goal = MkPred (MkList (mka ("or"), l_goal));

		      }
		    l_goalnodes = Nil;

		  }
		if (!ErrorFlg)
		  nloop++;
	      }
	    while (0);
	  }
	  if (!ErrorFlg)
	    {
	    }
	  if (ErrorFlg)
	    {
	      {
		int nloop = 0;
		do
		  {
		    long chktell1, chktell2;
		    chktell1 = FilePointSave ();
		    int node ();
		    ErrorFlg = node ();
		    MESG = "node is missing ";
		    if (ErrorFlg)
		      {
		      }
		    if (!ErrorFlg)
		      {

			if (orflag == 0)
			  {
			    l_goal = Append (l_goal, MkList (r_node));
			  }
			else
			  {
			    if (l_goalnodes == Nil)
			      {
				l_goalnodes = MkList (r_node);
				l_goal = Append (l_goal,
						 MkList (l_goalnodes));
			      }
			    else
			      {
				l_goalnodes
				  = Append (l_goalnodes, MkList (r_node));
			      }
			  }

		      }
		    if (!ErrorFlg)
		      nloop++;
		  }
		while (0);
	      }
	      if (!ErrorFlg)
		{
		}
	    }
	  chktell2 = FilePointSave ();
	  if ((chktell1 == chktell2) && !ErrorFlg)
	    ErrorStop ("endless loop occured");
	}
      while (!ErrorFlg);
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      ErrorFlg = COMP (";");
      MESG = "\";\" is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);

      extern int TraceFlag;
      extern int incflag;
      if (TraceFlag)
	{
	  PrintNode ("? ", l_goal);
	}

      incflag = 0;

      Context cxr (Module);
      Context *cx = &cxr;

      l_goal = l_goal->Val ();

      cxpush (cx, l_goal);
//                                 r = FuncPred(cx, l_goal);
      r = Unify (cx, l_goal);

      cxpop (cx);

      if (!incflag)
	{
	  printf ("\n");
//                                      PrintNode("result -- ", l_goal);
	  printf ("result -- \n");
//                                      PPmoduleBody(1, l_goal);
	  l_goal->print ();
	  printf ("\n");
	  if (r == 1)
	    {
	      printf ("-- true\n\n");
	    }
	  else if (r == 0)
	    {
	      printf ("-- false\n\n");
	    }
	  else
	    {			// -1
	      printf ("-- unknown\n\n");
	    }
	}
      ClearVar ();

//                                 PPmodule(Module); printf("\n");

      if (cx != 0)
	{
	  cx->Clear ();
	  cx = 0;
	}
      GC ();

    }
  return ErrorFlg;
}

int
literal ()
{
  ErrorFlg = 0;
  MESG = NULL;
  int pred ();
  ErrorFlg = pred ();
  MESG = "pred is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      r_literal = r_pred;
    }
  return ErrorFlg;
}

int
declare ()
{
  ErrorFlg = 0;
  MESG = NULL;
  int defobj ();
  ErrorFlg = defobj ();
  MESG = "defobj is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      Assert (Module, r_defobj);
    }
  if (ErrorFlg)
    {
      int clause ();
      ErrorFlg = clause ();
      MESG = "clause is missing ";
      if (ErrorFlg)
	{
	}
      if (!ErrorFlg)
	{
	  Assert (Module, r_clause);
	}
    }
  return ErrorFlg;
}

int
clause ()
{
  Node *l_clause = Nil;
  ClearVar ();
  ErrorFlg = 0;
  MESG = NULL;
  int head ();
  ErrorFlg = head ();
  MESG = "head is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      int body ();
      ErrorFlg = body ();
      MESG = "body is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      ErrorFlg = COMP (";");
      MESG = "\";\" is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);

      if (r_body == Nil)
	{
	  l_clause = MkList (r_head);
	}
      else
	{
	  if (r_body->kind () != LIST)
	    {
	      r_body = MkList (r_body);
	    }
	  l_clause = Cons (r_head, r_body);
	}
      ClearVar ();
      r_clause = l_clause;

    }
  return ErrorFlg;
}

int
head ()
{
  ErrorFlg = 0;
  MESG = NULL;
  int pred ();
  ErrorFlg = pred ();
  MESG = "pred is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      r_head = r_pred;
    }
  return ErrorFlg;
}

int
body ()
{

  Node *r_bodynodes;
  int orflag = 0;
  r_body = Nil;

  ErrorFlg = 0;
  MESG = NULL;
  do
    {
      long chktell1, chktell2;
      chktell1 = FilePointSave ();
      {
	int nloop = 0;
	do
	  {
	    long chktell1, chktell2;
	    chktell1 = FilePointSave ();
	    ErrorFlg = COMP ("|");
	    MESG = "\"|\" is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {

		orflag++;
		if (orflag == 1)
		  {
		    r_body = MkPred (MkList (mka ("or"), r_body));
		  }
		r_bodynodes = Nil;

	      }
	    if (!ErrorFlg)
	      nloop++;
	  }
	while (0);
      }
      if (!ErrorFlg)
	{
	}
      if (ErrorFlg)
	{
	  {
	    int nloop = 0;
	    do
	      {
		long chktell1, chktell2;
		chktell1 = FilePointSave ();
		int node ();
		ErrorFlg = node ();
		MESG = "node is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {

		    if (orflag == 0)
		      {
			r_body = Append (r_body, MkList (r_node));
		      }
		    else
		      {
			if (r_bodynodes == Nil)
			  {
			    r_bodynodes = MkList (r_node);
			    r_body = Append (r_body, MkList (r_bodynodes));
			  }
			else
			  {
			    r_bodynodes
			      = Append (r_bodynodes, MkList (r_node));
			  }
		      }

		  }
		if (!ErrorFlg)
		  nloop++;
	      }
	    while (0);
	  }
	  if (!ErrorFlg)
	    {
	    }
	}
      chktell2 = FilePointSave ();
      if ((chktell1 == chktell2) && !ErrorFlg)
	ErrorStop ("endless loop occured");
    }
  while (!ErrorFlg);
  ErrorFlg = 0;
  MESG = NULL;
  if (!ErrorFlg)
    {
    }
  return ErrorFlg;
}

int
defobj ()
{

  Node *l_defobj;

  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("::");
  MESG = "\"::\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      ErrorFlg = COMP ("<");
      MESG = "\"<\" is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      int node ();
      ErrorFlg = node ();
      MESG = "node is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      l_defobj = MkList (r_node);
      do
	{
	  long chktell1, chktell2;
	  chktell1 = FilePointSave ();
	  int clause ();
	  ErrorFlg = clause ();
	  MESG = "clause is missing ";
	  if (ErrorFlg)
	    {
	    }
	  if (!ErrorFlg)
	    {
	      l_defobj = Append (l_defobj, MkList (r_clause));
	    }
	  if (ErrorFlg)
	    {
	      int inherit ();
	      ErrorFlg = inherit ();
	      MESG = "inherit is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_defobj = Append (l_defobj, MkList (r_inherit));
		}
	    }
	  chktell2 = FilePointSave ();
	  if ((chktell1 == chktell2) && !ErrorFlg)
	    ErrorStop ("endless loop occured");
	}
      while (!ErrorFlg);
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      ErrorFlg = COMP (">");
      MESG = "\">\" is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      ErrorFlg = COMP (";");
      MESG = "\";\" is missing ";
      if (ErrorFlg)
	{
	}
      if (!ErrorFlg)
	{
	}
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      r_defobj = MkList (MkPred (l_defobj));
    }
  return ErrorFlg;
}

int
inherit ()
{
  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("inherit");
  MESG = "\"inherit\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      int term ();
      ErrorFlg = term ();
      MESG = "term is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      ErrorFlg = COMP (";");
      MESG = "\";\" is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      r_inherit = MkList (mka ("inherit"), r_term);
    }
  return ErrorFlg;
}

int
pred ()
{

  Node *l_pred;
  int dotflg = 0;
  Node *lastnode;

  ErrorFlg = 0;
  MESG = NULL;
  {
    int nloop = 0;
    do
      {
	long chktell1, chktell2;
	chktell1 = FilePointSave ();
	{
	  int nloop = 0;
	  do
	    {
	      long chktell1, chktell2;
	      chktell1 = FilePointSave ();
	      ErrorFlg = COMP ("<");
	      MESG = "\"<\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_pred = Nil;
		  {
		    int nloop = 0;
		    do
		      {
			long chktell1, chktell2;
			chktell1 = FilePointSave ();
			ErrorFlg = COMP ("!");
			MESG = "\"!\" is missing ";
			if (ErrorFlg)
			  {
			  }
			if (!ErrorFlg)
			  {
			    l_pred = MkList (mka ("!"));
			  }
			if (ErrorFlg)
			  {
			    int proc_rpnf ();
			    ErrorFlg = proc_rpnf ();
			    MESG = "proc_rpnf is missing ";
			    if (ErrorFlg)
			      {
			      }
			    if (!ErrorFlg)
			      {
				l_pred = r_proc_rpnf;
			      }
			  }
			if (ErrorFlg)
			  {
			    int proc_rpni ();
			    ErrorFlg = proc_rpni ();
			    MESG = "proc_rpni is missing ";
			    if (ErrorFlg)
			      {
			      }
			    if (!ErrorFlg)
			      {
				l_pred = r_proc_rpni;
			      }
			  }
			if (ErrorFlg)
			  {
			    int proc_comparef ();
			    ErrorFlg = proc_comparef ();
			    MESG = "proc_comparef is missing ";
			    if (ErrorFlg)
			      {
			      }
			    if (!ErrorFlg)
			      {
				l_pred = r_proc_comparef;
			      }
			  }
			if (ErrorFlg)
			  {
			    int proc_comparei ();
			    ErrorFlg = proc_comparei ();
			    MESG = "proc_comparei is missing ";
			    if (ErrorFlg)
			      {
			      }
			    if (!ErrorFlg)
			      {
				l_pred = r_proc_comparei;
			      }
			  }
			if (ErrorFlg)
			  {
			    int proc_letf ();
			    ErrorFlg = proc_letf ();
			    MESG = "proc_letf is missing ";
			    if (ErrorFlg)
			      {
			      }
			    if (!ErrorFlg)
			      {
				l_pred = r_proc_letf;
			      }
			  }
			if (ErrorFlg)
			  {
			    int proc_leti ();
			    ErrorFlg = proc_leti ();
			    MESG = "proc_leti is missing ";
			    if (ErrorFlg)
			      {
			      }
			    if (!ErrorFlg)
			      {
				l_pred = r_proc_leti;
			      }
			  }
			if (ErrorFlg)
			  {
			    int proc_leti2 ();
			    ErrorFlg = proc_leti2 ();
			    MESG = "proc_leti2 is missing ";
			    if (ErrorFlg)
			      {
			      }
			    if (!ErrorFlg)
			      {
				l_pred = r_proc_leti;
			      }
			  }
			if (ErrorFlg)
			  {
			    {
			      int nloop = 0;
			      do
				{
				  long chktell1, chktell2;
				  chktell1 = FilePointSave ();
				  int node ();
				  ErrorFlg = node ();
				  MESG = "node is missing ";
				  if (ErrorFlg)
				    {
				    }
				  if (!ErrorFlg)
				    {
				      l_pred = lastnode = MkList (r_node);
				      do
					{
					  long chktell1, chktell2;
					  chktell1 = FilePointSave ();
					  int node ();
					  ErrorFlg = node ();
					  MESG = "node is missing ";
					  if (ErrorFlg)
					    {
					    }
					  if (!ErrorFlg)
					    {
					      l_pred = Append (l_pred,
							       lastnode =
							       MkList
							       (r_node));
					    }
					  chktell2 = FilePointSave ();
					  if ((chktell1 == chktell2)
					      && !ErrorFlg)
					    ErrorStop
					      ("endless loop occured");
					}
				      while (!ErrorFlg);
				      ErrorFlg = 0;
				      MESG = NULL;
				      if (ErrorFlg)
					ErrorStop (MESG);
				      ErrorFlg = COMP (":");
				      MESG = "\":\" is missing ";
				      if (ErrorFlg)
					{
					}
				      if (!ErrorFlg)
					{
					  int node ();
					  ErrorFlg = node ();
					  MESG = "node is missing ";
					  if (ErrorFlg)
					    {
					    }
					  if (ErrorFlg)
					    ErrorStop (MESG);
					  ((List *) lastnode)->
					    SetCdr (r_node);
					}
				      ErrorFlg = 0;
				      MESG = NULL;
				      if (ErrorFlg)
					ErrorStop (MESG);
				    }
				  if (!ErrorFlg)
				    nloop++;
				}
			      while (0);
			    }
			    if (!ErrorFlg)
			      {
			      }
			  }
			if (!ErrorFlg)
			  nloop++;
		      }
		    while (0);
		  }
		  if (ErrorFlg)
		    ErrorStop (MESG);
		  ErrorFlg = COMP (">");
		  MESG = "\">\" is missing ";
		  if (ErrorFlg)
		    {
		    }
		  if (ErrorFlg)
		    ErrorStop (MESG);
		}
	      if (!ErrorFlg)
		nloop++;
	    }
	  while (0);
	}
	if (!ErrorFlg)
	  {
	  }
	if (!ErrorFlg)
	  nloop++;
      }
    while (0);
  }
  if (!ErrorFlg)
    {
      r_pred = MkPred (l_pred);
    }
  return ErrorFlg;
}

int
list ()
{

  Node *l_listnodes;
  int orflag = 0;
  Node *l_list = Nil;

  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("(");
  MESG = "\"(\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      do
	{
	  long chktell1, chktell2;
	  chktell1 = FilePointSave ();
	  {
	    int nloop = 0;
	    do
	      {
		long chktell1, chktell2;
		chktell1 = FilePointSave ();
		ErrorFlg = COMP ("|");
		MESG = "\"|\" is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {

		    orflag++;
		    if (orflag == 1)
		      {
			l_list = MkPred (MkList (mka ("or"), l_list));
		      }
		    l_listnodes = Nil;

		  }
		if (!ErrorFlg)
		  nloop++;
	      }
	    while (0);
	  }
	  if (!ErrorFlg)
	    {
	    }
	  if (ErrorFlg)
	    {
	      {
		int nloop = 0;
		do
		  {
		    long chktell1, chktell2;
		    chktell1 = FilePointSave ();
		    int node ();
		    ErrorFlg = node ();
		    MESG = "node is missing ";
		    if (ErrorFlg)
		      {
		      }
		    if (!ErrorFlg)
		      {

			if (orflag == 0)
			  {
			    l_list = Append (l_list, MkList (r_node));
			  }
			else
			  {
			    if (l_listnodes == Nil)
			      {
				l_listnodes = MkList (r_node);
				l_list = Append (l_list,
						 MkList (l_listnodes));
			      }
			    else
			      {
				l_listnodes
				  = Append (l_listnodes, MkList (r_node));
			      }
			  }

		      }
		    if (!ErrorFlg)
		      nloop++;
		  }
		while (0);
	      }
	      if (!ErrorFlg)
		{
		}
	    }
	  chktell2 = FilePointSave ();
	  if ((chktell1 == chktell2) && !ErrorFlg)
	    ErrorStop ("endless loop occured");
	}
      while (!ErrorFlg);
      ErrorFlg = 0;
      MESG = NULL;
      if (!ErrorFlg)
	{
	  {
	    int nloop = 0;
	    do
	      {
		long chktell1, chktell2;
		chktell1 = FilePointSave ();
		ErrorFlg = COMP (":");
		MESG = "\":\" is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {
		    int node ();
		    ErrorFlg = node ();
		    MESG = "node is missing ";
		    if (ErrorFlg)
		      {
		      }
		    if (ErrorFlg)
		      ErrorStop (MESG);

		    if (orflag == 0)
		      {
			l_list = Append (l_list, r_node);
		      }
		    else
		      {
			if (l_listnodes == Nil)
			  {
			    l_listnodes = MkList (r_node);
			    l_list = Append (l_list, l_listnodes);
			  }
			else
			  {
			    l_listnodes = Append (l_listnodes, r_node);
			  }
		      }

		  }
		if (!ErrorFlg)
		  nloop++;
	      }
	    while (0);
	  }
	  if (!ErrorFlg)
	    {
	    }
	  ErrorFlg = 0;
	  MESG = NULL;
	  if (ErrorFlg)
	    ErrorStop (MESG);
	}
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      ErrorFlg = COMP (")");
      MESG = "\")\" is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      r_list = l_list;
    }
  return ErrorFlg;
}

int
obj ()
{
  Node *l_obj;
  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("::");
  MESG = "\"::\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      int obj_name ();
      ErrorFlg = obj_name ();
      MESG = "obj_name is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      l_obj = MkList (mka ("obj"), r_class);
      int pred ();
      ErrorFlg = pred ();
      MESG = "pred is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      r_obj = MkPred (Append (l_obj, MkList (r_pred)));
    }
  return ErrorFlg;
}

int
node ()
{
  ErrorFlg = 0;
  MESG = NULL;
  {
    int nloop = 0;
    do
      {
	long chktell1, chktell2;
	chktell1 = FilePointSave ();
	int obj ();
	ErrorFlg = obj ();
	MESG = "obj is missing ";
	if (ErrorFlg)
	  {
	  }
	if (!ErrorFlg)
	  {
	    r_node = r_obj;
	  }
	if (ErrorFlg)
	  {
	    int pred ();
	    ErrorFlg = pred ();
	    MESG = "pred is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		r_node = r_pred;
	      }
	  }
	if (ErrorFlg)
	  {
	    int list ();
	    ErrorFlg = list ();
	    MESG = "list is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		r_node = r_list;
	      }
	  }
	if (ErrorFlg)
	  {
	    int loop ();
	    ErrorFlg = loop ();
	    MESG = "loop is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		r_node = r_loop;
	      }
	  }
	if (ErrorFlg)
	  {
	    int alt ();
	    ErrorFlg = alt ();
	    MESG = "alt is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		r_node = r_alt;
	      }
	  }
	if (ErrorFlg)
	  {
	    int var ();
	    ErrorFlg = var ();
	    MESG = "var is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		r_node = r_var;
	      }
	  }
	if (ErrorFlg)
	  {
	    {
	      int nloop = 0;
	      do
		{
		  long chktell1, chktell2;
		  chktell1 = FilePointSave ();
		  ErrorFlg = COMP ("+");
		  MESG = "\"+\" is missing ";
		  if (ErrorFlg)
		    {
		    }
		  if (!ErrorFlg)
		    {
		      {
			int nloop = 0;
			do
			  {
			    long chktell1, chktell2;
			    chktell1 = FilePointSave ();
			    int HEXNUM ();
			    ErrorFlg = HEXNUM ();
			    MESG = "HEXNUM is missing ";
			    if (ErrorFlg)
			      {
			      }
			    if (!ErrorFlg)
			      {
				r_node = mka (TOKEN);
			      }
			    if (ErrorFlg)
			      {
				int FNUM ();
				ErrorFlg = FNUM ();
				MESG = "FNUM is missing ";
				if (ErrorFlg)
				  {
				  }
				if (!ErrorFlg)
				  {
				    r_node = mka (TOKEN);
				  }
			      }
			    if (!ErrorFlg)
			      nloop++;
			  }
			while (0);
		      }
		      if (ErrorFlg)
			ErrorStop (MESG);
		    }
		  if (!ErrorFlg)
		    nloop++;
		}
	      while (0);
	    }
	    if (!ErrorFlg)
	      {
	      }
	  }
	if (ErrorFlg)
	  {
	    {
	      int nloop = 0;
	      do
		{
		  long chktell1, chktell2;
		  chktell1 = FilePointSave ();
		  ErrorFlg = COMP ("-");
		  MESG = "\"-\" is missing ";
		  if (ErrorFlg)
		    {
		    }
		  if (!ErrorFlg)
		    {
		      {
			int nloop = 0;
			do
			  {
			    long chktell1, chktell2;
			    chktell1 = FilePointSave ();
			    int HEXNUM ();
			    ErrorFlg = HEXNUM ();
			    MESG = "HEXNUM is missing ";
			    if (ErrorFlg)
			      {
			      }
			    if (!ErrorFlg)
			      {
				std::string s = "-";
				s = s + TOKEN;
				r_node = mka ((char *) s.c_str ());
			      }
			    if (ErrorFlg)
			      {
				int FNUM ();
				ErrorFlg = FNUM ();
				MESG = "FNUM is missing ";
				if (ErrorFlg)
				  {
				  }
				if (!ErrorFlg)
				  {
				    std::string s = "-";
				    s = s + TOKEN;
				    r_node = mka ((char *) s.c_str ());
				  }
			      }
			    if (!ErrorFlg)
			      nloop++;
			  }
			while (0);
		      }
		      if (ErrorFlg)
			ErrorStop (MESG);
		    }
		  if (!ErrorFlg)
		    nloop++;
		}
	      while (0);
	    }
	    if (!ErrorFlg)
	      {
	      }
	  }
	if (ErrorFlg)
	  {
	    int HEXNUM ();
	    ErrorFlg = HEXNUM ();
	    MESG = "HEXNUM is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		r_node = mka (TOKEN);
	      }
	  }
	if (ErrorFlg)
	  {
	    int FNUM ();
	    ErrorFlg = FNUM ();
	    MESG = "FNUM is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		r_node = mka (TOKEN);
	      }
	  }
	if (ErrorFlg)
	  {
	    int term ();
	    ErrorFlg = term ();
	    MESG = "term is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		r_node = r_term;
	      }
	  }
	if (!ErrorFlg)
	  nloop++;
      }
    while (0);
  }
  if (!ErrorFlg)
    {
    }
  return ErrorFlg;
}

int
loop ()
{

  Node *l_loopnodes;
  int orflag = 0;
  Node *l_loop = Nil;

  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("{");
  MESG = "\"{\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      do
	{
	  long chktell1, chktell2;
	  chktell1 = FilePointSave ();
	  {
	    int nloop = 0;
	    do
	      {
		long chktell1, chktell2;
		chktell1 = FilePointSave ();
		ErrorFlg = COMP ("|");
		MESG = "\"|\" is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {

		    orflag++;
		    if (orflag == 1)
		      {
			l_loop = MkPred (MkList (mka ("or"), l_loop));
		      }
		    l_loopnodes = Nil;

		  }
		if (!ErrorFlg)
		  nloop++;
	      }
	    while (0);
	  }
	  if (!ErrorFlg)
	    {
	    }
	  if (ErrorFlg)
	    {
	      {
		int nloop = 0;
		do
		  {
		    long chktell1, chktell2;
		    chktell1 = FilePointSave ();
		    int node ();
		    ErrorFlg = node ();
		    MESG = "node is missing ";
		    if (ErrorFlg)
		      {
		      }
		    if (!ErrorFlg)
		      {

			if (orflag == 0)
			  {
			    l_loop = Append (l_loop, MkList (r_node));
			  }
			else
			  {
			    if (l_loopnodes == Nil)
			      {
				l_loopnodes = MkList (r_node);
				l_loop = Append (l_loop,
						 MkList (l_loopnodes));
			      }
			    else
			      {
				l_loopnodes
				  = Append (l_loopnodes, MkList (r_node));
			      }
			  }

		      }
		    if (!ErrorFlg)
		      nloop++;
		  }
		while (0);
	      }
	      if (!ErrorFlg)
		{
		}
	    }
	  chktell2 = FilePointSave ();
	  if ((chktell1 == chktell2) && !ErrorFlg)
	    ErrorStop ("endless loop occured");
	}
      while (!ErrorFlg);
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      ErrorFlg = COMP ("}");
      MESG = "\"}\" is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      r_loop = MkPred (Cons (mka ("loop"), MkList (l_loop)));
    }
  return ErrorFlg;
}

int
alt ()
{

  Node *l_altnodes;
  int orflag = 0;
  Node *l_alt = Nil;

  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("[");
  MESG = "\"[\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      do
	{
	  long chktell1, chktell2;
	  chktell1 = FilePointSave ();
	  {
	    int nloop = 0;
	    do
	      {
		long chktell1, chktell2;
		chktell1 = FilePointSave ();
		ErrorFlg = COMP ("|");
		MESG = "\"|\" is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {

		    orflag++;
		    if (orflag == 1)
		      {
			l_alt = MkPred (MkList (mka ("or"), l_alt));
		      }
		    l_altnodes = Nil;

		  }
		if (!ErrorFlg)
		  nloop++;
	      }
	    while (0);
	  }
	  if (!ErrorFlg)
	    {
	    }
	  if (ErrorFlg)
	    {
	      {
		int nloop = 0;
		do
		  {
		    long chktell1, chktell2;
		    chktell1 = FilePointSave ();
		    int node ();
		    ErrorFlg = node ();
		    MESG = "node is missing ";
		    if (ErrorFlg)
		      {
		      }
		    if (!ErrorFlg)
		      {

			if (orflag == 0)
			  {
			    l_alt = Append (l_alt, MkList (r_node));
			  }
			else
			  {
			    if (l_altnodes == Nil)
			      {
				l_altnodes = MkList (r_node);
				l_alt = Append (l_alt, MkList (l_altnodes));
			      }
			    else
			      {
				l_altnodes
				  = Append (l_altnodes, MkList (r_node));
			      }
			  }

		      }
		    if (!ErrorFlg)
		      nloop++;
		  }
		while (0);
	      }
	      if (!ErrorFlg)
		{
		}
	    }
	  chktell2 = FilePointSave ();
	  if ((chktell1 == chktell2) && !ErrorFlg)
	    ErrorStop ("endless loop occured");
	}
      while (!ErrorFlg);
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      ErrorFlg = COMP ("]");
      MESG = "\"]\" is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);

      r_alt = MkPred (Cons (mka ("alt"), MkList (l_alt)));

    }
  return ErrorFlg;
}

int
var ()
{
  ErrorFlg = 0;
  MESG = NULL;
  {
    int nloop = 0;
    do
      {
	long chktell1, chktell2;
	chktell1 = FilePointSave ();
	{
	  int nloop = 0;
	  do
	    {
	      long chktell1, chktell2;
	      chktell1 = FilePointSave ();
	      ErrorFlg = COMP ("_");
	      MESG = "\"_\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		nloop++;
	    }
	  while (0);
	}
	if (!ErrorFlg)
	  {
	    r_var = GetVar ("_");
	  }
	if (ErrorFlg)
	  {
	    {
	      int nloop = 0;
	      do
		{
		  long chktell1, chktell2;
		  chktell1 = FilePointSave ();
		  ErrorFlg = COMP ("#");
		  MESG = "\"#\" is missing ";
		  if (ErrorFlg)
		    {
		    }
		  if (!ErrorFlg)
		    {
		      int Word ();
		      ErrorFlg = Word ();
		      MESG = "Word is missing ";
		      if (ErrorFlg)
			{
			}
		      if (ErrorFlg)
			ErrorStop (MESG);

		      string buf = "#";
		      buf = buf + TOKEN;
		      r_var = GetVar ((char *) buf.c_str ());

		    }
		  if (!ErrorFlg)
		    nloop++;
		}
	      while (0);
	    }
	    if (!ErrorFlg)
	      {
	      }
	  }
	if (!ErrorFlg)
	  nloop++;
      }
    while (0);
  }
  if (!ErrorFlg)
    {
    }
  return ErrorFlg;
}

int
obj_name ()
{
  ErrorFlg = 0;
  MESG = NULL;
  int Word ();
  ErrorFlg = Word ();
  MESG = "Word is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      r_class = mka (TOKEN);
    }
  return ErrorFlg;
}

int
term ()
{
  ErrorFlg = 0;
  MESG = NULL;
  int Word ();
  ErrorFlg = Word ();
  MESG = "Word is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      r_term = mka (TOKEN);
    }
  return ErrorFlg;
}

int
name ()
{
  ErrorFlg = 0;
  MESG = NULL;
  int Word ();
  ErrorFlg = Word ();
  MESG = "Word is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      r_name = mka (TOKEN);
    }
  return ErrorFlg;
}

int
expression ()
{
  Node *l_expression;
  ErrorFlg = 0;
  MESG = NULL;
  int exp_plsmns ();
  ErrorFlg = exp_plsmns ();
  MESG = "exp_plsmns is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      l_expression = r_exp_plsmns;
      do
	{
	  long chktell1, chktell2;
	  chktell1 = FilePointSave ();
	  {
	    int nloop = 0;
	    do
	      {
		long chktell1, chktell2;
		chktell1 = FilePointSave ();
		ErrorFlg = COMP ("+");
		MESG = "\"+\" is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {
		    l_expression = Append (l_expression, MkList (mka ("+")));
		  }
		if (ErrorFlg)
		  {
		    ErrorFlg = COMP ("-");
		    MESG = "\"-\" is missing ";
		    if (ErrorFlg)
		      {
		      }
		    if (!ErrorFlg)
		      {
			l_expression = Append (l_expression,
					       MkList (mka ("-")));
		      }
		  }
		if (!ErrorFlg)
		  nloop++;
	      }
	    while (0);
	  }
	  if (!ErrorFlg)
	    {
	      int exp_plsmns ();
	      ErrorFlg = exp_plsmns ();
	      MESG = "exp_plsmns is missing ";
	      if (ErrorFlg)
		{
		}
	      if (ErrorFlg)
		ErrorStop (MESG);
	      l_expression = Append (l_expression, r_exp_plsmns);
	    }
	  chktell2 = FilePointSave ();
	  if ((chktell1 == chktell2) && !ErrorFlg)
	    ErrorStop ("endless loop occured");
	}
      while (!ErrorFlg);
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      r_expression = l_expression;
    }
  return ErrorFlg;
}

int
exp_plsmns ()
{
  Node *l_exp_plsmns;
  ErrorFlg = 0;
  MESG = NULL;
  int exp_muldiv ();
  ErrorFlg = exp_muldiv ();
  MESG = "exp_muldiv is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      l_exp_plsmns = r_exp_muldiv;
      do
	{
	  long chktell1, chktell2;
	  chktell1 = FilePointSave ();
	  {
	    int nloop = 0;
	    do
	      {
		long chktell1, chktell2;
		chktell1 = FilePointSave ();
		ErrorFlg = COMP ("*");
		MESG = "\"*\" is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {
		    l_exp_plsmns = Append (l_exp_plsmns, MkList (mka ("*")));
		  }
		if (ErrorFlg)
		  {
		    ErrorFlg = COMP ("/");
		    MESG = "\"/\" is missing ";
		    if (ErrorFlg)
		      {
		      }
		    if (!ErrorFlg)
		      {
			l_exp_plsmns =
			  Append (l_exp_plsmns, MkList (mka ("/")));
		      }
		  }
		if (ErrorFlg)
		  {
		    ErrorFlg = COMP ("%");
		    MESG = "\"%\" is missing ";
		    if (ErrorFlg)
		      {
		      }
		    if (!ErrorFlg)
		      {
			l_exp_plsmns =
			  Append (l_exp_plsmns, MkList (mka ("%")));
		      }
		  }
		if (!ErrorFlg)
		  nloop++;
	      }
	    while (0);
	  }
	  if (!ErrorFlg)
	    {
	      int exp_muldiv ();
	      ErrorFlg = exp_muldiv ();
	      MESG = "exp_muldiv is missing ";
	      if (ErrorFlg)
		{
		}
	      if (ErrorFlg)
		ErrorStop (MESG);
	      l_exp_plsmns = Append (l_exp_plsmns, r_exp_muldiv);
	    }
	  chktell2 = FilePointSave ();
	  if ((chktell1 == chktell2) && !ErrorFlg)
	    ErrorStop ("endless loop occured");
	}
      while (!ErrorFlg);
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      r_exp_plsmns = l_exp_plsmns;
    }
  return ErrorFlg;
}

int
term_node ()
{
  std::string s;
  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("+");
  MESG = "\"+\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      s = "+";
    }
  if (ErrorFlg)
    {
      ErrorFlg = COMP ("-");
      MESG = "\"-\" is missing ";
      if (ErrorFlg)
	{
	}
      if (!ErrorFlg)
	{
	  s = "-";
	}
    }
  ErrorFlg = 0;
  MESG = NULL;
  if (!ErrorFlg)
    {
      {
	int nloop = 0;
	do
	  {
	    long chktell1, chktell2;
	    chktell1 = FilePointSave ();
	    int obj ();
	    ErrorFlg = obj ();
	    MESG = "obj is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		if (s == "-")
		  {
		    r_term_node = MkList (mka ("-1"), mka ("*"), r_obj);

		  }
		else
		  {
		    r_term_node = MkList (r_obj);
		  }

	      }
	    if (ErrorFlg)
	      {
		int pred ();
		ErrorFlg = pred ();
		MESG = "pred is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {
		    if (s == "-")
		      {
			r_term_node = MkList (mka ("-1"), mka ("*"), r_pred);

		      }
		    else
		      {
			r_term_node = MkList (r_pred);
		      }

		  }
	      }
	    if (ErrorFlg)
	      {
		int var ();
		ErrorFlg = var ();
		MESG = "var is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {
		    if (s == "-")
		      {
			r_term_node = MkList (mka ("-1"), mka ("*"), r_var);

		      }
		    else
		      {
			r_term_node = MkList (r_var);
		      }

		  }
	      }
	    if (ErrorFlg)
	      {
		int HEXNUM ();
		ErrorFlg = HEXNUM ();
		MESG = "HEXNUM is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {

		    s += TOKEN;
		    r_term_node = MkList (mka ((char *) s.c_str ()));

		  }
	      }
	    if (ErrorFlg)
	      {
		int FNUM ();
		ErrorFlg = FNUM ();
		MESG = "FNUM is missing ";
		if (ErrorFlg)
		  {
		  }
		if (!ErrorFlg)
		  {

		    s += TOKEN;
		    r_term_node = MkList (mka ((char *) s.c_str ()));

		  }
	      }
	    if (!ErrorFlg)
	      nloop++;
	  }
	while (0);
      }
      if (ErrorFlg)
	ErrorStop (MESG);
    }
  return ErrorFlg;
}

int
exp_muldiv ()
{
  ErrorFlg = 0;
  MESG = NULL;
  {
    int nloop = 0;
    do
      {
	long chktell1, chktell2;
	chktell1 = FilePointSave ();
	{
	  int nloop = 0;
	  do
	    {
	      long chktell1, chktell2;
	      chktell1 = FilePointSave ();
	      ErrorFlg = COMP ("(");
	      MESG = "\"(\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  int expression ();
		  ErrorFlg = expression ();
		  MESG = "expression is missing ";
		  if (ErrorFlg)
		    {
		    }
		  if (ErrorFlg)
		    ErrorStop (MESG);
		  ErrorFlg = COMP (")");
		  MESG = "\")\" is missing ";
		  if (ErrorFlg)
		    {
		    }
		  if (ErrorFlg)
		    ErrorStop (MESG);
		  r_exp_muldiv = MkList (r_expression);
		}
	      if (!ErrorFlg)
		nloop++;
	    }
	  while (0);
	}
	if (!ErrorFlg)
	  {
	  }
	if (ErrorFlg)
	  {
	    int term_node ();
	    ErrorFlg = term_node ();
	    MESG = "term_node is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		r_exp_muldiv = r_term_node;
	      }
	  }
	if (!ErrorFlg)
	  nloop++;
      }
    while (0);
  }
  if (!ErrorFlg)
    {
    }
  return ErrorFlg;
}

int
comparing ()
{
  Node *l_comp_or = Nil;
  ErrorFlg = 0;
  MESG = NULL;
  int comp_and ();
  ErrorFlg = comp_and ();
  MESG = "comp_and is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      l_comp_or = r_comp_and;
      ErrorFlg = COMP ("or");
      MESG = "\"or\" is missing ";
      if (ErrorFlg)
	{
	}
      if (!ErrorFlg)
	{
	  int comp_and ();
	  ErrorFlg = comp_and ();
	  MESG = "comp_and is missing ";
	  if (ErrorFlg)
	    {
	    }
	  if (ErrorFlg)
	    ErrorStop (MESG);
	  l_comp_or = MkList (l_comp_or, mka ("or"), r_comp_and);
	}
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      r_comparing = l_comp_or;
    }
  return ErrorFlg;
}

int
comp_and ()
{
  Node *l_comp_and = Nil;
  ErrorFlg = 0;
  MESG = NULL;
  int comp_not ();
  ErrorFlg = comp_not ();
  MESG = "comp_not is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      l_comp_and = r_comp_not;
      ErrorFlg = COMP ("and");
      MESG = "\"and\" is missing ";
      if (ErrorFlg)
	{
	}
      if (!ErrorFlg)
	{
	  int comp_not ();
	  ErrorFlg = comp_not ();
	  MESG = "comp_not is missing ";
	  if (ErrorFlg)
	    {
	    }
	  if (ErrorFlg)
	    ErrorStop (MESG);
	  l_comp_and = MkList (l_comp_and, mka ("and"), r_comp_not);
	}
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      r_comp_and = l_comp_and;
    }
  return ErrorFlg;
}

int
comp_not ()
{
  Node *l_comp_not = Nil;
  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("not");
  MESG = "\"not\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      l_comp_not = (MkList (mka ("not")));
    }
  ErrorFlg = 0;
  MESG = NULL;
  if (!ErrorFlg)
    {
      int comp_gl ();
      ErrorFlg = comp_gl ();
      MESG = "comp_gl is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      if (l_comp_not == Nil)
	{
	  l_comp_not = r_comp_gl;
	}
      else
	{
	  l_comp_not = Append (l_comp_not, MkList (r_comp_gl));
	}

      r_comp_not = l_comp_not;
    }
  return ErrorFlg;
}

int
comp_gl ()
{
  Node *l_comp_gl;
  ErrorFlg = 0;
  MESG = NULL;
  {
    int nloop = 0;
    do
      {
	long chktell1, chktell2;
	chktell1 = FilePointSave ();
	{
	  int nloop = 0;
	  do
	    {
	      long chktell1, chktell2;
	      chktell1 = FilePointSave ();
	      ErrorFlg = COMP ("(");
	      MESG = "\"(\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  int comparing ();
		  ErrorFlg = comparing ();
		  MESG = "comparing is missing ";
		  if (ErrorFlg)
		    {
		    }
		  if (ErrorFlg)
		    ErrorStop (MESG);
		  ErrorFlg = COMP (")");
		  MESG = "\")\" is missing ";
		  if (ErrorFlg)
		    {
		    }
		  if (ErrorFlg)
		    ErrorStop (MESG);
		  r_comp_gl = r_comparing;
		}
	      if (!ErrorFlg)
		nloop++;
	    }
	  while (0);
	}
	if (!ErrorFlg)
	  {
	  }
	if (ErrorFlg)
	  {
	    {
	      int nloop = 0;
	      do
		{
		  long chktell1, chktell2;
		  chktell1 = FilePointSave ();
		  int expression ();
		  ErrorFlg = expression ();
		  MESG = "expression is missing ";
		  if (ErrorFlg)
		    {
		    }
		  if (!ErrorFlg)
		    {
		      l_comp_gl = r_expression;
		      {
			int nloop = 0;
			do
			  {
			    long chktell1, chktell2;
			    chktell1 = FilePointSave ();
			    ErrorFlg = COMP ("==");
			    MESG = "\"==\" is missing ";
			    if (ErrorFlg)
			      {
			      }
			    if (!ErrorFlg)
			      {
				l_comp_gl =
				  Append (l_comp_gl, MkList (mka ("==")));
			      }
			    if (ErrorFlg)
			      {
				ErrorFlg = COMP ("=");
				MESG = "\"=\" is missing ";
				if (ErrorFlg)
				  {
				  }
				if (!ErrorFlg)
				  {
				    l_comp_gl =
				      Append (l_comp_gl, MkList (mka ("=")));
				  }
			      }
			    if (ErrorFlg)
			      {
				ErrorFlg = COMP ("<>");
				MESG = "\"<>\" is missing ";
				if (ErrorFlg)
				  {
				  }
				if (!ErrorFlg)
				  {
				    l_comp_gl =
				      Append (l_comp_gl, MkList (mka ("<>")));
				  }
			      }
			    if (ErrorFlg)
			      {
				ErrorFlg = COMP ("!=");
				MESG = "\"!=\" is missing ";
				if (ErrorFlg)
				  {
				  }
				if (!ErrorFlg)
				  {
				    l_comp_gl =
				      Append (l_comp_gl, MkList (mka ("!=")));
				  }
			      }
			    if (ErrorFlg)
			      {
				ErrorFlg = COMP ("=");
				MESG = "\"=\" is missing ";
				if (ErrorFlg)
				  {
				  }
				if (!ErrorFlg)
				  {
				    l_comp_gl =
				      Append (l_comp_gl, MkList (mka ("=")));
				  }
			      }
			    if (ErrorFlg)
			      {
				ErrorFlg = COMP (">=");
				MESG = "\">=\" is missing ";
				if (ErrorFlg)
				  {
				  }
				if (!ErrorFlg)
				  {
				    l_comp_gl =
				      Append (l_comp_gl, MkList (mka (">=")));
				  }
			      }
			    if (ErrorFlg)
			      {
				ErrorFlg = COMP (">");
				MESG = "\">\" is missing ";
				if (ErrorFlg)
				  {
				  }
				if (!ErrorFlg)
				  {
				    l_comp_gl =
				      Append (l_comp_gl, MkList (mka (">")));
				  }
			      }
			    if (ErrorFlg)
			      {
				ErrorFlg = COMP ("<=");
				MESG = "\"<=\" is missing ";
				if (ErrorFlg)
				  {
				  }
				if (!ErrorFlg)
				  {
				    l_comp_gl =
				      Append (l_comp_gl, MkList (mka ("<=")));
				  }
			      }
			    if (ErrorFlg)
			      {
				ErrorFlg = COMP ("<");
				MESG = "\"<\" is missing ";
				if (ErrorFlg)
				  {
				  }
				if (!ErrorFlg)
				  {
				    l_comp_gl =
				      Append (l_comp_gl, MkList (mka ("<")));
				  }
			      }
			    if (!ErrorFlg)
			      nloop++;
			  }
			while (0);
		      }
		      if (ErrorFlg)
			ErrorStop (MESG);
		      int expression ();
		      ErrorFlg = expression ();
		      MESG = "expression is missing ";
		      if (ErrorFlg)
			{
			}
		      if (ErrorFlg)
			ErrorStop (MESG);

		      l_comp_gl = Append (l_comp_gl, r_expression);
		      r_comp_gl = l_comp_gl;

		    }
		  if (!ErrorFlg)
		    nloop++;
		}
	      while (0);
	    }
	    if (!ErrorFlg)
	      {
	      }
	  }
	if (!ErrorFlg)
	  nloop++;
      }
    while (0);
  }
  if (!ErrorFlg)
    {
    }
  return ErrorFlg;
}

int
proc_letf ()
{
  Node *l_proc_letf;
  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("letf");
  MESG = "\"letf\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      int var ();
      ErrorFlg = var ();
      MESG = "var is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      ErrorFlg = COMP ("=");
      MESG = "\"=\" is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      l_proc_letf = MkList (mka ("letf"), r_var, mka ("="));

      int expression ();
      ErrorFlg = expression ();
      MESG = "expression is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);

      // r_expression->print(); printf("\n");
      r_proc_letf = l_proc_letf;
      r_proc_letf = Append (r_proc_letf, r_expression);


    }
  return ErrorFlg;
}

int
proc_leti2 ()
{
  Node *l_proc_leti;
  ErrorFlg = 0;
  MESG = NULL;
  int var ();
  ErrorFlg = var ();
  MESG = "var is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      ErrorFlg = COMP ("=");
      MESG = "\"=\" is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      l_proc_leti = MkList (mka ("let"), r_var, mka ("="));

      int expression ();
      ErrorFlg = expression ();
      MESG = "expression is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);

      // r_expression->print(); printf("\n");
      r_proc_leti = l_proc_leti;
      r_proc_leti = Append (r_proc_leti, r_expression);


    }
  return ErrorFlg;
}

int
proc_leti ()
{
  Node *l_proc_leti;
  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("let");
  MESG = "\"let\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      int var ();
      ErrorFlg = var ();
      MESG = "var is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      ErrorFlg = COMP ("=");
      MESG = "\"=\" is missing ";
      if (ErrorFlg)
	{
	}
      if (!ErrorFlg)
	{
	}
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      l_proc_leti = MkList (mka ("let"), r_var, mka ("="));

      int expression ();
      ErrorFlg = expression ();
      MESG = "expression is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);

      // r_expression->print(); printf("\n");
      r_proc_leti = l_proc_leti;
      r_proc_leti = Append (r_proc_leti, r_expression);


    }
  return ErrorFlg;
}

int
proc_comparef ()
{
  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("comparef");
  MESG = "\"comparef\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      int comparing ();
      ErrorFlg = comparing ();
      MESG = "comparing is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      r_proc_comparef = MkList (mka ("comparef"));
      r_proc_comparef = Append (r_proc_comparef, r_comparing);

    }
  return ErrorFlg;
}

int
proc_comparei ()
{
  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("compare");
  MESG = "\"compare\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      int comparing ();
      ErrorFlg = comparing ();
      MESG = "comparing is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      r_proc_comparei = MkList (mka ("compare"));
      r_proc_comparei = Append (r_proc_comparei, r_comparing);

    }
  return ErrorFlg;
}

int
proc_rpnf ()
{
  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("rpnf");
  MESG = "\"rpnf\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      Node *l_proc_rpnf = MkList (mka ("rpnf"));
      int var ();
      ErrorFlg = var ();
      MESG = "var is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      l_proc_rpnf = Append (l_proc_rpnf, MkList (r_var));
      do
	{
	  long chktell1, chktell2;
	  chktell1 = FilePointSave ();
	  ErrorFlg = COMP ("+");
	  MESG = "\"+\" is missing ";
	  if (ErrorFlg)
	    {
	    }
	  if (!ErrorFlg)
	    {
	      l_proc_rpnf = Append (l_proc_rpnf, MkList (mka ("+")));
	    }
	  if (ErrorFlg)
	    {
	      ErrorFlg = COMP ("-");
	      MESG = "\"-\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpnf = Append (l_proc_rpnf, MkList (mka ("-")));
		}
	    }
	  if (ErrorFlg)
	    {
	      ErrorFlg = COMP ("*");
	      MESG = "\"*\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpnf = Append (l_proc_rpnf, MkList (mka ("*")));
		}
	    }
	  if (ErrorFlg)
	    {
	      ErrorFlg = COMP ("/");
	      MESG = "\"/\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpnf = Append (l_proc_rpnf, MkList (mka ("/")));
		}
	    }
	  if (ErrorFlg)
	    {
	      ErrorFlg = COMP ("%");
	      MESG = "\"%\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpnf = Append (l_proc_rpnf, MkList (mka ("%")));
		}
	    }
	  if (ErrorFlg)
	    {
	      int var ();
	      ErrorFlg = var ();
	      MESG = "var is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpnf = Append (l_proc_rpnf, MkList (r_var));
		}
	    }
	  if (ErrorFlg)
	    {
	      int obj ();
	      ErrorFlg = obj ();
	      MESG = "obj is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpnf = Append (l_proc_rpnf, MkList (r_obj));
		}
	    }
	  if (ErrorFlg)
	    {
	      int pred ();
	      ErrorFlg = pred ();
	      MESG = "pred is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpnf = Append (l_proc_rpnf, MkList (r_pred));
		}
	    }
	  if (ErrorFlg)
	    {
	      int term ();
	      ErrorFlg = term ();
	      MESG = "term is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpnf = Append (l_proc_rpnf, MkList (r_term));
		}
	    }
	  chktell2 = FilePointSave ();
	  if ((chktell1 == chktell2) && !ErrorFlg)
	    ErrorStop ("endless loop occured");
	}
      while (!ErrorFlg);
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      r_proc_rpnf = l_proc_rpnf;
    }
  return ErrorFlg;
}

int
proc_rpni ()
{
  ErrorFlg = 0;
  MESG = NULL;
  ErrorFlg = COMP ("rpn");
  MESG = "\"rpn\" is missing ";
  if (ErrorFlg)
    {
    }
  if (!ErrorFlg)
    {
      Node *l_proc_rpni = MkList (mka ("rpn"));
      int var ();
      ErrorFlg = var ();
      MESG = "var is missing ";
      if (ErrorFlg)
	{
	}
      if (ErrorFlg)
	ErrorStop (MESG);
      l_proc_rpni = Append (l_proc_rpni, MkList (r_var));
      do
	{
	  long chktell1, chktell2;
	  chktell1 = FilePointSave ();
	  ErrorFlg = COMP ("+");
	  MESG = "\"+\" is missing ";
	  if (ErrorFlg)
	    {
	    }
	  if (!ErrorFlg)
	    {
	      l_proc_rpni = Append (l_proc_rpni, MkList (mka ("+")));
	    }
	  if (ErrorFlg)
	    {
	      ErrorFlg = COMP ("-");
	      MESG = "\"-\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpni = Append (l_proc_rpni, MkList (mka ("-")));
		}
	    }
	  if (ErrorFlg)
	    {
	      ErrorFlg = COMP ("*");
	      MESG = "\"*\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpni = Append (l_proc_rpni, MkList (mka ("*")));
		}
	    }
	  if (ErrorFlg)
	    {
	      ErrorFlg = COMP ("/");
	      MESG = "\"/\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpni = Append (l_proc_rpni, MkList (mka ("/")));
		}
	    }
	  if (ErrorFlg)
	    {
	      ErrorFlg = COMP ("%");
	      MESG = "\"%\" is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpni = Append (l_proc_rpni, MkList (mka ("%")));
		}
	    }
	  if (ErrorFlg)
	    {
	      int var ();
	      ErrorFlg = var ();
	      MESG = "var is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpni = Append (l_proc_rpni, MkList (r_var));
		}
	    }
	  if (ErrorFlg)
	    {
	      int obj ();
	      ErrorFlg = obj ();
	      MESG = "obj is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpni = Append (l_proc_rpni, MkList (r_obj));
		}
	    }
	  if (ErrorFlg)
	    {
	      int pred ();
	      ErrorFlg = pred ();
	      MESG = "pred is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpni = Append (l_proc_rpni, MkList (r_pred));
		}
	    }
	  if (ErrorFlg)
	    {
	      int term ();
	      ErrorFlg = term ();
	      MESG = "term is missing ";
	      if (ErrorFlg)
		{
		}
	      if (!ErrorFlg)
		{
		  l_proc_rpni = Append (l_proc_rpni, MkList (r_term));
		}
	    }
	  chktell2 = FilePointSave ();
	  if ((chktell1 == chktell2) && !ErrorFlg)
	    ErrorStop ("endless loop occured");
	}
      while (!ErrorFlg);
      ErrorFlg = 0;
      MESG = NULL;
      if (ErrorFlg)
	ErrorStop (MESG);
      r_proc_rpni = l_proc_rpni;
    }
  return ErrorFlg;
}

int
Word ()
{
  string s;
  ErrorFlg = 0;
  MESG = NULL;
  {
    int nloop = 0;
    do
      {
	long chktell1, chktell2;
	chktell1 = FilePointSave ();
	ErrorFlg = COMP ("-");
	MESG = "\"-\" is missing ";
	if (ErrorFlg)
	  {
	  }
	if (!ErrorFlg)
	  {
	    int NUM ();
	    ErrorFlg = NUM ();
	    MESG = "NUM is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (ErrorFlg)
	      ErrorStop (MESG);
	    s = TOKEN;
	    snprintf (TOKEN, TOKEN_LEN, "-%s", s.c_str ());

	  }
	if (!ErrorFlg)
	  nloop++;
      }
    while (0);
  }
  if (!ErrorFlg)
    {
    }
  if (ErrorFlg)
    {
      {
	int nloop = 0;
	do
	  {
	    long chktell1, chktell2;
	    chktell1 = FilePointSave ();
	    ErrorFlg = COMP ("+");
	    MESG = "\"+\" is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		int NUM ();
		ErrorFlg = NUM ();
		MESG = "NUM is missing ";
		if (ErrorFlg)
		  {
		  }
		if (ErrorFlg)
		  ErrorStop (MESG);
		s = TOKEN;
		snprintf (TOKEN, TOKEN_LEN, "+%s", s.c_str ());

	      }
	    if (!ErrorFlg)
	      nloop++;
	  }
	while (0);
      }
      if (!ErrorFlg)
	{
	}
    }
  if (ErrorFlg)
    {
      int STRINGS ();
      ErrorFlg = STRINGS ();
      MESG = "STRINGS is missing ";
      if (ErrorFlg)
	{
	}
      if (!ErrorFlg)
	{
	}
    }
  if (ErrorFlg)
    {
      int WordBlock ();
      ErrorFlg = WordBlock ();
      MESG = "WordBlock is missing ";
      if (ErrorFlg)
	{
	}
      if (!ErrorFlg)
	{
	}
    }
  return ErrorFlg;
}

int
WordBlock ()
{
  {
    extern int Char;
    long tellsave;
    tokenPt = 0;
    tellsave = FilePointSave ();
    SkipSpace ();

    ErrorFlg = 0;
    MESG = NULL;
    int NOTSPACE ();
    ErrorFlg = NOTSPACE ();
    MESG = "NOTSPACE is missing ";
    if (ErrorFlg)
      {
	{
	  FilePointResume (tellsave);
	}
      }
    if (!ErrorFlg)
      {
	SetToken (Char);
	do
	  {
	    long chktell1, chktell2;
	    chktell1 = FilePointSave ();
	    int NOTSPACE ();
	    ErrorFlg = NOTSPACE ();
	    MESG = "NOTSPACE is missing ";
	    if (ErrorFlg)
	      {
	      }
	    if (!ErrorFlg)
	      {
		SetToken (Char);
	      }
	    chktell2 = FilePointSave ();
	    if ((chktell1 == chktell2) && !ErrorFlg)
	      ErrorStop ("endless loop occured");
	  }
	while (!ErrorFlg);
	ErrorFlg = 0;
	MESG = NULL;
	if (!ErrorFlg)
	  {
	  }
	ErrorFlg = 0;
	MESG = NULL;
	if (ErrorFlg)
	  ErrorStop (MESG);

	SetToken ('\0');
      }

  }
  return ErrorFlg;
}
