/*
 * sys module program copyright (C) 2009 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __SYSMODULE_H
#define __SYSMODULE_H


// program start time
struct ProgTime {
	long long	start_time;
	clock_t		start_utime;
	clock_t		start_stime;
};

extern struct ProgTime progtime;

// lib path
#define DLIBPATH	"DLIBPATH"
extern Node* dlibpathnode;
extern void GetLibPath();

// TMP path
#define TMPPATH		"TMP"
extern char*	tmppath;
extern void GetTmpPath();

extern int sysmodule(Context* cx, Node* goalscar, Node* goalscdr,
					Node* goals, List* module, int& r);
extern int GetlineEval();

extern int AutoGetLine(Context* cx, Node* goals);
extern int WriteNl(Context* cx, Node* goalscar, List* module);

extern int DoDelVar(Context* cx, Node* goalscar, List* module);

#endif 


