import std.string;
public import derelict.sdl2.sdl;

static this()
{
	DerelictSDL2.load();
	check(!SDL_Init(SDL_INIT_EVERYTHING));
}

static ~this()
{
	SDL_Quit();
	DerelictSDL2.unload();
}

private string CtoDString(const char* c)
{
	char[] str;
	for(size_t i; c[i] != '\0'; i++)
	{
		str ~= c[i];
	}
	return cast(immutable)str;
}

class SDLException : Exception
{
	private static void check(bool succeed, string file = __FILE__, size_t line = __LINE__)
	{
		if(succeed) return;
		throw new SDLException(file, line);
	}

	private this(string file = __FILE__, size_t line = __LINE__)
	{
		string msg = CtoDString(SDL_GetError());
		super(msg, file, line);
		SDL_ClearError();
	}
}
private alias SDLException.check check;

class Window
{
	private SDL_Window* _window;

	this(const(char)[] title, int x, int y, int w, int h, uint flags)
	{
		_window = SDL_CreateWindow(toStringz(title), x, y, w, h, flags);
		check(_window != null);
	}

	~this()
	{
		SDL_DestroyWindow(_window);
	}
}