//---------------------------------------------------------------------------
// R[hϊAsϊ
//---------------------------------------------------------------------------
#include <vcl.h>
#include <windows.h>
#include <fstream>
#pragma hdrstop
#pragma package(smart_init)

#include "KCodeConv.h"

//---------------------------------------------------------------------------
const int CHECK_LENGTH = 1000;//sR[h╶R[h𒲂ׂő̒

//---------------------------------------------------------------------------
HINSTANCE KCodeConv::hNKF32=NULL;
bool KCodeConv::bNKF32Exists = false;
char *KCodeConv::CodeChar[] = {"SJIS","EUC","JIS","UTF-8"};
char *KCodeConv::DelimiterChar[] = {"LF","CR","CRLF"};
char *CodeOptionTo[] = {"s","e","j","w"};
char *CodeOptionFrom[] = {"S","E","J","W"};
//---------------------------------------------------------------------------
/**
 * t@CTCYԂ(oCgP)
 */
int
KCodeConv::GetFileSize(char *filename) {
  WIN32_FIND_DATA f_data;
  FindFirstFile(filename,&f_data);
  if(f_data.nFileSizeHigh !=0) {
    //4MKȏ̃t@CJƂĂ
    ShowMessage("Too Large File Size");
    return 0;
  }
  return f_data.nFileSizeLow;
}
//---------------------------------------------------------------------------
/**
 * R[hԂ
 */
int
KCodeConv::GetCodeType(char *filename) {
  unsigned char buf[CHECK_LENGTH];
  int filesize= GetFileSize(filename);

  //t@CTCY̎擾Ɏs
  if(filesize == 0) {
    return C_SJIS;
  }

  int search_length = CHECK_LENGTH;
  if(filesize < search_length) {
    search_length = filesize;
  }

  std::ifstream ifs(filename, std::ios::in | std::ios::binary);
  ifs.read(buf,search_length);
  ifs.close();

  int len = search_length;

  // JIS
  for(int i=0;i<len-2;i++) {
    if(buf[i] == 0x1B && buf[i+1] == 0x24 && buf[i+2] == 0x42) {
      return C_JIS;
    }
  }

  //{ꂪ܂܂ĂȂꍇ̃`FbN
  bool onlyASCII = true;
  for(int i=0;i<len;i++){
    if(buf[i] >= 0x80){
      onlyASCII = false;
      break;
    }
  }

  //{ꂪ܂܂ĂȂƂ́ASJISƂĂ
  if(onlyASCII) {
    return C_SJIS;
  }

  //UTF-8 
  bool isUTF8 = true;

  for(int i=0;i<len-2;i++) {

    if (buf[i] >= 0xE0 && buf[i] <= 0xEF){
      if (buf[i+1] < 0x80 || buf[i+1] > 0xbf) {
        isUTF8 = false;
        break;
      }
      if (buf[i+2] < 0x80 || buf[i+2] > 0xbf) {
        isUTF8 = false;
        break;
      }
      i+=2;
    }
  }

  if(isUTF8){
    return C_UTF8;
  }

  int sjis = 0;
  int euc = 0;
  for(int i=0;i<len-2;i++) {
    if((buf[i] &0x80) && !(buf[i+1] & 0x80)) {
      sjis++;
      i++;
    }
    if((buf[i] & 0x80) && (buf[i+1] & 0x80)) {
      if(buf[i]>0xA1 && buf[i] < 0xFE && buf[i+1]>0xA1 && buf[i+1] < 0xFE){
        euc++;
      }
      i++;
    }
  }
  if(sjis<euc){
    return C_EUC;
  }
  return C_SJIS;
}
//---------------------------------------------------------------------------
/**
 * NKF32̃IvV쐬
 */
AnsiString
KCodeConv::GetConvertOption(int FromCode, int ToCode) {
  AnsiString Opt = "-";
  Opt += CodeOptionFrom[FromCode];
  Opt += CodeOptionTo[ToCode];
  return Opt;
}
//---------------------------------------------------------------------------
// tgGh
//---------------------------------------------------------------------------
/**
 * Textw肳ꂽR[hAsR[hŕۑ
 * ctype R[h
 * dtype sR[h
 */
void
KCodeConv::SaveConvertedFile(AnsiString FileName,AnsiString Text,int ctype, int dtype) {
  TMemoryStream *ms = new TMemoryStream;

  if(NKF32Exists()) {
    ConvertCode(ms,Text.c_str(),ctype);
  } else {
    ms->Write(Text.c_str(),Text.Length());
  }

  ConvertDelimiter(ms,dtype);

  ms->SaveToFile(FileName);
  delete ms;
}
//---------------------------------------------------------------------------
/**
 * Convert̃tgGh
 * S_JISɂēǂݍ
 * obt@pӂ
 */
void
KCodeConv::ConvertStream(TMemoryStream *msIn,TMemoryStream *msOut,char *option) {
  int filesize = msIn->Size;

  char *inbuf = new char[filesize+1];
  msIn->Position = 0;
  msIn->Read(inbuf,filesize);
  inbuf[filesize]=NULL;

  char *outbuf = new char[filesize*2];
  memset(outbuf, '\0', filesize*2);

  Convert(inbuf,outbuf,option);
  int size = strlen(outbuf);

  msOut->Clear();
  msOut->Write(outbuf,size);
  msOut->Position = 0;
  delete inbuf;
  delete outbuf;
}
//---------------------------------------------------------------------------
/**
 * sR[h̃^CvԂ
 */
int
KCodeConv::GetDelimiterType(char *filename) {
  unsigned char buf[CHECK_LENGTH];
  int filesize= GetFileSize(filename);

  //t@CTCY̎擾Ɏs
  if(filesize == 0) {
    return D_CRLF;
  }

  int search_length = CHECK_LENGTH;
  if(filesize < search_length) {
    search_length = filesize;
  }

  std::ifstream ifs(filename, std::ios::in | std::ios::binary);
  ifs.read(buf,search_length);
  ifs.close();

  int p_CR  = 0;
  int p_LF  = 0;
  int p_CRLF  = 0;

  for(int i=0;i<search_length-1;i++) {
    if(buf[i] == 10) {
      p_LF ++;
    } else if(buf[i] == 13 && buf[i+1] == 10) {
      p_CRLF ++;
      i++;
    } else if(buf[i] == 13) {
      p_CR++;
    }
  }

  int type = D_CRLF;

  if(p_CRLF <p_LF) {
    type = D_LF;
  }
  if(p_LF <p_CR) {
    type = D_CR;
  }

  return type;
}
//---------------------------------------------------------------------------
/**
 * sR[hϊ
 */
void
KCodeConv::ConvertDelimiter(TMemoryStream *ms,int Type) {
  if(Type == D_CRLF) {
    return;
  }

  int len = ms->Size;
  char *inbuf = new char[len];
  char *outbuf = new char[len];

  ms->Position = 0;
  ms->Read(inbuf,len);

  int op = 0;
  for(int i=0;i<len;i++) {
    if(i!=len-1 && inbuf[i] == 13 && inbuf[i+1] == 10) {
      if(Type == D_LF)
        outbuf[op] = 10;
      if(Type == D_CR)
        outbuf[op] = 13;
      i++;
      op++;
    } else {
      outbuf[op] = inbuf[i];
      op++;
    }
  }
  ms->Clear();

  ms->Write(outbuf,op);

  delete outbuf;
  delete inbuf;
}
//---------------------------------------------------------------------------
/**
 * URLGR[hpR[h
 * S_JIS->EUC
 * S_JIS->JIS
 */
AnsiString
KCodeConv::GetURLEncodedText(AnsiString inText,int CodeType) {

  static unsigned char h16[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
  AnsiString opt = GetConvertOption(C_SJIS,CodeType);

  int len = inText.Length()*3+1;
  char *buf = new char[len];
  char *outbuf = new char[len];
  Convert(inText.c_str(),buf,opt.c_str());

  int l2=0;
  for(int i=0;buf[i]!=NULL && i<len ;i++) {
    unsigned char c = (unsigned char)buf[i];
    if( ('a'<=c && c<='z') || ('A'<=c && c<='Z') || ('0'<=c && c<='9') ||
        c=='\'' || c=='.' || c=='-' || c=='*' || c == ')' || c == '(' || c=='_'
      ) {
      outbuf[l2] = c;
      l2++;
    } else if(c==' ') {
      outbuf[l2] = '+';
      l2++;
    } else {
      outbuf[l2] = '%';
      l2++;
      outbuf[l2] = h16[c/16];
      l2++;
      outbuf[l2] = h16[c%16];
      l2++;
    }
  }
  outbuf[l2] = NULL;
  AnsiString as = outbuf;
  delete buf;
  delete outbuf;
  return as;
}
//---------------------------------------------------------------------------
// NKF32.dll ̃tgGh
//---------------------------------------------------------------------------
/**
 * NKF32.DLL邩`FbNA΃[hĂ
 */
bool
KCodeConv::CheckNKF32(void) {
  SetLastError(0);
  hNKF32=  LoadLibrary("nkf32.dll");

  if(hNKF32 == NULL) {
    bNKF32Exists = false;
  } else {
    bNKF32Exists = true;
  }
  return bNKF32Exists;
}
//---------------------------------------------------------------------------
void
KCodeConv::FreeNKF32(void) {
  if(hNKF32!=NULL) {
    FreeLibrary(hNKF32);
  }
}
//---------------------------------------------------------------------------
typedef int  (CALLBACK *SETNKFOPTION)(LPCSTR) ;
typedef void (CALLBACK *NKFCONVERT)(LPSTR,LPCSTR) ;
typedef int (CALLBACK *NKFGETKANJICODE)(void) ;
//---------------------------------------------------------------------------
/**
 * R[hϊ
 */
void
KCodeConv::Convert(char *inbuf,char *outbuf,char *option) {

  if(bNKF32Exists) {
    SETNKFOPTION nkfsetoption;
    NKFCONVERT nkfconvert;

    nkfsetoption = (SETNKFOPTION)GetProcAddress(hNKF32,"SetNkfOption");
    nkfconvert = (NKFCONVERT)GetProcAddress(hNKF32,"NkfConvert");

    nkfsetoption(option);
    nkfconvert(outbuf,inbuf);
  } else {
    ShowMessage("Error: NKF32.DLL܂");
  }
}
//---------------------------------------------------------------------------
/**
 * ϊNKFɕR[h₢킹
 */
int
KCodeConv::GetKanjiCode(void) {
  if(!bNKF32Exists) {
    return C_SJIS;
  }
  int code = C_SJIS;

  NKFGETKANJICODE nkfgetkanjicode =(NKFGETKANJICODE)GetProcAddress(hNKF32,"NkfGetKanjiCode");
  if(nkfgetkanjicode == NULL) {
    ShowMessage("Failed to GetProcAddress: NkfGetKanjiCode");
    return C_SJIS;
  }
  code = nkfgetkanjicode();
  return code;
}
//---------------------------------------------------------------------------
/**
 * Convert̃tgGh
 */
void
KCodeConv::ConvertCode(TMemoryStream *ms,char *inbuf,int CodeType) {

  int filesize = strlen(inbuf);

  if(CodeType == C_SJIS) {
    ms->Clear();
    ms->Write(inbuf,filesize);
    return;
  }

  char *outbuf = new char[filesize*2];
  memset(outbuf, '\0', filesize*2);

  AnsiString Option = "-";
  Option += CodeOptionTo[CodeType];
  Convert(inbuf,outbuf,Option.c_str());
  filesize = strlen(outbuf);
  ms->Clear();
  ms->Write(outbuf,filesize);
  delete outbuf;
}
//---------------------------------------------------------------------------

