//---------------------------------------------------------------------------
// s֌W̃\bh
//---------------------------------------------------------------------------
#include <vcl.h>
#include <windows.h>
#pragma hdrstop

#include <vcl\Clipbrd.hpp>
#include "main.h"
#include "Exec.h"
#include "Editor.h"
#include "KExecProc.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
/**
 * XNvgs
 */
void
TFMain::Execute(AnsiString File) {

  if(!CopalConfig->CheckPath()) {
    return;
  }
  CloseError();

  FResult->Init();

  AnsiString cmd = CopalConfig->GetExePath();
  cmd += " " + CopalConfig->GetOption();
  cmd += " \"" + CopalConfig->GetTempFile();
  cmd += "\" " + File;

  FScript->SaveToTemporaryFile(CopalConfig->GetTempFile());

  KExecProc *ep = new KExecProc(cmd);

  //CGIf[^g
  if(CopalConfig->UseCGI) {
    FEditor->GetCGIData(ep);
  }


  bool result =ep->Execute();

  if(FScript->GetCode()==C_SJIS) {
    FResult->LoadFromStream(ep->GetStdoutStream());
    FStdError->LoadFromStream(ep->GetStderrorStream());
  } else {
    TMemoryStream *msOut = new TMemoryStream;
    KCodeConv::ConvertStream((TMemoryStream*)ep->GetStdoutStream(),msOut,"-s");
    FResult->LoadFromStream(msOut);
    delete msOut;

    TMemoryStream *msErr = new TMemoryStream;
    KCodeConv::ConvertStream((TMemoryStream*)ep->GetStderrorStream(),msErr,"-s");
    FStdError->LoadFromStream(msErr);
    delete msErr;
  }

  if(CopalConfig->CheckErrorCode()){
    if(result) {
      ChangeWindow(RESULT_WINDOW);
    } else {
      ChangeWindow(SCRIPT_WINDOW);
    }
  }else{
    if(FStdError->IsEmpty()){
      ChangeWindow(RESULT_WINDOW);
    }else{
      ChangeWindow(SCRIPT_WINDOW);
    }
  }

  SetErrorCode(ep->GetExitCode());
  delete ep;

  if(CopalConfig->GetShowError()& GetErrorCode()!=0) {
    ShowMessage("Error Code : "+ IntToStr(GetErrorCode()));
  }

  DeleteFile(CopalConfig->GetTempFile());
}
//---------------------------------------------------------------------------
/**
 * DOSŎs
 */
void
TFMain::ExecDOS(void) {
  FScript->SaveToTemporaryFile(CopalConfig->GetTempFile());
  TStringList *st1 = new TStringList;
  AnsiString as1 = CopalConfig->GetTempFile();
  as1 = "\"" + as1 + "\"";
  st1->Add("\""+CopalConfig->GetExePath()+"\" "+as1);
  if(CopalConfig->UsePause) {
    st1->Add("@PAUSE");
  }
  st1->SaveToFile(CopalConfig->TempBat);
  delete st1;

  ShellExecute(this->Handle,NULL,CopalConfig->TempBat.c_str(),NULL,NULL,SW_SHOW);

}
//---------------------------------------------------------------------------
/**
 * Nbv{[h̓e͂ƂĎs
 */
void
TFMain::ExecToClip(void) {

  TClipboard *Co = Clipboard();
  char filename[256];
  char path[256];

  GetTempPath(sizeof(path),path);
  GetTempFileName(path,"cpl",0,filename);
  AnsiString FileName = filename;
  TStringList *st1 = new TStringList;
  st1->Text = Co->AsText;
  st1->SaveToFile(FileName);

  Execute(FileName);

  // sʂNbv{[hɃRs[
  if(!MMNotClip->Checked) {
    Co->AsText = FResult->REResult->Text;
  }

  DeleteFile(FileName);
  delete st1;

  if(MMSaveAll->Checked) {
    SaveResultToFile();
  }

  if(MMToBrowserAll->Checked) {
    ToBrowser();
  }
}
//---------------------------------------------------------------------------
/**
 * sʂuEU
 */
void
TFMain::ExecToBrowser(void) {

  if(MMMemoryDroppedFiles->Checked) {
    Execute(CopalConfig->LastDroppedFiles);
  } else {
    Execute("");
  }

  if(MMSaveAll->Checked) {
    SaveResultToFile();
  }

  ToBrowser();
}
//---------------------------------------------------------------------------
/**
 * hbv󂯂Ă̎s
 */
void
TFMain::ExecuteOnDrop(AnsiString Files, AnsiString HintText) {

  Execute(Files);

  if(MMSaveAll->Checked) {
    SaveResultToFile();
  }

  if(MMToBrowserAll->Checked) {
    ToBrowser();
  }

  //hbvt@Cۑ
  CopalConfig->LastDroppedFiles = Files;

  //hbvt@CTipwvŌ悤ɂ
  TBMemoryDroppedFiles->Hint = "hbvt@CL\n\n OɃhbvt@C"+HintText;
  if(CopalConfig->MemoryFileWhenDropped && !MMMemoryDroppedFiles->Checked) {
    MMMemoryDroppedFiles->Click();
  }
  //hbvɃJgfBNgύX
  if(CopalConfig->ChangeCurrentDirOnDrop) {
    AnsiString Dir = ExtractFileDir(Files);
    if(!(Dir.AnsiPos("fXNgbv")&&CopalConfig->DontChangeDirFromDesktop)) {
      if(Dir!="") {
        FResult->SetMyCurrentDir(Dir);
        UpdateStatusBar();
      }
    }
  }
}
//---------------------------------------------------------------------------
// s֘ÃTu[`
//---------------------------------------------------------------------------
/**
 *eLXg̃wb_폜
 */
void
CutHeader(TStringList *st) {
  if(st->Count <=2){
    return;
  }
  if(st->Strings[0].AnsiPos("Content-type")) {
    st->Delete(0);
    st->Delete(0);
  }
}
//---------------------------------------------------------------------------
/**
 * uEU֏o
 */
void
TFMain::ToBrowser(void) {

  //G[sȂ
  if(CopalConfig->CheckErrorCode()){
    if(GetErrorCode()!=0) {
      return;
    }
  }else{
    if(!FStdError->IsEmpty()) {
      return;
    }
  }

  TStringList *st1 = new TStringList;
  st1->Text = FResult->REResult->Text;
  if(CopalConfig->CutHead){
    CutHeader(st1);
  }
  st1->SaveToFile(CopalConfig->TempHtml);
  ShellExecute(Handle,NULL,CopalConfig->TempHtml.c_str(),NULL,NULL,SW_SHOW);
  delete st1;
}
//---------------------------------------------------------------------------
/**
 * ʂɃt@C֕ۑ
 */
void
TFMain::SaveResultToFile(void) {
  FResult->SaveToFile(CopalConfig->SaveResultFile);
}
//---------------------------------------------------------------------------
