//---------------------------------------------------------------------------
// tH[GfB^
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Editor.h"
#include "KCodeConv.h"

char *F_CHAR[3] = {"TEXT","TEXTAREA","CHECKBOX"};

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFEditor *FEditor;
//---------------------------------------------------------------------------
__fastcall
TFEditor::TFEditor(TComponent* Owner)
    : TForm(Owner) {

  EnvList = new TList;
  FormList = new TList;
  CookieList = new TList;

  Code = C_SJIS;//R[hSJIS

  //\̍쐬
  SgFormData->Cells[0][0] = "f[^";
  SgFormData->Cells[1][0] = "O";
  SgFormData->Cells[2][0] = "l";

  SgEnvData->Cells[0][0] = "O";
  SgEnvData->Cells[1][0] = "l";

  SgCookieData->Cells[0][0] = "O";
  SgCookieData->Cells[1][0] = "l";
  SgCookieData->Cells[2][0] = "L";
  SgCookieData->Cells[3][0] = "hC";
  SgCookieData->Cells[4][0] = "pX";
  SgCookieData->Cells[5][0] = "ZLAtO";

  mStayOnTop = false;
}
//---------------------------------------------------------------------------
/**
 * fXgN^
 */
void __fastcall
TFEditor::FormDestroy(TObject *Sender) {
  DeleteEnvAll();
  DeleteFormAll();
  DeleteCookieAll();
  delete CookieList;
  delete EnvList;
  delete FormList;
}
//---------------------------------------------------------------------------
// ϐ֘A
//---------------------------------------------------------------------------
/**
 * f[^̍폜
 */
void
TFEditor::DeleteEnv(int index) {
  KEnvData *ed = GetEnvData(index);
  delete ed;
  EnvList->Delete(index);
}
//---------------------------------------------------------------------------
/**
 * f[^̒ǉ
 */
void
TFEditor::AddEnvData(AnsiString Name, AnsiString Value) {
  //O邩`FbN
  int index = CheckEnvData(Name);

  if(index!=-1) {
    //炻̏ꏊ̖Oς
    KEnvData *ed = GetEnvData(index);
    ed->SetName(Name);
    ed->SetValue(Value);
    SgEnvData->Cells[0][index+1] = Name;
    SgEnvData->Cells[1][index+1] = Value;

    //̃f[^I
    if(index < SgEnvData->RowCount-2) {
      TGridRect myRect;
      myRect = SgEnvData->Selection;
      myRect.Top = index + 2;
      myRect.Bottom = index + 2;
      SgEnvData->Selection = myRect;
      ShowEnvData();
    } else {
      EnvClear();
    }
    return;
  }

  int i = SgEnvData->RowCount;
  if(GetEnvCount()>0) {
    SgEnvData->RowCount++;
  } else {
    i = 1;
  }
  SgEnvData->Cells[0][i] = Name;
  SgEnvData->Cells[1][i] = Value;
  KEnvData *ed = new KEnvData(Name,Value);
  EnvList->Add(ed);

  TGridRect myRect = SgEnvData->Selection;
  myRect.Top = myRect.Top = SgEnvData->RowCount-1;
  myRect.Bottom = SgEnvData->RowCount-1;
  SgEnvData->Selection = myRect;
  EnvClear();
}
//---------------------------------------------------------------------------
/**
 * J[\ʒȕ\
 */
void
TFEditor::ShowEnvData(void) {
  if(GetEnvCount()==0) {
    EnvClear();
    return;
  }
  int index = SgEnvData->Selection.Top - 1;
  KEnvData *ed = GetEnvData(index);
  CbEnvName->Text = ed->GetName();
  EdEnvValue->Text = ed->GetValue();
  CbEnvName->SetFocus();
}
//---------------------------------------------------------------------------
/**
 * ̖O̊ϐłɂ邩`FbN
 * ꍇ͂IndexԂ
 * Ȃ-1Ԃ
 */
int
TFEditor::CheckEnvData(AnsiString Name) {
  for(int i=0;i<GetEnvCount();i++) {
    KEnvData *ed = GetEnvData(i);
    if(ed->GetName().LowerCase() == Name.LowerCase()) {
      return i;
    }
  }
  return -1;
}
//---------------------------------------------------------------------------
/**
 * ϐ̒ǉ
 */
void __fastcall
TFEditor::BtAddEnvClick(TObject *Sender) {
  if(CbEnvName->Text.Trim()=="") {
    ShowMessage("Ow肵Ă");
    return;
  }
  AddEnvData(CbEnvName->Text,EdEnvValue->Text);
}
//---------------------------------------------------------------------------
/**
 * ϐ̍폜
 */
void __fastcall
TFEditor::BtRemoveEnvClick(TObject *Sender) {
  //f[^ȂΉȂ
  if(GetEnvCount()==0)
    return;

  int index = SgEnvData->Selection.Top;

  //Ō̃f[^ȂPɍ폜
  if(index==SgEnvData->RowCount-1) {
    if(SgEnvData->RowCount==2) {
      SgEnvData->Cells[0][1] = "";
      SgEnvData->Cells[1][1] = "";
    } else {
      SgEnvData->RowCount--;
    }
  } else {
    //Ō̃f[^Ȃ̂ŁAԂl߂
    for(int i=index;i<SgEnvData->RowCount-1;i++) {
      SgEnvData->Cells[0][index] = SgEnvData->Cells[0][index+1];
      SgEnvData->Cells[1][index] = SgEnvData->Cells[1][index+1];
    }
    SgEnvData->RowCount--;
  }
  DeleteEnv(index-1);
  ShowEnvData();
}
//---------------------------------------------------------------------------
/**
 * ϐ̃NA
 */
void __fastcall TFEditor::BtEnvClearClick(TObject *Sender) {
  EnvClear();
}
//---------------------------------------------------------------------------
/**
 * ϐI
 */
void __fastcall
TFEditor::SgEnvDataClick(TObject *Sender) {
  //f[^ȂΉȂ
  if(GetEnvCount()==0)
    return;
  ShowEnvData();
}
//---------------------------------------------------------------------------
/**
 * ϐf[^󂯓nB
 * new ͂A󂯎葤(KExecProc)delete
 */
void
TFEditor::GetCGIData(KExecProc *ep) {
  //f[^Ȃreturn
  if(GetEnvCount()==0&&GetFormCount()==0&&GetCookieCount()==0) {
    ep->SetEnvironment(NULL);
    return;
  }

  TMemoryStream *ms = new TMemoryStream;
  for(int i=0;i<GetEnvCount();i++) {
    KEnvData *ed = GetEnvData(i);
    AnsiString as = ed->GetName() + "=" + ed->GetValue();
    ms->Write(as.c_str(),as.Length()+1);
  }

  //Cookief[^
  AnsiString asCookieData = "HTTP_COOKIE="+GetCookieText();
  ms->Write(asCookieData.c_str(),asCookieData.Length()+1);

  //tH[f[^
  AnsiString asFormData = MakeURLEncodedText();

  if(Method == FM_GET) {
    //REQUEST_METHODGET̎
    AnsiString as;
    as = "REQUEST_METHOD=GET";
    ms->Write(as.c_str(),as.Length()+1);
    as = "QUERY_STRING=" + asFormData;
    ms->Write(as.c_str(),as.Length()+1);
  } else if(Method == FM_POST) {
    //REQUEST_METHODPOST̎
    AnsiString as;
    as = "REQUEST_METHOD=POST";
    ms->Write(as.c_str(),as.Length()+1);
    as = "CONTENT_LENGTH="+IntToStr(asFormData.Length());
    ms->Write(as.c_str(),as.Length()+1);
  }

  int size = ms->Size +1;
  char *buf = new char[size];
  //ŌNULLǉ
  char b[1] = {NULL};
  ms->Write(b,1);
  ms->Position = 0;
  ms->Read(buf,size);
  delete ms;
  ep->SetEnvironment(buf);
}
//---------------------------------------------------------------------------
// tH[f[^֘A
//---------------------------------------------------------------------------
/**
 * f[^̍폜
 */
void
TFEditor::DeleteForm(int index) {
  KFormData *fd = GetFormData(index);
  delete fd;
  FormList->Delete(index);
}
//---------------------------------------------------------------------------
/**
 * f[^̒ǉ
 */
void
TFEditor::AddFormData(int Type,AnsiString Name, AnsiString Value) {

  //Ow肳Ă邩`FbN
  if(Name.Trim()=="") {
    ShowMessage("Ow肵Ă");
    FormClear();
    return;
  }

  //O邩`FbN
  int index = CheckFormData(Name);
  if(index!=-1) {
    //炻̏ꏊ̖Oς
    KFormData *fd = GetFormData(index);
    fd->SetType(Type);
    fd->SetName(Name);
    fd->SetValue(Value);
    SgFormData->Cells[0][index+1] = F_CHAR[Type];
    SgFormData->Cells[1][index+1] = Name;
    SgFormData->Cells[2][index+1] = Value;

    int r = SgFormData->RowCount-1;
    //̃f[^I
    if(index < r -1) {
      TGridRect myRect;
      myRect = SgFormData->Selection;
      myRect.Top = index + 2;
      myRect.Bottom = index + 2;
      SgFormData->Selection = myRect;
      ShowFormData();
    } else {
      FormClear();
    }

    return;
  }

  index = SgFormData->RowCount;
  if(GetFormCount()>0) {
    SgFormData->RowCount++;
  } else {
    index = 1;
  }

  SgFormData->Cells[0][index] = F_CHAR[Type];
  SgFormData->Cells[1][index] = Name;
  SgFormData->Cells[2][index] = Value;

  KFormData *ef = new KFormData(Type,Name,Value);
  FormList->Add(ef);

  TGridRect myRect;
  myRect = SgFormData->Selection;
  myRect.Top = myRect.Top = SgFormData->RowCount-1;
  myRect.Bottom = SgFormData->RowCount-1;
  SgFormData->Selection = myRect;
  FormClear();

}
//---------------------------------------------------------------------------
/**
 * ̖O̊ϐłɂ邩`FbN
 * ꍇ͂IndexԂ
 * Ȃ-1Ԃ
 */
int
TFEditor::CheckFormData(AnsiString Name) {
  for(int i=0;i<GetFormCount();i++) {
    KFormData *ef = GetFormData(i);
    if(ef->GetName().LowerCase() == Name.LowerCase()) {
      return i;
    }
  }
  return -1;
}
//---------------------------------------------------------------------------
/**
 * URLGR[hf[^
 */
AnsiString
TFEditor::MakeURLEncodedText(void) {

  AnsiString EncodedText = "";
  for(int i=0;i<GetFormCount();i++) {
    KFormData *ef = GetFormData(i);
    if(i!=0)
      EncodedText += "&";
    EncodedText += KCodeConv::GetURLEncodedText(ef->GetName(),Code);
    EncodedText += "=";
    EncodedText += KCodeConv::GetURLEncodedText(ef->GetValue(),Code);
  }
  return EncodedText;
}
//---------------------------------------------------------------------------
/**
 * tH[f[^̒ǉ
 */
void __fastcall
TFEditor::BtAddFormClick(TObject *Sender) {

  if(PCFormData->ActivePage==TbText) {
    //TEXT̒ǉ
    AddFormData(FT_TEXT,EdTextName->Text,EdTextValue->Text);
  } else if (PCFormData->ActivePage==TbTextarea) {
    AddFormData(FT_TEXTAREA,EdTextareaName->Text,MemoTextarea->Text);
  } else if (PCFormData->ActivePage==TbCheckbox) {
    AnsiString Value;
    if(CbCheckboxValue->Checked)
      Value = "on";
    else
      Value = "";
    AddFormData(FT_CHECKBOX,EdCheckboxName->Text,Value);
  }
}
//---------------------------------------------------------------------------
/**
 * tH[f[^̕\
 */
void
TFEditor::ShowFormData(void) {

  //f[^ȂΉȂ
  if(GetFormCount()==0)
    return;

  int index = SgFormData->Selection.Top - 1;
  KFormData *fd = GetFormData(index);
  switch(fd->GetType()) {
  case FT_TEXT:
    PCFormData->ActivePage = TbText;
    EdTextName->Text = fd->GetName();
    EdTextValue->Text = fd->GetValue();
    EdTextName->SetFocus();
    break;
  case FT_TEXTAREA:
    PCFormData->ActivePage = TbTextarea;
    EdTextareaName->Text = fd->GetName();
    MemoTextarea->Text = fd->GetValue();
    EdTextareaName->SetFocus();
    break;
  case FT_CHECKBOX:
    PCFormData->ActivePage = TbCheckbox;
    EdCheckboxName->Text = fd->GetName();
    if(fd->GetValue()=="on")
      CbCheckboxValue->Checked = true;
    else
      CbCheckboxValue->Checked = false;
    EdCheckboxName->SetFocus();
    break;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::SgFormDataClick(TObject *Sender) {
  ShowFormData();
}
//---------------------------------------------------------------------------
/**
 * tH[f[^̍폜
 */
void __fastcall
TFEditor::BtRemoveFormClick(TObject *Sender) {
  //f[^ȂΉȂ
  if(GetFormCount()==0)
    return;

  int index = SgFormData->Selection.Top;

  //Ō̃f[^ȂPɍ폜
  if(index==SgFormData->RowCount-1) {
    if(SgFormData->RowCount==2) {
      SgFormData->Cells[0][1] = "";
      SgFormData->Cells[1][1] = "";
      SgFormData->Cells[2][1] = "";
    } else {
      SgFormData->RowCount--;
    }
  } else {
    //Ō̃f[^Ȃ̂ŁAԂl߂
    for(int i=index;i<SgFormData->RowCount-1;i++) {
      SgFormData->Cells[0][index] = SgFormData->Cells[0][index+1];
      SgFormData->Cells[1][index] = SgFormData->Cells[1][index+1];
      SgFormData->Cells[2][index] = SgFormData->Cells[2][index+1];
    }
    SgFormData->RowCount--;
  }
  index--;
  DeleteForm(index);
}
//---------------------------------------------------------------------------
/**
 * tH[͗̃NA
 */
void
TFEditor::FormClear(void) {
  if(PCFormData->ActivePage==TbText) {
    EdTextName->Text = "";
    EdTextValue->Text = "";
    EdTextName->SetFocus();
  } else if (PCFormData->ActivePage==TbTextarea) {
    EdTextareaName->Text = "";
    MemoTextarea->Text = "";
    EdTextareaName->SetFocus();
  } else if (PCFormData->ActivePage==TbCheckbox) {
    EdCheckboxName->Text = "";
    CbCheckboxValue->Checked = false;
    EdCheckboxName->SetFocus();
  }
}
//---------------------------------------------------------------------------
/**
 *  ϐ͗̃NA
 */
void
TFEditor::EnvClear(void) {
  CbEnvName->Text = "";
  EdEnvValue->Text = "";
  CbEnvName->SetFocus();
}
//---------------------------------------------------------------------------
/**
 * NA{^
 */
void __fastcall
TFEditor::BtFormClearClick(TObject *Sender) {
  FormClear();
}
//---------------------------------------------------------------------------
// Cookie֌W
//---------------------------------------------------------------------------
/**
 * f[^̍폜
 */
void
TFEditor::DeleteCookie(int index) {
  KCookieData *cd = GetCookieData(index);
  delete cd;
  CookieList->Delete(index);
}
//---------------------------------------------------------------------------
/**
 * f[^̒ǉ
 */
void
TFEditor::AddCookieData(AnsiString Name, AnsiString Value, AnsiString Expires,
                        AnsiString Domain, AnsiString Path, bool Secure) {
  //O邩`FbN
  int index = CheckCookieData(Name);

  if(index!=-1) {
    //炻̏ꏊ̖Oς
    KCookieData *cd = GetCookieData(index);
    cd->SetName(Name);
    cd->SetValue(Value);
    cd->SetExpires(Expires);
    cd->SetDomain(Domain);
    cd->SetPath(Path);
    cd->SetSecure(Secure);

    SgCookieData->Cells[0][index+1] = Name;
    SgCookieData->Cells[1][index+1] = Value;
    SgCookieData->Cells[2][index+1] = Expires;
    SgCookieData->Cells[3][index+1] = Domain;
    SgCookieData->Cells[4][index+1] = Path;
    if(Secure) {
      SgCookieData->Cells[5][index+1] = "Secure";
    }

    //̃f[^I
    if(index < SgCookieData->RowCount-2) {
      TGridRect myRect;
      myRect = SgCookieData->Selection;
      myRect.Top = index + 2;
      myRect.Bottom = index + 2;
      SgCookieData->Selection = myRect;
      ShowCookieData();
    } else {
      CookieClear();
    }
    return;
  }

  index = SgCookieData->RowCount;
  if(GetCookieCount()>0) {
    SgCookieData->RowCount++;
  } else {
    index = 1;
  }
  SgCookieData->Cells[0][index] = Name;
  SgCookieData->Cells[1][index] = Value;
  SgCookieData->Cells[2][index] = Expires;
  SgCookieData->Cells[3][index] = Domain;
  SgCookieData->Cells[4][index] = Path;
  if(Secure) {
    SgCookieData->Cells[5][index] = "Secure";
  }

  KCookieData *cd = new KCookieData(Name,Value,Expires,Domain,Path,Secure);
  CookieList->Add(cd);

  TGridRect myRect = SgCookieData->Selection;
  myRect.Top = myRect.Top = SgCookieData->RowCount-1;
  myRect.Bottom = SgCookieData->RowCount-1;
  SgCookieData->Selection = myRect;
  CookieClear();
}
//---------------------------------------------------------------------------
/**
 * ̖OCookiełɂ邩`FbN
 * ꍇ͂IndexԂ
 * Ȃ-1Ԃ
 */
int
TFEditor::CheckCookieData(AnsiString Name) {
  for(int i=0;i<GetCookieCount();i++) {
    KCookieData *cd = GetCookieData(i);
    if(cd->GetName().LowerCase() == Name.LowerCase()) {
      return i;
    }
  }
  return -1;
}
//---------------------------------------------------------------------------
/**
 * Cookie \̃NA
 */
void
TFEditor::CookieClear(void) {
  EdCookieName->Clear();
  EdCookieValue->Clear();
  EdCookieExpires->Clear();
  EdCookieDomain->Clear();
  EdCookiePath->Clear();
  CBCookieSecure->Checked = false;
  EdCookieName->SetFocus();
}
//---------------------------------------------------------------------------
/**
 * J[\ʒȕ\
 */
void
TFEditor::ShowCookieData(void) {
  if(GetCookieCount()==0) {
    CookieClear();
    return;
  }
  int index = SgCookieData->Selection.Top - 1;
  KCookieData *cd = GetCookieData(index);
  EdCookieName->Text = cd->GetName();
  EdCookieValue->Text = cd->GetValue();
  EdCookieExpires->Text = cd->GetExpires();
  EdCookieDomain->Text = cd->GetDomain();
  EdCookiePath->Text = cd->GetPath();
  CBCookieSecure->Checked = cd->GetSecure();

  EdCookieName->SetFocus();
}
//---------------------------------------------------------------------------
/**
 * URLGR[hꂽCookiẽeLXg쐬
 */
AnsiString
TFEditor::GetCookieText(void) {
  AnsiString as = "";
  for(int i=0;i<GetCookieCount();i++) {
    KCookieData *cd = GetCookieData(i);
    if(i!=0)
      as += "; ";
    as += KCodeConv::GetURLEncodedText(cd->GetName(),Code);
    as += "=";
    as += KCodeConv::GetURLEncodedText(cd->GetValue(),Code);
  }
  return as;
}
//---------------------------------------------------------------------------
// ̑{^Ȃǂ̃Cxg
//---------------------------------------------------------------------------
void __fastcall
TFEditor::CbEnvNameKeyPress(TObject *Sender, char &Key) {
  if(Key == VK_RETURN) {
    EdEnvValue->SetFocus();
    Key=0;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::EdEnvValueKeyPress(TObject *Sender, char &Key) {
  if(Key == VK_RETURN) {
    BtAddEnv->Click();
    Key=0;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::EdTextNameKeyPress(TObject *Sender, char &Key) {
  if(Key == VK_RETURN) {
    EdTextValue->SetFocus();
    Key=0;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::EdTextValueKeyPress(TObject *Sender, char &Key) {
  if(Key == VK_RETURN) {
    BtAddForm->Click();
    Key=0;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::EdTextareaNameKeyPress(TObject *Sender, char &Key) {
  if(Key == VK_RETURN) {
    MemoTextarea->SetFocus();
    Key=0;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::EdCheckboxNameKeyPress(TObject *Sender,char &Key) {
  if(Key == VK_RETURN) {
    CbCheckboxValue->SetFocus();
    Key=0;
  }
}
//---------------------------------------------------------------------------

void __fastcall
TFEditor::CbCheckboxValueKeyPress(TObject *Sender,char &Key) {
  if(Key == VK_RETURN) {
    BtAddForm->Click();
    Key=0;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::MMGETClick(TObject *Sender) {
  MMGET->Checked = true;
  Method = FM_GET;
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::MMPOSTClick(TObject *Sender) {
  MMPOST->Checked = true;
  Method = FM_POST;
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::MMSJISClick(TObject *Sender) {
  MMSJIS->Checked = true;
  Code = C_SJIS;
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::MMEUCClick(TObject *Sender) {
  MMEUC->Checked = true;
  Code = C_EUC;
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::MMCopyClick(TObject *Sender) {
  PostMessage(ActiveControl->Handle,WM_COPY,0,0);
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::MMCutClick(TObject *Sender) {
  PostMessage(ActiveControl->Handle,WM_CUT,0,0);
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::MMPasteClick(TObject *Sender) {
  PostMessage(ActiveControl->Handle,WM_PASTE,0,0);
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::FormKeyPress(TObject *Sender, char &Key) {
  if(Key == VK_ESCAPE) {
    Key=0;
    Close();
  }
}
//---------------------------------------------------------------------------
void
TFEditor::SetStayOnTop(bool b) {
  mStayOnTop = b;
  if(mStayOnTop) {
    FormStyle = fsStayOnTop;
  } else {
    FormStyle = fsNormal;
  }
  MMStayOnTop->Checked = mStayOnTop;
}
//---------------------------------------------------------------------------
bool
TFEditor::isStayOnTop(void) {
  return mStayOnTop;
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::MMStayOnTopClick(TObject *Sender) {
  MMStayOnTop->Checked = !MMStayOnTop->Checked;
  SetStayOnTop(MMStayOnTop->Checked);
}
//---------------------------------------------------------------------------

void __fastcall
TFEditor::BtAddCookieClick(TObject *Sender) {
  AddCookieData(EdCookieName->Text,EdCookieValue->Text,EdCookieExpires->Text,
                EdCookieDomain->Text,EdCookiePath->Text,CBCookieSecure->Checked);
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::SgCookieDataClick(TObject *Sender) {
  ShowCookieData();
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::BtRemoveCookieClick(TObject *Sender) {
  //f[^ȂΉȂ
  if(GetCookieCount()==0)
    return;

  int index = SgCookieData->Selection.Top;
  //Ō̃f[^ȂPɍ폜
  if(index==SgCookieData->RowCount-1) {
    if(SgCookieData->RowCount==2) {
      SgCookieData->Cells[0][1] = "";
      SgCookieData->Cells[1][1] = "";
      SgCookieData->Cells[2][1] = "";
      SgCookieData->Cells[3][1] = "";
      SgCookieData->Cells[4][1] = "";
      SgCookieData->Cells[5][1] = "";
    } else {
      SgCookieData->RowCount--;
    }
  } else {
    //Ō̃f[^Ȃ̂ŁAԂl߂
    for(int i=index;i<SgCookieData->RowCount-1;i++) {
      SgCookieData->Cells[0][index] = SgCookieData->Cells[0][index+1];
      SgCookieData->Cells[1][index] = SgCookieData->Cells[1][index+1];
      SgCookieData->Cells[2][index] = SgCookieData->Cells[2][index+1];
      SgCookieData->Cells[3][index] = SgCookieData->Cells[3][index+1];
      SgCookieData->Cells[4][index] = SgCookieData->Cells[4][index+1];
      SgCookieData->Cells[5][index] = SgCookieData->Cells[5][index+1];
    }
    SgCookieData->RowCount--;
  }
  DeleteCookie(index-1);
  ShowCookieData();
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::BtClearCookieClick(TObject *Sender) {
  CookieClear();
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::EdCookieNameKeyPress(TObject *Sender, char &Key) {
  if(Key == VK_RETURN) {
    EdCookieValue->SetFocus();
    Key=0;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::EdCookieValueKeyPress(TObject *Sender, char &Key) {
  if(Key == VK_RETURN) {
    BtAddCookie->Click();
    Key=0;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::EdCookieExpiresKeyPress(TObject *Sender, char &Key) {
  if(Key == VK_RETURN) {
    EdCookieDomain->SetFocus();
    Key=0;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::EdCookieDomainKeyPress(TObject *Sender, char &Key) {
  if(Key == VK_RETURN) {
    EdCookiePath->SetFocus();
    Key=0;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFEditor::EdCookiePathKeyPress(TObject *Sender, char &Key) {
  if(Key == VK_RETURN) {
    CBCookieSecure->SetFocus();
    Key=0;
  }
}
//---------------------------------------------------------------------------

