//---------------------------------------------------------------------------
//\֌W
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Main.h"
#include "View.h"
#include "Script.h"
#include "KCodeConv.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
/**
 *  ׂĂ̕\XV
 */
void
TFMain::UpdateAll(void) {
  UpdateCaption();
  UpdateStatusBar();
  UpdateMenu();
  SetMenuChecked();
}
//---------------------------------------------------------------------------
/**
 * LvV̍XV
 */
void
TFMain::UpdateCaption(void) {
  Caption = FScript->GetCaptionStr();
}
//---------------------------------------------------------------------------
/**
 * Xe[^Xo[̕\XV
 */
void
TFMain::UpdateStatusBar(void) {
  StatusBar->Panels->Items[0]->Text = CurrentForm->GetCaretString();
  StatusBar->Panels->Items[1]->Text = CopalConfig->GetLangName();
  StatusBar->Panels->Items[2]->Text = KCodeConv::GetCodeChar(FScript->GetCode());
  StatusBar->Panels->Items[3]->Text = KCodeConv::GetDelimiterChar(FScript->GetDelimiter());
  AnsiString Dir = CurrentForm->GetMyCurrentDir();

  StatusBar->Panels->Items[4]->Text = Dir;
}
//---------------------------------------------------------------------------
/**
 * j[Xs[h{^̕\XV
 */
void
TFMain::UpdateMenu(void) {

  if(MMAutoRefresh->Checked != CopalConfig->AutoRefresh) {
    MMAutoRefresh->Checked = CopalConfig->AutoRefresh;
  }

  if(TBAutoRefresh->Down != MMAutoRefresh->Checked) {
    TBAutoRefresh->Down = MMAutoRefresh->Checked;
  }

  if(MMReadOnly->Checked != CopalConfig->IsReadOnly()) {
    MMReadOnly->Checked = CopalConfig->IsReadOnly();
  }

  if(TBReadOnly->Down != MMReadOnly->Checked) {
    TBReadOnly->Down = MMReadOnly->Checked;
  }

  if(MMUseCGI->Checked != CopalConfig->UseCGI) {
    MMUseCGI->Checked = CopalConfig->UseCGI;
  }

  if(TBUseCGI->Down != MMUseCGI->Checked) {
    TBUseCGI->Down = MMUseCGI->Checked;
  }

  if (MMUndo->Enabled!=CurrentForm->CanUndo()) {
    MMUndo->Enabled = CurrentForm->CanUndo();
  }

}
//---------------------------------------------------------------------------
/**
 * G[J
 */
void
TFMain::OpenError(void) {

  if(PStdError->Visible) {
    return;
  }

  PStdError->Height = 60;
  PageControl->Height -= PStdError->Height;
  PStdError->Visible = true;
  FStdError->Visible = true;
  Splitter->Visible = true;

  Splitter->Top = PageControl->Height + PageControl->Top;
  PStdError->Top = Splitter->Top + PStdError->Height;
  StatusBar->Top = PStdError->Top + PStdError->Top;

}
//---------------------------------------------------------------------------
/**
 * G[
 */
void
TFMain::CloseError(void) {
  PStdError->Visible = false;
  Splitter->Visible = false;
}
//---------------------------------------------------------------------------
/**
 * EBhEύX
 */
void
TFMain::ChangeWindow(int window) {
  switch(window) {
  case SCRIPT_WINDOW:
    PageControl->ActivePage = PageControl->Pages[0];
    CurrentForm=FScript;
    CurrentForm->SetWindowFocus();
    break;
  case RESULT_WINDOW:
    PageControl->ActivePage = PageControl->Pages[1];
    FResult->REResult->SetFocus();
    CurrentForm=FResult;
    break;
  case ERROR_WINDOW:
    CurrentForm=FStdError;
    OpenError();
    FStdError->LBStdError->SetFocus();
    break;
  case NEXT_WINDOW:
    if(CurrentForm == FScript){
      ChangeWindow(RESULT_WINDOW);
    }else if(CurrentForm == FResult){
      if(PStdError->Visible){
        ChangeWindow(ERROR_WINDOW);
      }else{
        ChangeWindow(SCRIPT_WINDOW);
      }
    }else{
      ChangeWindow(SCRIPT_WINDOW);
    }
    break;
  }
  UpdateStatusBar();
}
//---------------------------------------------------------------------------
/**
 * RtBO񂩂`FbN郁j[̕ύX
 */
void
TFMain::SetMenuChecked(void) {

  //R[hݒ
  switch(CopalConfig->GetCodeMode()) {
  case CM_AUTOSELECT:
    MMAuto->Checked = true;
    break;
  case CM_SJIS:
    MMSHIFTJIS->Checked = true;
    break;
  case CM_EUC:
    MMEUC->Checked = true;
    break;
  case CM_JIS:
    MMJIS->Checked = true;
    break;
  case CM_UTF8:
    MMUTF8->Checked = true;
    break;
  }

  if(CopalConfig->GetDefConfigCount()==0) {
    return;
  }

  for(int i=0;i<MMLanguage->Count;i++) {
    KDefConfig *df = (KDefConfig*)MMLanguage->Items[i]->Tag;
    if(df->LangName.LowerCase()==CopalConfig->GetLangName().LowerCase()) {
      MMLanguage->Items[i]->Checked = true;
      return;
    }
  }
}
//---------------------------------------------------------------------------
/**
 * ݒt@C񂩂猾Ij[쐬
 */
void
TFMain::MakeLanguageMenu(void) {

  for (int i=0;MMLanguage->Count!=0;i++) {
    MMLanguage->Delete(0);
  }

  if(CopalConfig->GetDefConfigCount()==0) {
    return;
  }

  for(int i=0;i<CopalConfig->GetDefConfigCount();i++) {
    KDefConfig *df = CopalConfig->GetDefConfigAt(i);
    TMenuItem *mi = NewItem(df->LangName,0,false,true,OnLanguageClick,0,"LangMenu"+IntToStr(i));
    mi->Tag = (int)df;
    mi->RadioItem = true;
    MMLanguage->Add(mi);
  }

  //ԏIĂ
  MMLanguage->Items[0]->Checked = true;
}
//---------------------------------------------------------------------------

