//---------------------------------------------------------------------------
// XNvg͂tH[
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Main.h"
#include "KCopalConfig.h"
#include "Script.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "Base"
#pragma resource "*.dfm"
TFScript *FScript;
//---------------------------------------------------------------------------
__fastcall
TFScript::TFScript(TComponent* Owner)
    : TFBase(Owner) {
  //hbLO
  Caption = "Script";
  Width = 400;
  Height = 400;
  ManualDock(FMain->PageControl,FMain->PageControl,alClient);
  Visible = true;
  Modified = false;
  FileName = "";
  Delimiter = D_CRLF;
  Code = C_SJIS;
}
//---------------------------------------------------------------------------
void
TFScript::SetCode(int CodeMode) {
  if(CodeMode !=CM_AUTOSELECT) {
    Code = CodeMode;
  }
}
//---------------------------------------------------------------------------
void
TFScript::SetTabWidth(KCopalConfig *CopalConfig,int tabwidth){
  CopalConfig->SetTabWidthToRichEdit(REScript, tabwidth);
}
//---------------------------------------------------------------------------
/**
 * EBhEɃtH[JXĂ
 */
void
TFScript::SetWindowFocus(void) {
  REScript->SetFocus();
}
//---------------------------------------------------------------------------
/**
 * 
 */
void
TFScript::Find(void) {
  FMain->FindDialog->OnFind = OnFind;
  SearchOption.Clear();
  FMain->FindDialog->FindText = FindWord;
  if(!FMain->FindDialog->Execute()) {
    return;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFScript::OnFind(TObject *Sender) {
  FMain->FindDialog->CloseDialog();
  FindWord = FMain->FindDialog->FindText;
  //IvV̐ݒ
  if (FMain->FindDialog->Options.Contains(frMatchCase)) {
    SearchOption = SearchOption << stMatchCase;
  }
  if (FMain->FindDialog->Options.Contains(frWholeWord)) {
    SearchOption = SearchOption << stWholeWord;
  }
  if (FMain->FindDialog->Options.Contains(frDown)) {
    //Ɍ
    FindNext();
  } else {
    //Ɍ
    FindPrev();
  }
}
//---------------------------------------------------------------------------
/**
 * 
 */
void
TFScript::FindNext(void) {
  if(FindWord == "") {
    Find();
    return;
  }

  //݂̃J[\ʒu̍s
  int line = REScript->Perform(EM_LINEFROMCHAR,-1,0);

  //J[\s̓̈ʒu
  int linetop = REScript->Perform(EM_LINEINDEX,line,0);
  AnsiString Str = REScript->Lines->Strings[line];
  int startpos = REScript->SelStart;
  if(REScript->SelLength)
    startpos++;
  Str = Str.SubString(startpos - linetop+1,Str.Length()-startpos+linetop);

  //݂̈ʒuŌ邩
  int pos = Str.AnsiPos(FindWord);
  if(pos!=0) {
    pos += startpos-1;
    REScript->SelStart = pos;
    REScript->SelLength = FindWord.Length();
    MakeCursorVisible();
    return;
  }
  //ȉ̍s
  line++;
  int count = REScript->Lines->Count;//QƂƒx̂őޔ
  while(line < count) {
    Str = REScript->Lines->Strings[line];
    int pos = Str.AnsiPos(FindWord);
    if(pos!=0) {
      int linetop = REScript->Perform(EM_LINEINDEX,line,0);
      pos += linetop-1;
      REScript->SelStart = pos;
      REScript->SelLength = FindWord.Length();
      MakeCursorVisible();
      return;
    } else {
      line++;
    }
  }
}
//---------------------------------------------------------------------------
/**
 * ^ꂽ̍ŌɃ}b`ʒuԂ
 * }b`Ȃ 0Ԃ
 */
int
FindLast(AnsiString asTarget, AnsiString asFindWord) {
  int pos = asTarget.AnsiPos(asFindWord);
  if(pos==0) {
    return 0;
  }
  while(1) {
    asTarget = asTarget.SubString(pos+1,asTarget.Length()-pos);
    int pos2 = asTarget.AnsiPos(asFindWord);
    if(pos2!=0) {
      pos+=pos2;
    } else {
      break;
    }
  }
  return pos;
}
//---------------------------------------------------------------------------
void
TFScript::FindPrev(void) {

  //݂̃J[\ʒu̍s
  int line = REScript->Perform(EM_LINEFROMCHAR,-1,0);

  //J[\s̓̈ʒu
  int linetop = REScript->Perform(EM_LINEINDEX,line,0);
  AnsiString Str = REScript->Lines->Strings[line];
  Str = Str.SubString(0,REScript->SelStart-linetop-1);
  int pos = FindLast(Str,FindWord);
  if(pos!=0) {
    pos += linetop-1;
    REScript->SelStart = pos;
    REScript->SelLength = FindWord.Length();
    return;
  } else {
    line--;
  }
  while(line >= 0) {
    Str = REScript->Lines->Strings[line];
    int pos = FindLast(Str,FindWord);
    if(pos!=0) {
      int linetop = REScript->Perform(EM_LINEINDEX,line,0);
      pos += linetop-1;
      REScript->SelStart = pos;
      REScript->SelLength = FindWord.Length();
      MakeCursorVisible();
      return;
    } else {
      line--;
    }
  }
}
//---------------------------------------------------------------------------
/**
 * e|t@CƂĕۑ
 */
void
TFScript::SaveToTemporaryFile(AnsiString File) {
  KCodeConv::SaveConvertedFile(File,REScript->Lines->Text,Code,Delimiter);
}
//---------------------------------------------------------------------------
void
TFScript::SaveToFile(AnsiString File) {

  KCodeConv::SaveConvertedFile(File,REScript->Lines->Text,Code,Delimiter);
  FMain->AddHistory(File);
  FileDate = FileAge(FileName);
  Modified = false;
  FMain->UpdateCaption();
  //JgfBNgXNvĝꏊɂ
  AnsiString Dir = ExtractFileDir(FileName);
  if(Dir!="") {
    SetMyCurrentDir(Dir);
  }
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------
/**
 * t@C̃[hs
 * sR[hϊAR[hϊs
 */
void
TFScript::LoadFromFile(AnsiString File) {

  if(!FileExists(File)) {
    AnsiString msg = File+"܂B\nVK쐬܂H";
    int mr = Application->MessageBox(msg.c_str(),"CopalPro",MB_YESNO);
    if (mr == ID_NO) {
      return;
    } else {
      FileName = File;
      Modified = true;
      FMain->UpdateCaption();
      return;
    }
  }

  FileName = File;
  FileDate = FileAge(FileName);

  Delimiter = KCodeConv::GetDelimiterType(File.c_str());

  if(CopalConfig->GetCodeMode() == CM_AUTOSELECT) {
    Code = KCodeConv::GetCodeType(File.c_str());
  }

  TMemoryStream *msIn = new TMemoryStream;
  TMemoryStream *msOut = new TMemoryStream;
  msIn->LoadFromFile(FileName);

  if(KCodeConv::NKF32Exists()) {
    AnsiString option = KCodeConv::GetConvertOption(Code,C_SJIS);
    KCodeConv::ConvertStream(msIn,msOut,option.c_str());
    REScript->Lines->LoadFromStream(msOut);
  } else {
    //sR[ĥݕύX
    KCodeConv::ConvertDelimiter(msIn,D_CRLF);
    REScript->Lines->LoadFromStream(msIn);
  }
  delete msOut;
  delete msIn;
  Modified = false;

  //JgfBNgXNvĝꏊɂ
  AnsiString Dir = ExtractFileDir(File);
  if(Dir!="") {
    SetMyCurrentDir(Dir);
  }

  //gq猾ݒύX
  CopalConfig->SearchByExt(File);

  FMain->AddHistory(File);
  FMain->UpdateAll();
}
//---------------------------------------------------------------------------
/**
 * VK쐬
 */
void
TFScript::New(void) {
  FileName="";
  REScript->Lines->Clear();
  Modified=false;

  FMain->CloseError();
  CopalConfig->SetReadOnly(false);
  FMain->UpdateAll();
}
//---------------------------------------------------------------------------
void __fastcall
TFScript::FormActivate(TObject *Sender) {
  FMain->ChangeWindow(SCRIPT_WINDOW);
}
//---------------------------------------------------------------------------
// Nbv{[h֘A
//---------------------------------------------------------------------------
/**
 * ؂
 */
void
TFScript::Cut(void) {
  if(REScript->SelText=="") {
    return;
  }
  TClipboard *cb = Clipboard();
  cb->AsText = REScript->SelText;
  REScript->Lines->BeginUpdate();
  REScript->Perform(EM_REPLACESEL,true,(int)"");
  REScript->Lines->EndUpdate();
}
//---------------------------------------------------------------------------
/**
 * Rs[
 */
void
TFScript::Copy(void) {
  if(REScript->SelText=="") {
    return;
  }
  TClipboard *cb = Clipboard();
  cb->AsText = REScript->SelText;
}
//---------------------------------------------------------------------------
/**
 * \t
 */
void
TFScript::Paste(void) {
  TClipboard *cb = Clipboard();
  REScript->Lines->BeginUpdate();
  REScript->Perform(EM_REPLACESEL,true,(int)(cb->AsText.c_str()));
  REScript->Lines->EndUpdate();
}
//---------------------------------------------------------------------------
// GfBbg֘A
//---------------------------------------------------------------------------
/**
 * AhD
 */
void
TFScript::Undo(void) {
  REScript->Perform(EM_UNDO,0,0);
}
//---------------------------------------------------------------------------
/**
 * t@C̓ǂݍ
 */
void
TFScript::Load(void) {
  OpenDialog->Filter = CopalConfig->GetFileFilter();
  OpenDialog->Title = "XNvgJ";
  OpenDialog->InitialDir = GetMyCurrentDir();
  if(!OpenDialog->Execute()) {
    return;
  }
  LoadFromFile(OpenDialog->FileName);
  AnsiString Dir = ExtractFileDir(FileName);
  if(Dir!="") {
    SetMyCurrentDir(Dir);
  }
  CopalConfig->SetReadOnly(false);
}
//---------------------------------------------------------------------------
/**
 * t@C̕ۑ
 */
void
TFScript::Save(void) {
  if(FileName!="") {
    SaveToFile(FileName);
  } else {
    SaveAs();
  }
}
//---------------------------------------------------------------------------
/**
 * t@C̕ۑ
 */
void
TFScript::SaveAs(void) {
  FMain->SaveDialog->Filter = CopalConfig->GetFileFilter();
  FMain->SaveDialog->Title = "XNvgۑ";
  FMain->SaveDialog->InitialDir = GetMyCurrentDir();
  FMain->SaveDialog->DefaultExt = CopalConfig->GetDefaultExt();

  if(!FMain->SaveDialog->Execute()) {
    return;
  }
  FileName = FMain->SaveDialog->FileName;
  SaveToFile(FileName);
}
//---------------------------------------------------------------------------
/**
 * ۑ邩
 * Ԃl
 * true  i߂Ănj
 * false i߂Ă͂Ȃ
 */
bool
TFScript::SaveQuery(void) {

  if(!Modified) {
    return true;
  }

  AnsiString msg;

  if (FileName=="") {
    msg = "XNvg ";
  } else {
    msg = FileName;
  }
  msg += "͕ύXĂ܂Bۑ܂H";
  int result = MessageBox(this->Handle,msg.c_str(),"Copal - ۑmF",MB_YESNOCANCEL|MB_ICONEXCLAMATION);

  switch(result) {
  case IDYES:
    //ۑ
    Save();
    if(Modified) {
      return false;
    }
    break;

  case IDNO:
    //ۑȂŏI
    break;
  case IDCANCEL:
    //IȂ
    return false;
  }
  return true;
}
//---------------------------------------------------------------------------
/**
 * LvVp̕Ԃ
 */
AnsiString
TFScript::GetCaptionStr(void) {

  if(FileName=="") {
    return "Copal2 * VKXNvg";
  }
  if(Modified) {
    return "Copal2 * " + FileName;
  } else {
    return "Copal2 - " + FileName;
  }
}
//---------------------------------------------------------------------------
/**
 * OGfB^̎s
 * strueԂ
 */
bool
TFScript::ExecuteEditor(void) {

  if(CopalConfig->Editor=="") {
    return false;
  }

  if(Modified) {
    if(!SaveQuery()) {
      return false;
    }
  }

  AnsiString as1 = FileName;

  if(CopalConfig->UseDoubleQuotes) {
    as1 = "\""+as1+"\"";
  }

  if(!FileExists(CopalConfig->Editor)) {
    ShowMessage(CopalConfig->Editor+"܂BpXmFĂB");
    return false;
  }

  ShellExecute(this->Handle,NULL,CopalConfig->Editor.c_str(),as1.c_str(),NULL,SW_SHOW);

  return true;
}
//---------------------------------------------------------------------------
/**
 * J[\ʒuʓɔzuR[h
 */
void
TFScript::MakeCursorVisible(void) {
  const int TopLineMargin = 5;
  int firstline = REScript->Perform(EM_GETFIRSTVISIBLELINE,0,0);
  int line = REScript->Perform(EM_LINEFROMCHAR,-1,0);
  if(line>TopLineMargin) {
    firstline += TopLineMargin;
    REScript->Perform(EM_LINESCROLL,0,line-firstline);
  } else {
    REScript->Perform(EM_LINESCROLL,0,-firstline);
  }
}
//---------------------------------------------------------------------------
/**
 * sWvC^[tF[X
 */
void
TFScript::LineJump(int line) {
  int pos = REScript->Perform(EM_LINEINDEX,line - 1,0);
  REScript->SelStart = pos;
  MakeCursorVisible();
  REScript->SetFocus();
}
//---------------------------------------------------------------------------
/**
 * wvp̕
 */
AnsiString
TFScript::GetHelpKeyWord(void) {
  int line_number = SendMessage(REScript->Handle,EM_LINEFROMCHAR,REScript->SelStart,0);
  int line_pos = SendMessage(REScript->Handle,EM_LINEINDEX,line_number,0);
  int pos = REScript->SelStart - line_pos;
  AnsiString Line = REScript->Lines->Strings[line_number];
  int startpos,endpos;

  if(pos==0)
    pos++;
  if(pos==Line.Length())
    pos--;

  if(pos!=0) {
    for(startpos = pos;startpos>1;startpos--) {
      if(Line[startpos] == ' ') {
        startpos++;
        break;
      }
      if(Line[startpos] == ')') {
        startpos++;
        break;
      }
      if(Line[startpos] == '}') {
        startpos++;
        break;
      }
      if(Line[startpos] == '(') {
        startpos++;
        break;
      }
      if(Line[startpos] == '{') {
        startpos++;
        break;
      }
      if(Line[startpos] == '/') {
        startpos++;
        break;
      }
      if(Line[startpos] == '=') {
        startpos++;
        break;
      }
    }
  }

  if(pos!=Line.Length()) {
    for(endpos = pos;endpos<=Line.Length();endpos++) {
      if(Line[endpos] == ' ') {
        endpos--;
        break;
      }
      if(Line[endpos] == '(') {
        endpos--;
        break;
      }
      if(Line[endpos] == '{') {
        endpos--;
        break;
      }
      if(Line[endpos] == ')') {
        endpos--;
        break;
      }
      if(Line[endpos] == '}') {
        endpos--;
        break;
      }
      if(Line[endpos] == '/') {
        endpos--;
        break;
      }
      if(Line[endpos] == '=') {
        endpos--;
        break;
      }
    }
  }
  return Line.SubString(startpos,endpos-startpos+1);
}
//---------------------------------------------------------------------------
/**
 * Xe[^Xo[\p̕
 */
AnsiString
TFScript::GetCaretString(void) {
  AnsiString as;
  int line_number = SendMessage(REScript->Handle,EM_LINEFROMCHAR,REScript->SelStart,0);
  int line_pos = SendMessage(REScript->Handle,EM_LINEINDEX,line_number,0);
  int pos = REScript->SelStart - line_pos;
  as+=" "+IntToStr(line_number+1);
  as+=": ";
  as+=IntToStr(pos+1);
  if(REScript->SelLength!=0) {
    as+=" ("+IntToStr(REScript->SelLength)+")";
  }
  return as;
}
//---------------------------------------------------------------------------
/**
 * t@CX^v`FbN
 * OŕύXĂ珈
 */
 void
 TFScript::CheckFileDate(void) {

  if(FileName =="") {
    return;
  }
  if(!FileExists(FileName)) {
    return;
  }
  if(FileDate == FileAge(FileName)) {
    return;
  }

  if(CopalConfig->AutoRefresh) {
    LoadFromFile(FileName);
  } else {
    FileDate = FileAge(FileName);
    PostMessage(FMain->Handle,WM_FILEUPDATED,0,0);
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFScript::REScriptChange(TObject *Sender) {
  Modified = true;
  FMain->UpdateCaption();
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------
void __fastcall
TFScript::REScriptMouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y) {
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------
void __fastcall
TFScript::REScriptKeyUp(TObject *Sender, WORD &Key, TShiftState Shift) {
  FMain->UpdateStatusBar();
  FMain->UpdateMenu();
}
//---------------------------------------------------------------------------
void __fastcall
TFScript::REScriptMouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y) {
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------

