//---------------------------------------------------------------------------
// Copal CtH[
//---------------------------------------------------------------------------
#include <windows.h>
#include <vcl.h>
#include <dir.h>
#pragma hdrstop

const char *Version = "Copal Ver 2.86"; //o[W

AnsiString DefaultPath;

#include "KExecProc.h"
#include "KCopalConfig.h"
//---------------------------------------------------------------------------
#include "Main.h"
#include "Editor.h"
#include "Version.h"
#include "KRegexp.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFMain *FMain;
//---------------------------------------------------------------------------
/**
 * RXgN^
 */
__fastcall
TFMain::TFMain(TComponent* Owner)
    : TForm(Owner) {
  //bZ[W̃tbN
  Application->HookMainWindow(Hook);

  //hbO󂯎
  DragAcceptFiles(this->Handle,true);

  //qXg
  Classes::TNotifyEvent temp = &OnHistoryClick;
  FileHistory = new KFileHistory(MMReload,temp);

  //ftHgpX̍쐬
  DefaultPath = ExtractFilePath(Application->ExeName);

  //RtBOǂݍ
  CopalConfig = new KCopalConfig(DefaultPath);

  CopalConfig->SearchDefFiles();

  CopalConfig->Load();

  MakeLanguageMenu();

  htmlhelp = Htmlhelp::GetInstance();
}
//---------------------------------------------------------------------------
/**
 * vȌ
 */
void
TFMain::Init(AnsiString FileName) {

  FScript->SetCopalConfig(CopalConfig);
  CurrentForm = FScript;
  CloseError();
  PageControl->SelectNextPage(true);
  PageControl->SelectNextPage(true);
  if(CopalConfig->isMaximized()) {
    WindowState = wsMaximized;
  }

  //t@Cw肳ĂJ
  if(FileName != "") {
    FScript->LoadFromFile(FileName);
  }

  //NKF32.DLL邩`FbN
  if(!KCodeConv::CheckNKF32()) {
    MMEncode->Enabled = false;
  }

  //BREGEXP.DLL̃[h
  KRegexp::Init();

  //ϐGfB^őOʂɕ\邩
  CopalConfig->SetFEditorStayOnTop();

  FScript->SetCode(CopalConfig->GetCodeMode());

  UpdateAll();
}
//---------------------------------------------------------------------------
/**
 * tH[N[Y̏
 * fXgN^ƂĎgĂ
 */
void __fastcall
TFMain::FormClose(TObject *Sender, TCloseAction &Action) {
  //݂̏̕ۑ
  CONFIGSAVEPARAM csp;

  csp.Maximized = (WindowState==wsMaximized);

  WindowState =wsNormal;

  csp.Width = Width;
  csp.Height = Height;

  CopalConfig->Save(csp);

  //bZ[W̃AtbN
  Application->UnhookMainWindow(Hook);

  //Еt
  delete CopalConfig;
  delete FileHistory;

  KRegexp::Free();
  KCodeConv::FreeNKF32();
}
//---------------------------------------------------------------------------
/**
 * bZ[W̃tbN
 */
bool __fastcall
TFMain::Hook(TMessage &Message) {
  if (Message.Msg == CM_APPKEYDOWN) {
    return true;
  } else {
    return false;
  }
}
//---------------------------------------------------------------------------
/**
 * t@C̃hbv
 */
void
TFMain::WMDropFiles(TWMDropFiles &Msg) {
  //Ƃ肠hbv֎~
  DragAcceptFiles(this->Handle,false);
  SetForegroundWindow(this->Handle);
  SetFocus();

  //hbvt@C𓾂
  char filename[MAXPATH];

  AnsiString Files;
  AnsiString HintText;//c[{^ɕ\qg

  int files = DragQueryFile((void*)Msg.Drop,-1,NULL,0);
  for(int i=0;i<files;i++) {
    DragQueryFile((void*)Msg.Drop,i,filename,sizeof(filename));
    AnsiString f2 = filename;
    if(f2.AnsiPos(" ")!=0) {
      f2 = "\""+f2 + "\"";
    }
    Files += f2;
    Files += " ";
    HintText = HintText + "\n" + filename;
  }

  if(files==1 && CopalConfig->SearchByExt(Files)) {
    //gqɂ烍[h
    if(SaveQuery()) {
      FScript->LoadFromFile(Files);
    }
  }else{
    //łȂΈƂĎs
    ExecuteOnDrop(Files,HintText);
  }
  
  DragAcceptFiles(this->Handle,true);
}
//---------------------------------------------------------------------------
/**
 * zbgL[ꂽƂ̏
 */
void __fastcall
TFMain::WMHotKey(TMessage) {

  //ݒ胁j[JĂ疳
  if(FConfig->Visible || FLangConfig->Visible || FNewLang->Visible) {
    return;
  }
  Application->Restore();
  SetForegroundWindow(this->Handle);
  SetFocus();
  Show();
}
//---------------------------------------------------------------------------
/**
 * ۑ邩
 * Ԃl
 * true  i߂Ănj
 * false i߂Ă͂Ȃ
 */
bool
TFMain::SaveQuery(void) {
  ChangeWindow(SCRIPT_WINDOW);
  return FScript->SaveQuery();
}
//---------------------------------------------------------------------------
/**
 * WM_FILEPOST̏
 */
void
TFMain::FilePost(AnsiString FileName) {
  ChangeWindow(SCRIPT_WINDOW);
  if(WindowState == wsMinimized){
    WindowState = wsNormal;
  }
  Show();
  SetForegroundWindow(this->Handle);
  if(FileName !="") {
    if(!SaveQuery()) {
      return;
    }
    FScript->LoadFromFile(FileName);
  }
}
//---------------------------------------------------------------------------
/**
 * ̑I
 */
void __fastcall
TFMain::OnLanguageClick(TObject *Sender) {
  TMenuItem *mi = (TMenuItem*)Sender;
  KDefConfig *df = (KDefConfig*)mi->Tag;
  CopalConfig->ChangeLanguage(df);
  mi->Checked = true;
  UpdateAll();
}
//---------------------------------------------------------------------------
/**
 * t@CqXgNbN
 */
void __fastcall
TFMain::OnHistoryClick(TObject *Sender) {
  TMenuItem *mi = (TMenuItem*)Sender;
  AnsiString FileName = FileHistory->GetFileName(mi->Tag);
  ChangeWindow(SCRIPT_WINDOW);
  if(!SaveQuery()) {
    return;
  }
  FScript->LoadFromFile(FileName);
}
//---------------------------------------------------------------------------
// j[̎s
//---------------------------------------------------------------------------
/**
 * VK쐬
 */
void __fastcall
TFMain::MMNewClick(TObject *Sender) {
  if(!SaveQuery()) {
    return;
  }
  FScript->New();
}
//---------------------------------------------------------------------------
/**
 * t@CJ
 */
void __fastcall
TFMain::MMOpenClick(TObject *Sender) {

  ChangeWindow(SCRIPT_WINDOW);
  if(!SaveQuery()) {
    return;
  }

  FScript->Load();
}
//---------------------------------------------------------------------------
/**
 * ۑ
 */
void __fastcall
TFMain::MMSaveClick(TObject *Sender) {
  if(CurrentForm == NULL) {
    return;
  }
  CurrentForm->Save();
}
//---------------------------------------------------------------------------
/**
 * Otĕۑ
 */
void __fastcall
TFMain::MMSaveAsClick(TObject *Sender) {
  if(CurrentForm == NULL) {
    return;
  }
  CurrentForm->SaveAs();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMAutoClick(TObject *Sender) {
  CopalConfig->SetCodeMode(CM_AUTOSELECT);
  UpdateAll();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMSHIFTJISClick(TObject *Sender) {
  CopalConfig->SetCodeMode(CM_SJIS);
  UpdateAll();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMEUCClick(TObject *Sender) {
  CopalConfig->SetCodeMode(CM_EUC);
  UpdateAll();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMJISClick(TObject *Sender) {
  CopalConfig->SetCodeMode(CM_JIS);
  UpdateAll();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMUTF8Click(TObject *Sender) {
  CopalConfig->SetCodeMode(CM_UTF8);
  UpdateAll();
}
//---------------------------------------------------------------------------
/**
 * AhD
 */
void __fastcall
TFMain::MMUndoClick(TObject *Sender) {
  if(CurrentForm == NULL) {
    return;
  }
  CurrentForm->Undo();
}
//---------------------------------------------------------------------------
/**
 * ؂
 */
void __fastcall
TFMain::MMCutClick(TObject *Sender) {
  if(CurrentForm == NULL) {
    return;
  }
  CurrentForm->Cut();
}
//---------------------------------------------------------------------------
/**
 * Rs[
 */
void __fastcall
TFMain::MMCopyClick(TObject *Sender) {
  if(CurrentForm == NULL) {
    return;
  }
  CurrentForm->Copy();
}
//---------------------------------------------------------------------------
/**
 * \t
 */
void __fastcall
TFMain::MMPasteClick(TObject *Sender) {
  if(CurrentForm == NULL) {
    return;
  }
  CurrentForm->Paste();
}
//---------------------------------------------------------------------------
/**
 * ǂݍݐp
 */
void __fastcall
TFMain::MMReadOnlyClick(TObject *Sender) {
  CopalConfig->SetReadOnly(!CopalConfig->IsReadOnly());
  UpdateAll();
}
//---------------------------------------------------------------------------
// ֌W
//---------------------------------------------------------------------------
/**
 *  
 */
void __fastcall
TFMain::MMFindClick(TObject *Sender) {
  if(CurrentForm == NULL) {
    return;
  }
  CurrentForm->Find();
}
//---------------------------------------------------------------------------
/**
 *  
 */
void __fastcall
TFMain::MMFindNextClick(TObject *Sender) {
  if(CurrentForm == NULL) {
    return;
  }
  CurrentForm->FindNext();
}
//---------------------------------------------------------------------------
/**
 * 
 */
void __fastcall
TFMain::MMFindPrevClick(TObject *Sender) {
  if(CurrentForm == NULL) {
    return;
  }
  CurrentForm->FindPrev();
}
//---------------------------------------------------------------------------
// \
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMScriptWindowClick(TObject *Sender) {
  ChangeWindow(SCRIPT_WINDOW);
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMResultWindowClick(TObject *Sender) {
  ChangeWindow(RESULT_WINDOW);
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMErrorWindowClick(TObject *Sender) {
  ChangeWindow(ERROR_WINDOW);
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMSwichWindowClick(TObject *Sender) {
  ChangeWindow(NEXT_WINDOW);
}
//---------------------------------------------------------------------------
/**
 * bfhtH[GfB^̕\
 */
void __fastcall
TFMain::MMFormEditorClick(TObject *Sender) {
  CopalConfig->UseCGI = true;
  UpdateAll();
  FEditor->Show();
}
//---------------------------------------------------------------------------
// s
//---------------------------------------------------------------------------
/**
 * XNvgs
 */
void __fastcall
TFMain::MMExecuteScriptClick(TObject *Sender) {
  if(!CopalConfig->CheckPath()) {
    if(IDYES ==
        Application->MessageBox(
          "s\t@C܂B\n"
          "Copal̓XNvgŝɁAnKvłB\n"
          "st@C̃pX̐ݒ܂HB","Copal - Error",
          MB_YESNO)) {
      FLangConfig->Execute(CopalConfig);
    }
    return;
  }

  if(MMMemoryDroppedFiles->Checked) {
    Execute(CopalConfig->LastDroppedFiles);
  } else {
    Execute("");
  }

  if(MMSaveAll->Checked) {
    SaveResultToFile();
  }
  if(MMToBrowserAll->Checked) {
    ToBrowser();
  }
}
//---------------------------------------------------------------------------
/**
 * uEU֏o
 */
void __fastcall
TFMain::MMExecToBrowserClick(TObject *Sender) {
  ExecToBrowser();
}
//---------------------------------------------------------------------------
/**
 * Nbv{[h̓eɎs
 */
void __fastcall
TFMain::MMExecToClipClick(TObject *Sender) {
  ExecToClip();
}
//---------------------------------------------------------------------------
/**
 * DOSŎs
 */
void __fastcall
TFMain::MMExecDOSClick(TObject *Sender) {
  ExecDOS();
}
//---------------------------------------------------------------------------
/**
 * Ɍʂt@Cɕۑ
 */
void __fastcall
TFMain::MMSaveAllClick(TObject *Sender) {
  MMSaveAll->Checked = !MMSaveAll->Checked;
  TBSaveAll->Down = MMSaveAll->Checked;
  if(MMSaveAll->Checked) {
    FOpenFile->SetCaption("Copal - Ɍʂt@Cɕۑ");
    if(FOpenFile->Execute()) {
      TBSaveAll->Hint = "Ɍʂt@Cɕۑ\n\n"+FOpenFile->FileName;
      CopalConfig->SaveResultFile = FOpenFile->FileName;
      TBSaveAll->Hint = "Ɍʂt@Cɕۑ\n" + FOpenFile->FileName;
    } else {
      MMSaveAll->Checked = false;
      TBSaveAll->Down = false;
    }
  }
}
//---------------------------------------------------------------------------
/**
 * Nbv{[hɏo͂Ȃ
 */
void __fastcall
TFMain::MMNotClipClick(TObject *Sender) {
  MMNotClip->Checked = !MMNotClip->Checked;
  TBNotClip->Down = MMNotClip->Checked;
}
//---------------------------------------------------------------------------
/**
 * hbvt@CL
 */
void __fastcall
TFMain::MMMemoryDroppedFilesClick(TObject *Sender) {
  MMMemoryDroppedFiles->Checked = !MMMemoryDroppedFiles->Checked;
  TBMemoryDroppedFiles->Down = MMMemoryDroppedFiles->Checked;
}
//---------------------------------------------------------------------------
/**
 * ɃuEU
 */
void __fastcall
TFMain::MMToBrowserAllClick(TObject *Sender) {
  MMToBrowserAll->Checked = !MMToBrowserAll->Checked;
  TBToBrowserAll->Down = MMToBrowserAll->Checked;
}
//---------------------------------------------------------------------------
/**
 * CGIf[^g
 */
void __fastcall
TFMain::MMUseCGIClick(TObject *Sender) {
  CopalConfig->UseCGI = !CopalConfig->UseCGI;
  UpdateAll();
  if(CopalConfig->UseCGI) {
    FEditor->Show();
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMAutoRefreshClick(TObject *Sender) {
  CopalConfig->AutoRefresh = !CopalConfig->AutoRefresh;
  UpdateAll();
}
//---------------------------------------------------------------------------
/**
 * OGfB^̎s
 */
void __fastcall
TFMain::MMExecuteEditorClick(TObject *Sender) {
  if (!FScript->ExecuteEditor()) {
    return;
  }
  //uI[gtbVɕҏW֎~vZbgĂҏW֎~Ƃ
  if (CopalConfig->AutoRefresh && CopalConfig->ReadOnlyWhenAutoRefresh) {
    CopalConfig->SetReadOnly(true);
    UpdateAll();
  }

}
//---------------------------------------------------------------------------
/**
 * JgfBNg̕ύX
 */
void __fastcall
TFMain::MMChangeDirClick(TObject *Sender) {
  if(!FOpenDir->Execute()) {
    return;
  }
  //ύX
  FScript->SetMyCurrentDir(FOpenDir->GetDir());
  FResult->SetMyCurrentDir(FOpenDir->GetDir());
  UpdateAll();
}
//---------------------------------------------------------------------------
// ݒ
//---------------------------------------------------------------------------
/**
 * ݒ
 */
void __fastcall
TFMain::MMEnvironmentSettingsClick(TObject *Sender) {
  FConfig->Execute(CopalConfig);
}
//---------------------------------------------------------------------------
/**
 * ʂ̐ݒ
 */
void __fastcall
TFMain::MMLanguageSettingsClick(TObject *Sender) {
  FLangConfig->Execute(CopalConfig);
}
//---------------------------------------------------------------------------
/**
 * Vǉ
 */
void __fastcall
TFMain::MMNewLangClick(TObject *Sender) {
  if(!FNewLang->Execute(CopalConfig)){
    return;
  }
  CopalConfig->CreateDefConfig(FNewLang->LangName,FNewLang->LangPath);
  MakeLanguageMenu();
  UpdateAll();
}
//---------------------------------------------------------------------------
/**
 * I
 */
void __fastcall
TFMain::MMExitClick(TObject *Sender) {
  Close();
}
//---------------------------------------------------------------------------
/**
 * ڎ̕\
 */
void __fastcall
TFMain::MMContentsClick(TObject *Sender) {
  if(FileExists(CopalConfig->HelpFile)){
    WinHelp(Application->Handle,CopalConfig->HelpFile.c_str(),HELP_CONTENTS,0);
  }else{
    AnsiString HtmlHelp = ChangeFileExt(CopalConfig->HelpFile,".chm");
    if(FileExists(HtmlHelp)){
      htmlhelp->ShowHtmlHelp(this->Handle,HtmlHelp.c_str());
    }else{
      ShowMessage("wvt@C(copalpro.chm)܂");
    }
  }
}
//---------------------------------------------------------------------------
/**
 * L[[h
 */
void __fastcall
TFMain::MMSearchKeywordClick(TObject *Sender) {

  if(CopalConfig->GetUseHelp()) {
    if(!FileExists(CopalConfig->GetHelpFile())) {
      ShowMessage(CopalConfig->GetHelpFile() + "܂B");
      return;
    }

    if(ExtractFileExt(CopalConfig->GetHelpFile()).LowerCase()==".chm"){
      htmlhelp->ShowHtmlHelpSearch(Application->Handle,CopalConfig->GetHelpFile().c_str(),FScript->GetHelpKeyWord().c_str());
    } else {
      WinHelp(Application->Handle,CopalConfig->GetHelpFile().c_str(),HELP_KEY,(DWORD)FScript->GetHelpKeyWord().c_str());
    }
  } else {
    MMContents->Click();
  }
}
//---------------------------------------------------------------------------
/**
 * o[W̕\
 */
void __fastcall
TFMain::MMVersionClick(TObject *Sender) {
  if(FVersion==NULL) {
    FVersion = new TFVersion(this);
  }
  FVersion->ShowModal();
  delete FVersion;
  FVersion = NULL;
}
//---------------------------------------------------------------------------
// c[{^̎s
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBNewClick(TObject *Sender) {
  MMNew->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBOpenClick(TObject *Sender) {
  MMOpen->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBSaveClick(TObject *Sender) {
  MMSave->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBCutClick(TObject *Sender) {
  MMCut->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBCopyClick(TObject *Sender) {
  MMCopy->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBPasteClick(TObject *Sender) {
  MMPaste->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBReadOnlyClick(TObject *Sender) {
  MMReadOnly->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBExecuteScriptClick(TObject *Sender) {
  MMExecuteScript->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBExecToBrowserClick(TObject *Sender) {
  MMExecToBrowser->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBExecToClipClick(TObject *Sender) {
  MMExecToClip->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBExecDOSClick(TObject *Sender) {
  MMExecDOS->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBToBrowserAllClick(TObject *Sender) {
  MMToBrowserAll->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBSaveAllClick(TObject *Sender) {
  MMSaveAll->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBNotClipClick(TObject *Sender) {
  MMNotClip->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBMemoryDroppedFilesClick(TObject *Sender) {
  MMMemoryDroppedFiles->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBUseCGIClick(TObject *Sender) {
  MMUseCGI->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBAutoRefreshClick(TObject *Sender) {
  MMAutoRefresh->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBExecuteEditorClick(TObject *Sender) {
  MMExecuteEditor->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::TBSeachKeywordClick(TObject *Sender) {
  MMSearchKeyword->Click();
}
//---------------------------------------------------------------------------
/**
 * Xvb^[̏
 */
void __fastcall
TFMain::SplitterMoved(TObject *Sender) {
  if(!PStdError->Visible) {
    return;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::FormCloseQuery(TObject *Sender, bool &CanClose) {
  if(!SaveQuery()) {
    CanClose = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::On_WM_Activate(TWMActivate &Msg) {
  if(Msg.Active != WA_INACTIVE){
    FScript->CheckFileDate();
  }
  UpdateCaption();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::OnFileUpdated(TMessage &Msg) {
  if(MessageBox(this->Handle,"XNvgύXĂ܂Bǂݍݒ܂H","Copal", MB_YESNO) == ID_YES) {
    FScript->Reload();
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::PageControlMouseDown(TObject *Sender,
                             TMouseButton Button, TShiftState Shift, int X, int Y) {
  if(PageControl->ActivePage==PageControl->Pages[0]) {
    ChangeWindow(SCRIPT_WINDOW);
  } else {
    ChangeWindow(RESULT_WINDOW);
  }
}
//---------------------------------------------------------------------------
// |bvAbvj[
//---------------------------------------------------------------------------
void __fastcall
TFMain::PMCutClick(TObject *Sender) {
  MMCut->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::PMCopyClick(TObject *Sender) {
  MMCopy->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::PMPasteClick(TObject *Sender) {
  MMPaste->Click();
}
//---------------------------------------------------------------------------
/**
 * G[Undock֎~
 */
void __fastcall
TFMain::PStdErrorUnDock(TObject *Sender, TControl *Client,
                        TWinControl *NewTarget, bool &Allow) {
  Allow = false;
}
//---------------------------------------------------------------------------

