//---------------------------------------------------------------------------
#ifndef KCodeConvH
#define KCodeConvH
//---------------------------------------------------------------------------

enum delimiter {D_LF=0,D_CR,D_CRLF};
enum code {C_SJIS=0,C_EUC,C_JIS,C_UTF8};

class KCodeConv{
  private:
  static char * CodeChar[];
  static char * DelimiterChar[];
  static bool bNKF32Exists;
  static HINSTANCE hNKF32;

  static int GetFileSize(char *filename);

  public:
  static bool CheckNKF32(void);
  static void FreeNKF32(void);
  static bool NKF32Exists(void){
    return bNKF32Exists;
  };

  static int GetCodeType(char *filename);
  static int GetDelimiterType(char *filename);
  static void ConvertCode(TMemoryStream *ms,char *inbuf,int CodeType);
  static AnsiString GetConvertOption(int FromCode, int ToCode);
  static AnsiString GetURLEncodedText(AnsiString inText,int CodeType);//URLGR[h
  static void Convert(char *inbuf,char *buf,char *option);
  static void ConvertDelimiter(TMemoryStream *ms,int Type);
  static void ConvertStream(TMemoryStream *msIn,TMemoryStream *msOut,char *option);
  static void SaveConvertedFile(AnsiString FileName,AnsiString Text,int ctype, int dtype);
  static int GetKanjiCode(void);

  //C^tF[X
  static char* GetCodeChar(int type){
    return CodeChar[type];
  };

  static char* GetDelimiterChar(int type){
    return DelimiterChar[type];
  };
};
//---------------------------------------------------------------------------
#endif
