//---------------------------------------------------------------------------
// Copal CtH[
//---------------------------------------------------------------------------
#ifndef MainH
#define MainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <Menus.hpp>
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------
#include <ImgList.hpp>
#include <ToolWin.hpp>
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
#include "Script.h"
#include "Result.h"
#include "StdError.h"
#include "LangConfig.h"
#include "KFileHistory.h"
#include "Config.h"
#include "NewLang.h"
#include "OpenFile.h"
#include "OpenDir.h"
#include "HHelp.h"
//---------------------------------------------------------------------------
// 萔̐錾
//---------------------------------------------------------------------------
enum WindowMode {SCRIPT_WINDOW, RESULT_WINDOW,ERROR_WINDOW,NEXT_WINDOW};

const WPARAM WM_FILEPOST = WM_USER + 1;
const WPARAM WM_FILEUPDATED = WM_USER + 2;

//---------------------------------------------------------------------------

class TFMain : public TForm {
__published:	// IDE Ǘ̃R|[lg
  TMainMenu *MainMenu;
  TMenuItem *MMFile;
  TMenuItem *MMNew;
  TMenuItem *MMOpen;
  TMenuItem *Edit1;
  TMenuItem *MMUndo;
  TMenuItem *N1;
  TMenuItem *MMCopy;
  TMenuItem *N2;
  TMenuItem *MMExit;
  TMenuItem *Config1;
  TMenuItem *MMLanguage;
  TMenuItem *Execute1;
  TMenuItem *MMExecuteScript;
  TMenuItem *MMEnvironmentSettings;
  TPageControl *PageControl;
  TPanel *PStdError;
  TSplitter *Splitter;
  TMenuItem *Help1;
  TMenuItem *MMContents;
  TMenuItem *MMVersion;
  TMenuItem *MMCut;
  TMenuItem *MMPaste;
  TToolBar *ToolBar;
  TImageList *ILButtons;
  TToolButton *TBNew;
  TToolButton *TBOpen;
  TToolButton *TBSave;
  TToolButton *ToolButton4;
  TToolButton *TBCut;
  TToolButton *TBCopy;
  TToolButton *TBPaste;
  TMenuItem *MMSave;
  TSaveDialog *SaveDialog;
  TToolButton *ToolButton1;
  TToolButton *TBExecuteScript;
  TStatusBar *StatusBar;
  TMenuItem *MMView;
  TMenuItem *MMScriptWindow;
  TMenuItem *MMResultWindow;
  TMenuItem *MMErrorWindow;
  TMenuItem *MMSaveAs;
  TToolButton *ToolButton2;
  TToolButton *TBMemoryDroppedFiles;
  TMenuItem *N3;
  TMenuItem *MMMemoryDroppedFiles;
  TMenuItem *MMLanguageSettings;
  TMenuItem *MMSearchKeyword;
  TToolButton *ToolButton3;
  TToolButton *TBSeachKeyword;
  TMenuItem *MMRedo;
  TToolButton *TBExecuteEditor;
  TToolButton *ToolButton6;
  TMenuItem *N4;
  TMenuItem *MMExecuteEditor;
  TToolButton *TBAutoRefresh;
  TMenuItem *MMAutoRefresh;
  TMenuItem *MMExecDOS;
  TToolButton *TBExecDOS;
  TToolButton *TBExecToClip;
  TToolButton *TBNotClip;
  TMenuItem *MMExecToClip;
  TMenuItem *MMNotClip;
  TToolButton *TBExecToBrowser;
  TMenuItem *MMExecToBrowser;
  TMenuItem *N5;
  TMenuItem *MMNewLang;
  TMenuItem *MMToBrowserAll;
  TToolButton *TBToBrowserAll;
  TMenuItem *MMReload;
  TMenuItem *MMEncode;
  TMenuItem *MMSHIFTJIS;
  TMenuItem *MMEUC;
  TMenuItem *MMJIS;
  TMenuItem *MMAuto;
  TMenuItem *MMChangeDir;
  TPopupMenu *PopupMenu;
  TMenuItem *PMCut;
  TMenuItem *PMCopy;
  TMenuItem *PMPaste;
  TMenuItem *N7;
  TMenuItem *MMFormEditor;
  TToolButton *TBUseCGI;
  TMenuItem *MMUseCGI;
  TToolButton *TBSaveAll;
  TMenuItem *MMSaveAll;
  TMenuItem *MMSearchMenu;
  TMenuItem *MMFind;
  TMenuItem *MMFindNext;
  TFindDialog *FindDialog;
  TMenuItem *MMFindPrev;
  TMenuItem *MMUTF8;
  TMenuItem *N6;
  TMenuItem *MMReadOnly;
  TToolButton *TBReadOnly;
        TMenuItem *MMSwichWindow;
  void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
  void __fastcall MMExecuteScriptClick(TObject *Sender);
  void __fastcall MMCopyClick(TObject *Sender);
  void __fastcall MMExitClick(TObject *Sender);
  void __fastcall MMCutClick(TObject *Sender);
  void __fastcall MMPasteClick(TObject *Sender);
  void __fastcall MMOpenClick(TObject *Sender);
  void __fastcall MMSaveClick(TObject *Sender);
  void __fastcall TBNewClick(TObject *Sender);
  void __fastcall TBOpenClick(TObject *Sender);
  void __fastcall TBSaveClick(TObject *Sender);
  void __fastcall TBCutClick(TObject *Sender);
  void __fastcall TBCopyClick(TObject *Sender);
  void __fastcall TBPasteClick(TObject *Sender);
  void __fastcall TBExecuteScriptClick(TObject *Sender);
  void __fastcall MMScriptWindowClick(TObject *Sender);
  void __fastcall MMResultWindowClick(TObject *Sender);
  void __fastcall MMErrorWindowClick(TObject *Sender);
  void __fastcall SplitterMoved(TObject *Sender);
  void __fastcall MMNewClick(TObject *Sender);
  void __fastcall MMVersionClick(TObject *Sender);
  void __fastcall FormCloseQuery(TObject *Sender, bool &CanClose);
  void __fastcall TBMemoryDroppedFilesClick(TObject *Sender);
  void __fastcall MMMemoryDroppedFilesClick(TObject *Sender);
  void __fastcall MMLanguageSettingsClick(TObject *Sender);
  void __fastcall MMContentsClick(TObject *Sender);
  void __fastcall MMSearchKeywordClick(TObject *Sender);
  void __fastcall TBSeachKeywordClick(TObject *Sender);
  void __fastcall MMEnvironmentSettingsClick(TObject *Sender);
  void __fastcall MMExecuteEditorClick(TObject *Sender);
  void __fastcall TBExecuteEditorClick(TObject *Sender);
  void __fastcall MMAutoRefreshClick(TObject *Sender);
  void __fastcall TBAutoRefreshClick(TObject *Sender);
  void __fastcall MMExecDOSClick(TObject *Sender);
  void __fastcall TBExecDOSClick(TObject *Sender);
  void __fastcall MMNotClipClick(TObject *Sender);
  void __fastcall TBNotClipClick(TObject *Sender);
  void __fastcall MMExecToClipClick(TObject *Sender);
  void __fastcall TBExecToClipClick(TObject *Sender);
  void __fastcall MMSaveAsClick(TObject *Sender);
  void __fastcall PageControlMouseDown(TObject *Sender,
                                       TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall TBExecToBrowserClick(TObject *Sender);
  void __fastcall MMExecToBrowserClick(TObject *Sender);
  void __fastcall MMNewLangClick(TObject *Sender);
  void __fastcall MMToBrowserAllClick(TObject *Sender);
  void __fastcall TBToBrowserAllClick(TObject *Sender);
  void __fastcall MMAutoClick(TObject *Sender);
  void __fastcall MMSHIFTJISClick(TObject *Sender);
  void __fastcall MMEUCClick(TObject *Sender);
  void __fastcall MMJISClick(TObject *Sender);
  void __fastcall MMChangeDirClick(TObject *Sender);
  void __fastcall MMUndoClick(TObject *Sender);
  void __fastcall PMCutClick(TObject *Sender);
  void __fastcall PMCopyClick(TObject *Sender);
  void __fastcall PMPasteClick(TObject *Sender);
  void __fastcall PStdErrorUnDock(TObject *Sender, TControl *Client,
                                  TWinControl *NewTarget, bool &Allow);
  void __fastcall MMFormEditorClick(TObject *Sender);
  void __fastcall MMUseCGIClick(TObject *Sender);
  void __fastcall TBUseCGIClick(TObject *Sender);
  void __fastcall MMSaveAllClick(TObject *Sender);
  void __fastcall TBSaveAllClick(TObject *Sender);
  void __fastcall MMFindClick(TObject *Sender);
  void __fastcall MMFindNextClick(TObject *Sender);
  void __fastcall MMFindPrevClick(TObject *Sender);
  void __fastcall MMUTF8Click(TObject *Sender);
  void __fastcall MMReadOnlyClick(TObject *Sender);
  void __fastcall TBReadOnlyClick(TObject *Sender);
        void __fastcall MMSwichWindowClick(TObject *Sender);
private:	// [U[錾

  KCopalConfig *CopalConfig;//RtBO
  KFileHistory *FileHistory;//t@CqXg
  Htmlhelp *htmlhelp; //HTMLwṽbp

  int LastError; //G[R[h
  int GetErrorCode(void) {
    return LastError;
  };
  void SetErrorCode(int e) {
    LastError = e;
  };

  //---------------------------------------------------------------------------
  // s֘A
  //---------------------------------------------------------------------------
  void Execute(AnsiString);
  void ExecDOS(void);//DOSŎs
  void ExecToBrowser(void);//sʂuEU
  void ExecToClip(void);//Nbv{[h̓e͂ƂĎs
  void ExecuteOnDrop(AnsiString Files, AnsiString HintText);

  void ToBrowser(void);//ʂuEU֔΂
  void SaveResultToFile(void);//ʂɃt@C֕ۑ
  //---------------------------------------------------------------------------
  // j[֌W
  //---------------------------------------------------------------------------
  void MakeLanguageMenu(void);//ꃁj[̍쐬
  __fastcall void OnLanguageClick(TObject *Sender);//I
  void __fastcall OnHistoryClick(TObject *Sender);//qXgNbN
  //---------------------------------------------------------------------------
  TFBase *CurrentForm;//݃ANeBuȃEBhE

public:		// [U[錾


  bool __fastcall Hook(TMessage &Message);
  bool SaveQuery(void);//Z[ũNG[

  //---------------------------------------------------------------------------
  // \֘A
  //---------------------------------------------------------------------------
  void UpdateAll(void);
  void ChangeWindow(int Window);
  void UpdateCaption(void);
  void UpdateMenu(void);
  void UpdateStatusBar(void);//Xe[^X\̍XV
  void SetMenuChecked(void);//j[̃`FbN
  void OpenError(void);//\̍XV
  void CloseError(void);//\̍XV
  //---------------------------------------------------------------------------
  void Init(AnsiString FileName);//
  //---------------------------------------------------------------------------
  // C^[tF[X
  //---------------------------------------------------------------------------
  KCopalConfig *GetCopalConfig(void) {
    return CopalConfig;
  }
  ;//CopalConfig𓾂
  void SaveHistory(TIniFile *i) {
    FileHistory->SaveHistory(i);
  };
  void LoadHistory(TIniFile *i) {
    FileHistory->LoadHistory(i);
  };
  AnsiString GetTempFile(void) {
    return CopalConfig->GetTempFile();
  };

  void AddHistory(AnsiString FileName) {
    FileHistory->OpenFile(FileName);
  };
  void FilePost(AnsiString FileName);//WM_FILEPOST̏

  //---------------------------------------------------------------------------
  // Cxgn
  //---------------------------------------------------------------------------
  void WMDropFiles(TWMDropFiles &Msg);//t@C̃hbv
  void __fastcall On_WM_Activate(TWMActivate &msg);
  void __fastcall WMHotKey(TMessage);
  void __fastcall OnFileUpdated(TMessage &msg);//t@CCꂽ

  BEGIN_MESSAGE_MAP
  MESSAGE_HANDLER( WM_DROPFILES , TWMDropFiles, WMDropFiles )
  MESSAGE_HANDLER(WM_ACTIVATE, TWMActivate, On_WM_Activate)
  MESSAGE_HANDLER( WM_HOTKEY , TMessage,  WMHotKey)
  MESSAGE_HANDLER( WM_FILEUPDATED , TMessage,  OnFileUpdated)
  END_MESSAGE_MAP( TForm )
  __fastcall TFMain(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TFMain *FMain;
//---------------------------------------------------------------------------
#endif
