//---------------------------------------------------------------------------
// BRegexp.dll̃bp[NX
//---------------------------------------------------------------------------

#ifndef KRegexpH
#define KRegexpH
#include <vcl.h>
#include <utilcls.h>
//---------------------------------------------------------------------------
typedef char* (CALLBACK *BREGEXPVERSION)(void);

typedef struct bregexp {
  const char *outp;	// BSubst uf[^̐擪|C^
  const char *outendp;	// BSubst uf[^̍ŏI|C^+1
  const int  splitctr;	// BSplit z
  const char **splitp;	// BSplit f[^|C^
  int	rsv1;		// U[u@RɎgp\
  char *parap;		// p^[f[^|C^
  char *paraendp;		// p^[f[^|C^+1
  char *transtblp;	// BTrans ϊe[u|C^
  char **startp;		// }b`f[^̐擪|C^
  char **endp;		// }b`f[^̍ŏI|C^+1
  int nparens;		// p^[̒() ̐B $1,$2, 𒲂ׂƂɎgp
  bregexp(void);
}
BREGEXP;

typedef void* (CALLBACK *BREGFREE)(BREGEXP*);
typedef int (CALLBACK *BMATCH)(LPSTR,LPSTR,LPSTR,BREGEXP**,LPSTR);

const int MAX_PATTERN = 10;
//---------------------------------------------------------------------------
class KRegexp {


private:
  //static HINSTANCE hBRegexp;
  static TDll *hBRegexp;
public:

  static AnsiString *Pattern;

  static BREGEXPVERSION GetVersion;
  static BREGFREE BRegFree;
  static BMATCH BMatch;

  static void Init(void);
  static void Free(void);
  static bool GetMatchStr(AnsiString asTarget, AnsiString asRegexp);

};
//---------------------------------------------------------------------------
#endif
