/**
 *
 */
#if !defined(COOLRAIN__TEMPLATE__H__)
#define COOLRAIN__TEMPLATE__H__

#include <limits.h>
#include <stdarg.h>
#include <glib/gmacros.h>

#include <CoolRain/refstring.h>
#include <CoolRain/thread.h>
#include <CoolRain/tagset.h>
#include <CoolRain/stash.h>
#include <CoolRain/fragment.h>

G_BEGIN_DECLS;

typedef void (*coolrain_template_error_handler_t)(
	struct coolrain_template *tmpl, char const *message);

struct coolrain_loader;

struct coolrain_template {
	coolrain_mutex_t	mutex;

	struct coolrain_fragment	*root;
	struct coolrain_tagset		*tagset;

	struct coolrain_loader		*loader;
	char const	*name;
	coolrain_refstring_t	source;

	struct {
		char const	*cursor;
		unsigned int	lineno;
	} parser_state;

	void	(*destroy_callback)(struct coolrain_template *tmpl);
	void	*destroy_data;

	coolrain_template_error_handler_t	error_handler;
	void	*error_user_data;
};



struct coolrain_eval_context {
	struct coolrain_template	*tmpl;
	struct coolrain_stash		*stash;
	struct coolrain_fragment	*fragment;
	struct coolrain_writer		*writer;
};



int coolrain_template_initialize(struct coolrain_template *tmpl, struct coolrain_tagset *tagset);
int coolrain_template_destroy(struct coolrain_template *tmpl);
int coolrain_template_clear(struct coolrain_template *tmpl);


void coolrain_template_set_name(
	struct coolrain_template * __restrict templ,
	char const * __restrict name);

int coolrain_template_set_error_handler(
	struct coolrain_template *tmpl,
	coolrain_template_error_handler_t handler,
	void *user_data);
void coolrain_template_raise_error(
	struct coolrain_template *tmpl,
	char const *fmt,
	...);
void coolrain_template_vraise_error(
	struct coolrain_template *tmpl,
	char const *fmt, 
	va_list va);

int coolrain_template_compile(struct coolrain_template *tmpl, char const* path);
int coolrain_template_save(struct coolrain_template *tmpl, char const* path);
int coolrain_template_load(struct coolrain_template *tmpl, char const* path);
int coolrain_template_parse(
	struct coolrain_template *tmpl,
	char const* name,
	char const* source,
	size_t	length,
	void (*destroy_callback)(struct coolrain_template *),
	void* destroy_data);

int coolrain_template_eval_block(struct coolrain_eval_context const *cntx);


static inline int coolrain_template_eval_content(struct coolrain_eval_context const *cntx)
{
	struct coolrain_eval_context new_cntx = *cntx;
	new_cntx.fragment = new_cntx.fragment->data.tag.content;
	return coolrain_template_eval_block(&new_cntx);
}


int coolrain_template_run(
	struct coolrain_template *tmpl,
	struct coolrain_stash *stash,
	struct coolrain_writer *writer);

G_END_DECLS;

#endif

