/*
 * The MIT License

   Conograph (powder auto-indexing program)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#ifndef HKL_Q_HH_
#define HKL_Q_HH_

#include "../RietveldAnalysisTypes.hh"
#include "../utility_data_structure/VecDat3.hh"

class HKL_Q
{
private:
	VecDat3<Int4> hkl;
	Double q;

public:
	HKL_Q(){ hkl = 0; q = 0.0; };
	HKL_Q(const VecDat3<Int4>& arg1, const Double& arg2){ hkl = arg1; q = arg2; };

	inline const VecDat3<Int4>& HKL() const { return hkl; };
	inline VecDat3<Int4>& HKL() { return hkl; };
	inline const Double& Q() const { return q; };
	inline bool operator<(const HKL_Q& rhs) const;
};

inline bool HKL_Q::operator<(const HKL_Q& rhs) const
{
	if( q < rhs.q ) return true;
	else if( q > rhs.q ) return false;
	return abs(hkl[0])+abs(hkl[1])+abs(hkl[2]) < abs(rhs.hkl[0])+abs(rhs.hkl[1])+abs(rhs.hkl[2]);
};

#endif /* HKL_Q_HH_ */
