/*
 * The MIT License

   BLDConograph (Bravais lattice determination module in Conograph)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#ifndef ENUMCRYSTALSYSTEM_HH_
#define ENUMCRYSTALSYSTEM_HH_

#include "enumAxis.hh"
#include "../bravais_lattice/enumBravaisLattice.hh"
#include "../point_group/enumPointGroup.hh"

// Triclinic, Monoclinic, Monoclinic(C),
// Orthorhombic(P), Orthorhombic(C), Orthorhombic(I), Orthorhombic(F),
// Tetragonal(P), Tetragonal(I), Rhombohedral, Hexagonal.
// Cubic(P), Cubic(I), Cubic(F).
enum eCrystalSystem{ CSUndefined = -1, Triclinic = 0, Monoclinic_P = 1, Monoclinic_B = 2,
			Orthorhombic_P = 3, Orthorhombic_C = 4, Orthorhombic_I = 5, Orthorhombic_F = 6,
			Tetragonal_P = 7, Tetragonal_I = 8, Rhombohedral = 9, Hexagonal = 10,
			Cubic_P = 11, Cubic_I = 12, Cubic_F = 13 };

inline const ArrayIndex& put_cs_num()
{
	static const ArrayIndex NUM_LS = 14;
	return NUM_LS;
}


inline string put_cs_name(const eCrystalSystem& i, const eABCaxis& axis)
{
	static const ArrayIndex NUM_LS = 14;
	static const string name[NUM_LS] = { "Triclinic", "Monoclinic(P)", "Monoclinic",
											"Orthorhombic(P)", "Orthorhombic(C)",
											"Orthorhombic(I)", "Orthorhombic(F)",
											"Tetragonal(P)", "Tetragonal(I)",
											"Rhombohedral", "Hexagonal",
											"Cubic(P)", "Cubic(I)", "Cubic(F)" };

	if( i == Monoclinic_B )
	{
		if( axis == A_Axis )return name[(ArrayIndex)i] + "(A)";
		else if( axis == B_Axis )return name[(ArrayIndex)i] + "(B)";
		else // if( axis == C_Axis )
			return name[(ArrayIndex)i] + "(C)";
	}
	else return name[(ArrayIndex)i];
}

#endif /*ENUMCRYSTALSYSTEM_HH_*/
