#include "turing.h"
#include <string.h>

int
turingMachineRun(turingMachine* m, turingTape* tape, FILE* fpt, int mode)
{
	int count = 0;

	turingMachinePrint(m, tape, fpt, count, mode);
	while(1) {
		count++;
		turingMachineOneStep(m, tape);
		turingMachinePrint(m, tape, fpt, count, mode);
		if(0==strncmp(m->status, "halt", 4)) {
			turingMachineHalt(m);	
		}
	}
}

int
turingMachinePrint(turingMachine* m, turingTape* tape, FILE* fpt, int count, int mode)
{
	int i;
	fprintf(fpt, "%03d", count); 
	if(0<=m->currentRule) {
		fprintf(fpt, " <----------> ", count); 
		turingRulePrint0(fpt, m->rule[m->currentRule]);
 	} else {
		fprintf(fpt, "\n");
	}
	fprintf(fpt, "    ", count); turingTapePrint(fpt, *tape); 
	fprintf(fpt, "    "); 
	for(i=0; i<m->currentPosition-1; i++) { 
		fprintf(fpt, " "); 
	} 
	fprintf(fpt, "-  %s\n", m->status); 
}

int
turingMachineOneStep(turingMachine* m, turingTape* tape)
{
	turingMachineInput(m, *tape);

	turingMachineRuleSelect(m, tape);

	turingMachineOutput(*m, tape);
	turingMachineMove(m);
	turingMachineStatusChange(m);
}

int
turingMachineInput(turingMachine* m, turingTape tape )
{
	m->data = tape.tape[m->currentPosition-1];	
}

int
turingMachineRuleSelect(turingMachine* m, turingTape* tape)
{
	int i;

	for(i=0; i<m->maxRule; i++) {
		if(m->rule[i].inputData == m->data) {
			if(0==strncmp(m->rule[i].currentStatus, m->status, MAXSTATUS)) {
				m->currentRule = i;
				break;
			}
		}	
	}		
	if(m->maxRule<=i) {
		fprintf(stderr, "No Rule: %s %c\n", m->status, m->data);
		exit(EXIT_FAILURE);
	}
}

int
turingMachineOutput(turingMachine m, turingTape* tape)
{
	if(tape->lastPosition < m.currentPosition) {
		tape->lastPosition = m.currentPosition;
	}
	if(MAXTAPE < tape->lastPosition) {
		fprintf(stderr, "Tape was not infinite\n");
		exit(EXIT_FAILURE);
	}

	tape->tape[m.currentPosition-1] = m.rule[m.currentRule].outputData;
}

int
turingMachineMove(turingMachine* m)
{
	switch(m->rule[m->currentRule].movement) {
		case 'R': {
			m->currentPosition++;	
			break;
		}	
		case 'L': {
			m->currentPosition--;	
			if(m->currentPosition<=0) {
				fprintf(stderr, "too short tape at the left side. Please prepare blank tape\n");
			};
			break;
		}	
		case 'H': {
			break;
		}	
		default: {
			fprintf(stderr, "Not supported movement %c\n", m->rule[m->currentRule].movement);
			break;
		}
	}

}

int
turingMachineStatusChange(turingMachine* m)
{
	strncpy(m->status, m->rule[m->currentRule].nextStatus, MAXSTATUS);
}


int
turingMachineHalt(turingMachine* m)
{
	exit(EXIT_FAILURE);
} 
