#include "StdAfx.h"
#include "resource.h"
#include "FileEditDlg.h"
#include "WTLCtrlUtil.h"
#include "JobGeneralPropertyPage.h"
#include "FileEditDlg.h"
#include "BITSDef.h"
#include "BITSUtil.h"
#include "MiscUtil.h"


CJobGeneralPropertyPage::CJobGeneralPropertyPage(void):
	m_jobEditMode(INVALID_JOB_EDIT_MODE),
	m_bModified(false)
{
	NULL;
}


LRESULT CJobGeneralPropertyPage::OnInitDialog(__in CWindow /* wndFocus */, __in LPARAM /* lInitParam */)
{
	// ȂCJobPropertySheetOnInitDialogĂ΂Ȃ̂ŁÃy[W̏ŃEBhE
	// Ɉړ
	CWindow propertySheet = GetParent();
	if (0 != propertySheet.IsWindow()) {
		ATLVERIFY(propertySheet.CenterWindow(propertySheet.GetParent()));
	} else {
		ATLASSERT(false);
	}

	AssertValidState();

	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(InitPropertyPageControls());
	ATLVERIFY(CenterWindow(GetParent()));

	if (EDIT_JOB_MODE == m_jobEditMode) {
		ATLVERIFY(LoadJobProperty());
	}
	ATLVERIFY(UpdatePropertyPageControls());

	return TRUE;
}


LRESULT CJobGeneralPropertyPage::OnDestroy(void)
{
	ATLVERIFY(DeleteAllListItems());

	return 0;
}


int CJobGeneralPropertyPage::OnApply(void)
{
	ATLVERIFY(DoDataExchange(TRUE));

	if (CREATE_JOB_MODE == m_jobEditMode) {
		bool bResult = CreateJob();
		ATLVERIFY(bResult);
		return 1;
	} else if (EDIT_JOB_MODE == m_jobEditMode) {
		EditJob();
		return 1;
	} else {
		ATLASSERT(false);
	}

	return 0;
}


LRESULT CJobGeneralPropertyPage::OnAddFileButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/,
													 __in CWindow /*wndCtl*/)
{
	DoDataExchange(TRUE);

	BG_JOB_TYPE jobType = GetJobTypeFromComboBox();
	CFileEditDlg dlg(jobType, IsBITS20Supported());

	INT_PTR nAnswer = dlg.DoModal(m_hWnd);
	if (IDOK == nAnswer) {
		CString strLocalFileName	= dlg.GetLocalFileName();
		CString strRemoteFileName	= dlg.GetRemoteFileName();
		int nItemIndex = m_listCtrlJobFileList.GetItemCount();
		ATLVERIFY(-1 != m_listCtrlJobFileList.InsertItem(nItemIndex, strLocalFileName));
		ATLVERIFY(m_listCtrlJobFileList.SetItemText(nItemIndex, REMOTE_FILE_COLUMN_INDEX, strRemoteFileName));

		PJOB_COPY_FILE_INFO pCopyFileInfo = new JOB_COPY_FILE_INFO;
		pCopyFileInfo->attribute = NEW_JOB_COPY_FILE;
		pCopyFileInfo->m_FileRangeArray.Append(dlg.m_FileRangeArray);

		ATLVERIFY(SetJobCopyFileAttribute(nItemIndex, pCopyFileInfo));
		pCopyFileInfo = NULL;

		ATLVERIFY(UpdatePropertyPageControls());

		if (EDIT_JOB_MODE == GetJobEditMode()) {
			SetModified(TRUE);
			m_bModified = true;
		}
	}

	return 0;
}


LRESULT CJobGeneralPropertyPage::OnRemoveFileButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/,
														__in CWindow /*wndCtl*/)
{
	int nSelectedIndex = m_listCtrlJobFileList.GetSelectedIndex();
	if (-1 == nSelectedIndex) {
		ATLASSERT(false);
		return 1;
	}

	if (false == IsJobCopyFileNew(nSelectedIndex)) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_ERR_CANNOT_REMOVE_EXISTING_COPY_FILE, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		m_listCtrlJobFileList.SetFocus();
		return 1;
	}

	ATLVERIFY(DeleteListItem(nSelectedIndex));
	ATLVERIFY(UpdatePropertyPageControls());

	if (EDIT_JOB_MODE == GetJobEditMode()) {
		SetModified(TRUE);
		m_bModified = true;
	}
	return 0;
}


LRESULT CJobGeneralPropertyPage::OnEnChangeJobName(__in UINT /*uNotifyCode*/, __in int /*nID*/,
												   __in CWindow /*wndCtl*/)
{
	if (EDIT_JOB_MODE == GetJobEditMode()) {
		SetModified(TRUE);
		m_bModified = true;
	}

	return 0;
}


LRESULT CJobGeneralPropertyPage::OnSelChangeJobPriority(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	if (EDIT_JOB_MODE == GetJobEditMode()) {
		SetModified(TRUE);
		m_bModified = true;
	}

	return 0;
}


LRESULT CJobGeneralPropertyPage::OnEnChangeJobDescription(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	if (EDIT_JOB_MODE == GetJobEditMode()) {
		SetModified(TRUE);
		m_bModified = true;
	}

	return 0;
}


LRESULT CJobGeneralPropertyPage::OnJobFileListItemChanged(LPNMHDR /*pnmh*/)
{
	ATLVERIFY(UpdatePropertyPageControls());
	return 0;
}


bool CJobGeneralPropertyPage::InitPropertyPageControls(void)
{
	if (false == InitJobTypeComboBox()) {
		ATLASSERT(false);
		return false;
	}

	if (false == InitJobPriorityComboBox()) {
		ATLASSERT(false);
		return false;
	}

	if (false == InitJobFileListCtrl()) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(UpdatePropertyPageControls());

	return true;
}


bool CJobGeneralPropertyPage::InitJobTypeComboBox(void)
{
	int nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboJobType, IDS_JOB_TYPE_DOWNLOAD,
		static_cast<DWORD_PTR>(BG_JOB_TYPE_DOWNLOAD));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboJobType, IDS_JOB_TYPE_UPLOAD,
		static_cast<DWORD_PTR>(BG_JOB_TYPE_UPLOAD));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboJobType, IDS_JOB_TYPE_UPLOAD_REPLY,
		static_cast<DWORD_PTR>(BG_JOB_TYPE_UPLOAD_REPLY));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(CB_ERR != m_comboJobType.SetCurSel(0));

	return true;
}


bool CJobGeneralPropertyPage::InitJobPriorityComboBox(void)
{
	int nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboJobPriority, IDS_JOB_PRIORITY_FOREGROUND,
		static_cast<DWORD_PTR>(BG_JOB_PRIORITY_FOREGROUND));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboJobPriority, IDS_JOB_PRIORITY_HIGH,
		static_cast<DWORD_PTR>(BG_JOB_PRIORITY_HIGH));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	int nNormalPriorityItemIndex = WTLCtrlUtil::AddStringAndSetData(m_comboJobPriority, IDS_JOB_PRIORITY_NORMAL,
		static_cast<DWORD_PTR>(BG_JOB_PRIORITY_NORMAL));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboJobPriority, IDS_JOB_PRIORITY_LOW,
		static_cast<DWORD_PTR>(BG_JOB_PRIORITY_LOW));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(CB_ERR != m_comboJobPriority.SetCurSel(nNormalPriorityItemIndex));

	return true;
}


bool CJobGeneralPropertyPage::InitJobFileListCtrl(void)
{
	CString strColumnName;
	if (0 == strColumnName.LoadString(IDS_COLUMN_LOCAL_FILE_NAME)) {
		ATLASSERT(false);
		return false;
	}
	int nResult = m_listCtrlJobFileList.InsertColumn(LOCAL_FILE_COLUMN_INDEX, strColumnName, LVCFMT_LEFT,
		LOCAL_FILE_COLUMN_WIDTH);
	if (-1 == nResult) {
		ATLASSERT(false);
		return false;
	}

	if (0 == strColumnName.LoadString(IDS_COLUMN_REMOTE_FILE_NAME)) {
		ATLASSERT(false);
		return false;
	}
	nResult = m_listCtrlJobFileList.InsertColumn(REMOTE_FILE_COLUMN_INDEX, strColumnName, LVCFMT_LEFT,
		REMOTE_FILE_COLUMN_WIDTH);
	if (-1 == nResult) {
		ATLASSERT(false);
		return false;
	}

	m_listCtrlJobFileList.SetExtendedListViewStyle(m_listCtrlJobFileList.GetExtendedListViewStyle() |
		LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);

	return true;
}


__checkReturn bool CJobGeneralPropertyPage::CreateJob(void)
{
	CString strMessage;
	if (m_spJob) {
		ATLASSERT(false);

		MiscUtil::ShowMessageBox(m_hWnd, IDS_ERR_JOB_CREATE_FAILED, IDR_MAINFRAME, MB_ICONERROR | MB_OK);

		return false;
	}
	if (!m_spBITSManager) {
		ATLASSERT(false);

		MiscUtil::ShowMessageBox(m_hWnd, IDS_ERR_JOB_CREATE_FAILED, IDR_MAINFRAME, MB_ICONERROR | MB_OK);

		return false;
	}

	if (false == CheckJobProperty()) {
		return false;
	}

	GUID jobID = {0};
	BG_JOB_TYPE jobType = GetJobTypeFromComboBox();
	HRESULT hr = m_spBITSManager->CreateJob(m_strJobDisplayName, jobType, &jobID, &m_spJob);
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		strMessage.Format(IDS_ERR_JOB_CREATE_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return false;
	}
	m_spJob3 = m_spJob;

	if (false == m_strJobDescription.IsEmpty()) {
		hr = m_spJob->SetDescription(m_strJobDescription);
		ATLASSERT(SUCCEEDED(hr));
	}

	BG_JOB_PRIORITY jobPriority = GetJobPriorityFromComboBox();
	hr = m_spJob->SetPriority(jobPriority);
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		strMessage.Format(IDS_ERR_JOB_CREATE_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return false;
	}

	int nFileCount = m_listCtrlJobFileList.GetItemCount();
	if (nFileCount <= 0) {
		return true;
	}

	hr = AddFiles();
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		strMessage.Format(IDS_ERR_JOB_CREATE_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return false;
	}

	int buttonStatus = m_checkJobAutoStart.GetCheck();
	if (BST_CHECKED == buttonStatus) {
		hr = m_spJob->Resume();
		if (FAILED(hr)) {
			CString strErrorDescription;
			ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));
			strMessage.Format(IDS_ERR_JOB_START_FAILED_WITH_CODE, hr, strErrorDescription);
			MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

			return false;
		}
	}

	return true;
}


bool CJobGeneralPropertyPage::EditJob(void)
{
	CString strMessage;
	if (!m_spJob) {
		ATLASSERT(false);

		return false;
	}
	if (!m_spBITSManager) {
		ATLASSERT(false);
		MiscUtil::ShowMessageBox(m_hWnd, IDS_ERR_JOB_EDIT_FAILED, IDR_MAINFRAME, MB_ICONERROR | MB_OK);

		return false;
	}

	if (false == m_bModified) {
		return true;
	}

	if (false == BITSUtil::IsJobEditableState(m_spJob)) {
		return false;
	}

	if (false == CheckJobProperty()) {
		return false;
	}

	HRESULT hr = m_spJob->SetDisplayName(m_strJobDisplayName);
	if (FAILED(hr)) {
		ATLASSERT(false);

		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		strMessage.Format(IDS_ERR_JOB_EDIT_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return false;
	}

	hr = m_spJob->SetDescription(m_strJobDescription);
	if (FAILED(hr)) {
		ATLASSERT(false);
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		strMessage.Format(IDS_ERR_JOB_EDIT_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return false;
	}

	BG_JOB_PRIORITY jobPriority = GetJobPriorityFromComboBox();
	hr = m_spJob->SetPriority(jobPriority);
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		strMessage.Format(IDS_ERR_JOB_EDIT_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return false;
	}

	int nFileCount = m_listCtrlJobFileList.GetItemCount();
	if (nFileCount <= 0) {
		m_bModified = false;
		return true;
	}

	hr = AddFiles();
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		strMessage.Format(IDS_ERR_JOB_EDIT_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return false;
	}

	m_bModified = false;

	return true;
}


__checkReturn HRESULT CJobGeneralPropertyPage::AddFiles(void)
{
	if (!m_spJob) {
		ATLASSERT(false);
		return E_UNEXPECTED;
	}

	int nFileCount = m_listCtrlJobFileList.GetItemCount();
	int nNewCopyFileCount = GetNewCopyFileCount();
	if (nFileCount <= 0 ||  nNewCopyFileCount <= 0) {
		return S_FALSE;
	}

	CAutoVectorPtr<BG_FILE_INFO> spFileSet;
	bool bResult = spFileSet.Allocate(nFileCount);
	if (false == bResult) {
		ATLASSERT(false);
		return E_OUTOFMEMORY;
	}

	HRESULT hr = E_FAIL;
	CAtlArray<int>	   NewCopyFileIndexArray;
	CAtlArray<CString> strLocalFileNameArray;
	CAtlArray<CString> strRemoteFileNameArray;
	strLocalFileNameArray.SetCount(nNewCopyFileCount);
	strRemoteFileNameArray.SetCount(nNewCopyFileCount);
	CComQIPtr<IBackgroundCopyJob3> spJob3 = m_spJob;
	for (int nFileIndex = 0, nLocalArrayIndex = 0; nFileIndex < nFileCount; nFileIndex++) {
		if (false == IsJobCopyFileNew(nFileIndex)) {
			continue;
		}
		ATLVERIFY(m_listCtrlJobFileList.GetItemText(nFileIndex, LOCAL_FILE_COLUMN_INDEX, strLocalFileNameArray[nLocalArrayIndex]));
		ATLVERIFY(m_listCtrlJobFileList.GetItemText(nFileIndex, REMOTE_FILE_COLUMN_INDEX, strRemoteFileNameArray[nLocalArrayIndex]));
		NewCopyFileIndexArray.Add(nFileIndex);

		spFileSet[nLocalArrayIndex].LocalName	= strLocalFileNameArray[nLocalArrayIndex].GetBuffer();
		spFileSet[nLocalArrayIndex].RemoteName	= strRemoteFileNameArray[nLocalArrayIndex].GetBuffer();

		nLocalArrayIndex++;

		if (true == IsBITS20Supported()) {
			hr = AddFilesWithRange(nFileIndex);
			if (FAILED(hr)) {
				ATLASSERT(false);
				return hr;
			}
		}
	}

	if (false == IsBITS20Supported()) {
		hr = m_spJob->AddFileSet(nNewCopyFileCount, spFileSet);
		if (FAILED(hr)) {
			ATLASSERT(false);
			return hr;
		}
	}

	for (size_t nIndex = 0; nIndex < NewCopyFileIndexArray.GetCount(); nIndex++) {
		PJOB_COPY_FILE_INFO pCopyFileInfo = reinterpret_cast<PJOB_COPY_FILE_INFO>(m_listCtrlJobFileList.GetItemData(static_cast<int>(nIndex)));
		if (NULL == pCopyFileInfo) {
			ATLASSERT(false);
			continue;
		}
		pCopyFileInfo->attribute = EXISTING_JOB_COPY_FILE;
		pCopyFileInfo = NULL;
	}

	return hr;
}


__checkReturn HRESULT CJobGeneralPropertyPage::AddFilesWithRange(__in int nItemIndex)
{
	CComQIPtr<IBackgroundCopyJob3> spJob3 = m_spJob;
	if (!spJob3) {
		ATLASSERT(false);
		return E_NOTIMPL;
	}

	CString strLocalFileName;
	CString strRemoteFileName;

	ATLVERIFY(m_listCtrlJobFileList.GetItemText(nItemIndex, LOCAL_FILE_COLUMN_INDEX, strLocalFileName));
	ATLVERIFY(m_listCtrlJobFileList.GetItemText(nItemIndex, REMOTE_FILE_COLUMN_INDEX, strRemoteFileName));

	PJOB_COPY_FILE_INFO pCopyFileInfo = reinterpret_cast<PJOB_COPY_FILE_INFO>(m_listCtrlJobFileList.GetItemData(nItemIndex));
	if (NULL == pCopyFileInfo) {
		ATLASSERT(false);
		return E_UNEXPECTED;
	}

	HRESULT hr = E_FAIL;
	size_t nRangeCount = pCopyFileInfo->m_FileRangeArray.GetCount();
	if (0 == nRangeCount) {
		hr = BITSUtil::AddJobFile(m_spJob, strRemoteFileName, strLocalFileName);
	} else {
		BG_FILE_RANGE* pFileRangeArray = new BG_FILE_RANGE[nRangeCount];
		for (size_t nIndex = 0; nIndex < nRangeCount; nIndex++) {
			pFileRangeArray[nIndex] = pCopyFileInfo->m_FileRangeArray[nIndex];
		}

		hr = BITSUtil::AddJobFileWithRanges(spJob3, strRemoteFileName, strLocalFileName, static_cast<int>(nRangeCount),
			pFileRangeArray);
		delete[] pFileRangeArray;
		pFileRangeArray = NULL;
	}

	ATLASSERT(SUCCEEDED(hr));

	return hr;
}


bool CJobGeneralPropertyPage::UpdatePropertyPageControls(void)
{
	if (EDIT_JOB_MODE == m_jobEditMode) {
		m_comboJobType.EnableWindow(FALSE);
	}
	ATLVERIFY(UpdateRemoveFileButton());
	ATLVERIFY(UpdateJobAutoStartCheckbox());

	return true;
}


bool CJobGeneralPropertyPage::UpdateRemoveFileButton(void)
{
	int nSelectedIndex = m_listCtrlJobFileList.GetSelectedIndex();
	if (-1 == nSelectedIndex) {
		m_buttonRemoveFile.EnableWindow(FALSE);
		return true;
	}
	m_buttonRemoveFile.EnableWindow(TRUE);

	return true;
}


bool CJobGeneralPropertyPage::DeleteListItem(int nItemIndex)
{
	if (-1 == nItemIndex) {
		ATLASSERT(false);
		return false;
	}

	PJOB_COPY_FILE_INFO pJobFileInfo = reinterpret_cast<PJOB_COPY_FILE_INFO>(m_listCtrlJobFileList.GetItemData(nItemIndex));
	ATLASSERT(pJobFileInfo);
	delete pJobFileInfo;
	pJobFileInfo = NULL;

	BOOL bResult = m_listCtrlJobFileList.DeleteItem(nItemIndex);

	return FALSE == bResult? false: true;
}


bool CJobGeneralPropertyPage::DeleteAllListItems(void)
{
	for (int nIndex = m_listCtrlJobFileList.GetItemCount() - 1; 0 <= nIndex; nIndex--) {
		ATLVERIFY(DeleteListItem(nIndex));
	}

	m_listCtrlJobFileList.DeleteAllItems();

	return true;
}


bool CJobGeneralPropertyPage::UpdateJobAutoStartCheckbox(void)
{
	if (EDIT_JOB_MODE == m_jobEditMode) {
		m_checkJobAutoStart.EnableWindow(FALSE);
		return true;
	}

	int nFileCount = m_listCtrlJobFileList.GetItemCount();
	if (nFileCount <= 0) {
		m_checkJobAutoStart.EnableWindow(FALSE);
	} else {
		m_checkJobAutoStart.EnableWindow(TRUE);
	}

	return true;
}


bool CJobGeneralPropertyPage::LoadJobProperty(void)
{
	if (!m_spJob) {
		ATLASSERT(false);
		return false;
	}

	CString strDisplayName;
	HRESULT hr = BITSUtil::GetJobDisplayName(m_spJob, &strDisplayName);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editJobDisplayName, strDisplayName));

	BG_JOB_TYPE jobType = BG_JOB_TYPE_DOWNLOAD;
	hr = BITSUtil::GetJobType(m_spJob, &jobType);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}
	ATLVERIFY(SetJobTypeToComboBox(jobType));

	BG_JOB_PRIORITY jobPriority = BG_JOB_PRIORITY_NORMAL;
	hr = BITSUtil::GetJobPriority(m_spJob, &jobPriority);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}
	ATLVERIFY(SetJobPriorityToComboBox(jobPriority));

	CString strDescription;
	hr = BITSUtil::GetJobDescription(m_spJob, &strDescription);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editJobDescription, strDescription));

	CComPtr<IEnumBackgroundCopyFiles> spEnumFiles;
	hr = m_spJob->EnumFiles(&spEnumFiles);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}
	ATLVERIFY(LoadJobFiles(spEnumFiles));

	return true;
}


bool CJobGeneralPropertyPage::LoadJobFiles(__in const CComPtr<IEnumBackgroundCopyFiles>& spEnumFiles)
{
	ULONG uFileCount = 0;
	HRESULT hr = spEnumFiles->GetCount(&uFileCount);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(m_listCtrlJobFileList.DeleteAllItems());

	CString strFilename;
	for (UINT uIndex = 0; uIndex < uFileCount; uIndex++) {
		CComPtr<IBackgroundCopyFile> spFile;
		hr = spEnumFiles->Next(1, &spFile, NULL);
		if (S_OK == hr) {
			strFilename.Empty();
			hr = BITSUtil::GetJobLocalFileName(spFile, &strFilename);
			ATLVERIFY(SUCCEEDED(hr));
			ATLVERIFY(-1 != m_listCtrlJobFileList.InsertItem(static_cast<int>(uIndex), strFilename));

			PJOB_COPY_FILE_INFO pCopyFileInfo = new JOB_COPY_FILE_INFO;
			pCopyFileInfo->attribute = EXISTING_JOB_COPY_FILE;
			ATLVERIFY(SetJobCopyFileAttribute(static_cast<int>(uIndex), pCopyFileInfo));
			pCopyFileInfo = NULL;

			strFilename.Empty();
			hr = BITSUtil::GetJobRemotelFileName(spFile, &strFilename);
			ATLVERIFY(SUCCEEDED(hr));
			ATLVERIFY(m_listCtrlJobFileList.SetItemText(static_cast<int>(uIndex), REMOTE_FILE_COLUMN_INDEX, strFilename));
		} else if (S_FALSE == hr) {
			break;
		} else {
			ATLASSERT(false);
		}
	}

	return true;
}


__checkReturn BG_JOB_TYPE CJobGeneralPropertyPage::GetJobTypeFromComboBox(void)
{
	int nSelected = m_comboJobType.GetCurSel();
	if (CB_ERR == nSelected) {
		ATLASSERT(false);

		return static_cast<BG_JOB_TYPE>(-1);
	}

	DWORD_PTR dwItemData = m_comboJobType.GetItemData(nSelected);
	if (CB_ERR == dwItemData) {
		ATLASSERT(false);

		return static_cast<BG_JOB_TYPE>(-1);
	}
	BG_JOB_TYPE jobType = static_cast<BG_JOB_TYPE>(dwItemData);

	ATLASSERT(BITSUtil::VerifyJobType(jobType));

	return jobType;
}


__checkReturn BG_JOB_PRIORITY CJobGeneralPropertyPage::GetJobPriorityFromComboBox(void)
{
	int nCurSel = m_comboJobPriority.GetCurSel();
	if (CB_ERR == nCurSel) {
		ATLASSERT(false);
		return static_cast<BG_JOB_PRIORITY>(-1);
	}

	DWORD_PTR dwData = m_comboJobPriority.GetItemData(nCurSel);
	if (CB_ERR == dwData) {
		ATLASSERT(false);
		return static_cast<BG_JOB_PRIORITY>(-1);
	}

	BG_JOB_PRIORITY jobPriority = static_cast<BG_JOB_PRIORITY>(dwData);

	ATLASSERT(BITSUtil::VerifyJobPriority(jobPriority));

	return jobPriority;
}


bool CJobGeneralPropertyPage::SetJobTypeToComboBox(BG_JOB_TYPE jobType)
{
	ATLASSERT(BITSUtil::VerifyJobType(jobType));

	int nItemCount = m_comboJobType.GetCount();
	for (int nIndex = 0; nIndex < nItemCount; nIndex++) {
		if (jobType == static_cast<BG_JOB_TYPE>(m_comboJobType.GetItemData(nIndex))) {
			m_comboJobType.SetCurSel(nIndex);
			return true;
		}
	}

	ATLASSERT(false);
	return false;
}


bool CJobGeneralPropertyPage::SetJobPriorityToComboBox(BG_JOB_PRIORITY jobPriority)
{
	ATLASSERT(BITSUtil::VerifyJobPriority(jobPriority));

	int nItemCount = m_comboJobPriority.GetCount();
	for (int nIndex = 0; nIndex < nItemCount; nIndex++) {
		if (jobPriority == static_cast<BG_JOB_PRIORITY>(m_comboJobPriority.GetItemData(nIndex))) {
			m_comboJobPriority.SetCurSel(nIndex);
			return true;
		}
	}

	ATLASSERT(false);
	return false;
}


void CJobGeneralPropertyPage::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);

	if (m_spJob) {
		ATLASSERT(false);
		m_spJob.Release();
	}
	m_spJob = spJob;

	if (m_spJob3) {
		ATLASSERT(false);
		m_spJob3.Release();
	}
	m_spJob3 = spJob;

	return;
}


void CJobGeneralPropertyPage::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager> spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}


__checkReturn int CJobGeneralPropertyPage::GetNewCopyFileCount(void)
{
	int nFileCount = m_listCtrlJobFileList.GetItemCount();
	if (nFileCount <= 0) {
		return 0;
	}

	int nNewCopyFileCount = 0;
	for (int nFileIndex = 0; nFileIndex < nFileCount; nFileIndex++) {
		if (true == IsJobCopyFileNew(nFileIndex)) {
			nNewCopyFileCount++;
		}
	}

	return nNewCopyFileCount;
}


bool CJobGeneralPropertyPage::SetJobCopyFileAttribute(__in int nFileListIndex, __in PJOB_COPY_FILE_INFO pjobCopyfileInfo)
{
	ATLASSERT(pjobCopyfileInfo);

	BOOL bResult = m_listCtrlJobFileList.SetItemData(nFileListIndex, reinterpret_cast<DWORD_PTR>(pjobCopyfileInfo));
	ATLASSERT(bResult);
	return bResult ?true: false;
}


__checkReturn bool CJobGeneralPropertyPage::IsJobCopyFileNew(__in int nFileListIndex)
{
	DWORD_PTR dwData = m_listCtrlJobFileList.GetItemData(nFileListIndex);
	PJOB_COPY_FILE_INFO pCopyFileInfo = reinterpret_cast<PJOB_COPY_FILE_INFO>(dwData);
	if (NULL == pCopyFileInfo) {
		ATLASSERT(false);
		return false;
	}

	if (NEW_JOB_COPY_FILE == pCopyFileInfo->attribute) {
		return true;
	}

	return false;
}


__checkReturn bool CJobGeneralPropertyPage::IsBITS20Supported(void)
{
	if (!m_spJob3) {
		return false;
	}

	return true;
}


void CJobGeneralPropertyPage::AssertValidState(void)
{
#ifndef _DEBUG
	return;
#endif

	JOB_EDIT_MODE editMode = GetJobEditMode();
	if (CREATE_JOB_MODE == editMode) {
		ATLASSERT(m_spBITSManager);
	} else if (EDIT_JOB_MODE == editMode) {
		ATLASSERT(m_spJob);
	} else {
		ATLASSERT(false);
	}
}


__checkReturn bool CJobGeneralPropertyPage::CheckJobProperty(void)
{
	if (false == CheckJobDisplayName()) {
		return false;
	}

	if (false == CheckJobType()) {
		return false;
	}

	if (false == CheckJobPriority()) {
		return false;
	}

	if (false == CheckJobDescription()) {
		return false;
	}

	return true;
}


__checkReturn bool CJobGeneralPropertyPage::CheckJobDisplayName(void)
{
	CString strMessage;
	if (false == BITSUtil::VerifyJobDisplayName(m_strJobDisplayName)) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_JOB_DISPLAY_NAME_TOO_LONG, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		m_editJobDisplayName.SetFocus();
		return false;
	}

	return true;
}


__checkReturn bool CJobGeneralPropertyPage::CheckJobType(void)
{
	BG_JOB_TYPE jobType = GetJobTypeFromComboBox();
	if (false == BITSUtil::VerifyJobType(jobType)) {
		ATLASSERT(false);
		return false;
	}

	return true;
}


__checkReturn bool CJobGeneralPropertyPage::CheckJobPriority(void)
{
	int nCurSel = m_comboJobPriority.GetCurSel();
	if (CB_ERR == nCurSel) {
		ATLASSERT(false);
		return false;
	}

	DWORD_PTR dwData = m_comboJobPriority.GetItemData(nCurSel);
	if (CB_ERR == dwData) {
		ATLASSERT(false);
		return false;
	}

	BG_JOB_PRIORITY jobPriority = static_cast<BG_JOB_PRIORITY>(dwData);
	if (false == BITSUtil::VerifyJobPriority(jobPriority)) {
		ATLASSERT(false);
		return false;
	}

	return true;
}


__checkReturn bool CJobGeneralPropertyPage::CheckJobDescription(void)
{
	CString strMessage;
	if (false == BITSUtil::VerifyJobDescription(m_strJobDescription)) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_JOB_DESCRIPTION_TOO_LONG, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		m_editJobDescription.SetFocus();
		return false;
	}

	return true;
}

