#pragma once

namespace BITSUtil
{
	static const ULONG MINIMUM_RETRY_DELAY = 60;
	static const ULONG DEFAULT_RETRY_DELAY = 600;

	__checkReturn bool VerifyJobDisplayName(__in LPCWSTR lpszJobDisplayName);
	__checkReturn bool VerifyJobType(__in BG_JOB_TYPE jobType);
	__checkReturn bool VerifyJobPriority(__in BG_JOB_PRIORITY jobPriority);
	__checkReturn bool VerifyJobDescription(__in LPCWSTR lpszJobDescription);
	__checkReturn bool VerifyRemoteFileName(__in LPCWSTR lpszFileName);
	__checkReturn bool VerifyLocalFileName(__in LPCWSTR lpszFileName);
	__checkReturn bool VerifyJobProxyUsage(__in BG_JOB_PROXY_USAGE jobProxyUsage);
	__checkReturn bool VerifyAuthTarget(__in BG_AUTH_TARGET authTarget);
	__checkReturn bool VerifyAuthScheme(__in BG_AUTH_SCHEME authScheme);
	__checkReturn bool VerifyHttpRedirectPolicy(__in DWORD dwPolicy);
	__checkReturn bool VerifyCertStoreLocation(__in BG_CERT_STORE_LOCATION certStoreLocation);
	__checkReturn bool VerifyJobHelperTokenFlags(__in DWORD dwFlags);
	__checkReturn bool IsValidFileCharacter(__in LPCWSTR lpszFileName);
	__checkReturn bool IsWritableDrive(__in LPCWSTR lpszFileName);
	__checkReturn HRESULT AddJobFile(__in const CComPtr<IBackgroundCopyJob>& spJob,__in LPCWSTR lpszRemoteUrl, __in LPCWSTR lpszLocalName);
	__checkReturn HRESULT AddJobFileSet(__in const CComPtr<IBackgroundCopyJob>& spJob, __in ULONG cFileCount, __in BG_FILE_INFO* paFileSet);
	__checkReturn HRESULT AddJobFileWithRanges(__in const CComPtr<IBackgroundCopyJob3>& spJob3, __in LPCWSTR lpszRemoteUrl,
		__in LPCWSTR lpszLocalName, __in DWORD dwRangeCount, __in BG_FILE_RANGE Range[]);
	__checkReturn HRESULT GetJobDisplayName(__in const CComPtr<IBackgroundCopyJob>& spJob, __out CString* pstrJobDisplayName);
	__checkReturn HRESULT GetJobDescription(__in const CComPtr<IBackgroundCopyJob>& spJob, __out CString* pstrJobDescription);
	__checkReturn HRESULT GetJobId(__in const CComPtr<IBackgroundCopyJob>& spJob, __out GUID* pguid);
	__checkReturn HRESULT GetJobId(__in const CComPtr<IBackgroundCopyJob>& spJob, __out CString* pstrJobId);
	__checkReturn HRESULT GetJobType(__in const CComPtr<IBackgroundCopyJob>& spJob, __out BG_JOB_TYPE* pJobType);
	__checkReturn HRESULT GetJobOwner(__in const CComPtr<IBackgroundCopyJob>& spJob, __out CString* pstrJobOwner);
	__checkReturn HRESULT GetJobOwner(__in const CComPtr<IBackgroundCopyJob>& spJob, __out CSid* pJobOwnerSid);
	__checkReturn HRESULT GetJobPriority(__in const CComPtr<IBackgroundCopyJob>& spJob, __out BG_JOB_PRIORITY* pJobPriority);
	__checkReturn HRESULT GetJobState(__in const CComPtr<IBackgroundCopyJob>& spJob, __out BG_JOB_STATE* pJobState);
	__checkReturn HRESULT GetJobTimes(__in const CComPtr<IBackgroundCopyJob>& spJob, __out BG_JOB_TIMES* pJobTimes);
	__checkReturn HRESULT GetJobProgress(__in const CComPtr<IBackgroundCopyJob>& spJob, __out BG_JOB_PROGRESS* pJobProgress);
	__checkReturn HRESULT GetJobErrorCount(__in const CComPtr<IBackgroundCopyJob>& spJob, __out ULONG* puErrorCount);
	__checkReturn HRESULT GetJobMinimumRetryDelay(__in const CComPtr<IBackgroundCopyJob>& spJob, __out ULONG* puRetryDelay);
	__checkReturn HRESULT GetJobNoProgressTimeout(__in const CComPtr<IBackgroundCopyJob>& spJob, __out ULONG* puRetryPeriod);
	__checkReturn HRESULT GetJobNotifyInterface(__in const CComPtr<IBackgroundCopyJob>& spJob, __out CComPtr<IUnknown>* pspNotifyInterface);
	__checkReturn HRESULT GetJobNotifyFlags(__in const CComPtr<IBackgroundCopyJob>& spJob, __out ULONG* pNotifyFlags);
	__checkReturn HRESULT SetJobMinimumRetryDelay(__in const CComPtr<IBackgroundCopyJob>& spJob, __out ULONG uRetryDelay);
	__checkReturn HRESULT SetJobNoProgressTimeout(__in const CComPtr<IBackgroundCopyJob>& spJob, __out ULONG uRetryPeriod);
	__checkReturn HRESULT TakeJobOwnership(__in const CComPtr<IBackgroundCopyJob>& spJob);
	__checkReturn HRESULT IsJobOwner(__in const CComPtr<IBackgroundCopyJob>& spJob, __out bool* bOwner);
	__checkReturn HRESULT GetJobProxySettings(__in const CComPtr<IBackgroundCopyJob>& spJob, __out BG_JOB_PROXY_USAGE* pProxyUsage,
		__out CString* pstrProxyList, __out CString* pstrProxyBypassList);
	__checkReturn HRESULT SetJobProxySettings(__in const CComPtr<IBackgroundCopyJob>& spJob, __in BG_JOB_PROXY_USAGE proxyUsage,
		__in LPCWSTR lpszProxyList, __in LPCWSTR lpszProxyBypassList);
	HRESULT GetBITSErrorDescription(__in const CComPtr<IBackgroundCopyManager>& spBITSManager, 
		__in HRESULT hResult, __out CString* pstrErrorDescription);
	__checkReturn bool IsJobEditableState(__in const CComPtr<IBackgroundCopyJob>& spJob);
	__checkReturn HRESULT GetJobLocalFileName(__in const CComPtr<IBackgroundCopyFile>& spFile, __out CString* pstrLocalFilename);
	__checkReturn HRESULT GetJobRemotelFileName(__in const CComPtr<IBackgroundCopyFile>& spFile, __out CString* pstrRemoteFilename);
	__checkReturn HRESULT GetJobErrorIF(__in const CComPtr<IBackgroundCopyJob>& spJob, __out CComPtr<IBackgroundCopyError>* pspError);
	__checkReturn HRESULT GetJobError(__in const CComPtr<IBackgroundCopyError>& spError, __out BG_ERROR_CONTEXT* pErrorContext,
		__out HRESULT* phrError);
	__checkReturn HRESULT GetJobErrorContextDescription(__in const CComPtr<IBackgroundCopyError>& spError,
		__out CString* pstrErrorContextDescription);
	__checkReturn HRESULT GetJobErrorDescription(__in const CComPtr<IBackgroundCopyError>& spError,
		__out CString* pstrErrorDescription);
	__checkReturn HRESULT GetJobErrorProtocol(__in const CComPtr<IBackgroundCopyError>& spError,
		__out CString* pstrErrorProtocol);
	__checkReturn HRESULT GetJobErrorFile(__in const CComPtr<IBackgroundCopyError>& spError, __out CComPtr<IBackgroundCopyFile>* pspFile);
	__checkReturn bool IsBITS15Supported(__in const CComPtr<IBackgroundCopyJob>& spJob);
	__checkReturn bool IsBITS20Supported(__in const CComPtr<IBackgroundCopyJob>& spJob);
	__checkReturn bool IsBITS25Supported(__in const CComPtr<IBackgroundCopyJob>& spJob);
	__checkReturn bool IsBITS40Supported(__in const CComPtr<IBackgroundCopyJob>& spJob);
	__checkReturn HRESULT SetJobCredentials(__in const CComPtr<IBackgroundCopyJob2>& spJob2, __in BG_AUTH_CREDENTIALS* pCredentials);
	__checkReturn HRESULT RemoveJobCredentials(__in const CComPtr<IBackgroundCopyJob2>& spJob2, __in BG_AUTH_TARGET authTarget, 
		__in BG_AUTH_SCHEME authScheme);
	__checkReturn HRESULT GetJobReplyFileName(__in const CComPtr<IBackgroundCopyJob2>& spJob2, __out CString* pstrReplyFileName);
	__checkReturn HRESULT SetJobReplyFileName(__in const CComPtr<IBackgroundCopyJob2>& spJob2, __in LPCWSTR lpszReplyFileName);
	__checkReturn HRESULT GetJobReplyProgress(__in const CComPtr<IBackgroundCopyJob2>& spJob2, __out BG_JOB_REPLY_PROGRESS* pReplyProgress);
	__checkReturn HRESULT GetJobNotifyCmdLine(__in const CComPtr<IBackgroundCopyJob2>& spJob2, __out CString* pstrNotifyCommandPath,
		__out CString* pstrNotifyCommandArg);
	__checkReturn HRESULT SetJobNotifyCmdLine(__in const CComPtr<IBackgroundCopyJob2>& spJob2, __in LPCWSTR lpszNotifyCommandPath,
		__in LPCWSTR lpszNotifyCommandArg);
	__checkReturn HRESULT GetJobFileACLFlags(__in const CComPtr<IBackgroundCopyJob3>& spJob3, __out DWORD* pdwACLFlags);
	__checkReturn HRESULT SetJobFileACLFlags(__in const CComPtr<IBackgroundCopyJob3>& spJob3, __in DWORD dwACLFlags);
	__checkReturn HRESULT GetJobHttpOptions(__in const CComPtr<IBackgroundCopyJobHttpOptions>& spHttpOptions, __out DWORD* pdwFlags);
	__checkReturn HRESULT SetJobHttpOptions(__in const CComPtr<IBackgroundCopyJobHttpOptions>& spHttpOptions, __in DWORD dwFlags);
	__checkReturn HRESULT GetJobPeerCachingFlags(__in const CComPtr<IBackgroundCopyJob4>& spJob4, __out DWORD* pdwFlags);
	__checkReturn HRESULT SetJobPeerCachingFlags(__in const CComPtr<IBackgroundCopyJob4>& spJob4, __in DWORD dwFlags);
	__checkReturn HRESULT GetJobOwnerIntegrityLevel(__in const CComPtr<IBackgroundCopyJob4>& spJob4, __out ULONG* puLevel);
	__checkReturn HRESULT GetJobOwnerElevationState(__in const CComPtr<IBackgroundCopyJob4>& spJob4, __out BOOL* pbElevated);
	__checkReturn HRESULT GetJobMaximumDownloadTime(__in const CComPtr<IBackgroundCopyJob4>& spJob4, __out ULONG* puTimeout);
	__checkReturn HRESULT SetJobMaximumDownloadTime(__in const CComPtr<IBackgroundCopyJob4>& spJob4, __in ULONG uTimeout);
	__checkReturn HRESULT GetJobCustomHeaders(__in const CComPtr<IBackgroundCopyJobHttpOptions>& spHttpOptions, __out CString* pstrCustomHeader);
	__checkReturn HRESULT SetJobCustomHeaders(__in const CComPtr<IBackgroundCopyJobHttpOptions>& spHttpOptions, __in LPCWSTR lpszCustomHeader);
	__checkReturn HRESULT SetJobClientCertificateByName(__in const CComPtr<IBackgroundCopyJobHttpOptions>& spHttpOptions,
		__in BG_CERT_STORE_LOCATION certStoreLocation, __in LPCWSTR lpszStoreName, __in LPCWSTR lpszSubjectName);
	__checkReturn HRESULT SetJobClientCertificateById(__in const CComPtr<IBackgroundCopyJobHttpOptions>& spHttpOptions,
		__in BG_CERT_STORE_LOCATION certStoreLocation, __in LPCWSTR lpszStoreName, __in byte* pCertHashBlob);
	__checkReturn HRESULT RemoveJobClientCertificate(__in const CComPtr<IBackgroundCopyJobHttpOptions>& spHttpOptions);
	__checkReturn HRESULT GetJobFileRange(__in const CComPtr<IBackgroundCopyFile2>& spFile2, __out DWORD* pdwRangeCount, __out BG_FILE_RANGE** ppFileRange);
	__checkReturn HRESULT GetJobFileProgress(__in const CComPtr<IBackgroundCopyFile>& spFile, __out BG_FILE_PROGRESS* pProgress);
	__checkReturn HRESULT GetJobFileTemporaryName(__in const CComPtr<IBackgroundCopyFile3>& spFile3, __out CString* pstrTemporaryName);
	__checkReturn HRESULT IsJobFileDownloadedFromPeer(__in const CComPtr<IBackgroundCopyFile3>& spFile3, __out BOOL* pbIsDownloadedFromPeer);
	__checkReturn HRESULT GetJobFileValidationState(__in const CComPtr<IBackgroundCopyFile3>& spFile3, __out BOOL* pbValidationState);
	__checkReturn HRESULT SetJobFileValidationState(__in const CComPtr<IBackgroundCopyFile3>& spFile3, __in BOOL bValidationState);
	__checkReturn HRESULT GetJobHelperTokenFlags(__in const CComPtr<IBitsTokenOptions>& spTokenOptions, __out DWORD* pdwFlags);
	__checkReturn HRESULT SetJobHelperTokenFlags(__in const CComPtr<IBitsTokenOptions>& spTokenOptions, __in DWORD dwFlags);
	__checkReturn HRESULT GetJobHelperTokenSid(__in const CComPtr<IBitsTokenOptions>& spTokenOptions, __out CString* pstrSid);
	__checkReturn HRESULT SetJobHelperToken(__in const CComPtr<IBitsTokenOptions>& spTokenOptions);
	__checkReturn HRESULT ClearJobHelperToken(__in const CComPtr<IBitsTokenOptions>& spTokenOptions);
	__checkReturn HRESULT GetJobPeerDownloadStats(__in const CComPtr<IBackgroundCopyFile4>& spFile4, __out PUINT64 pFromOrigin, __out PUINT64 pFromPeers);
};
