#pragma once
#include "resource.h"


class CJobMaximumDownloadTimeSettingDlg: public CDialogImpl<CJobMaximumDownloadTimeSettingDlg>,
	public CWinDataExchange<CJobMaximumDownloadTimeSettingDlg>
{
public:
	enum { IDD = IDD_MAXIMUM_DOWNLOAD_TIME_SETTING };

	BEGIN_DDX_MAP(CJobRetryDelaySettingDlg)
		DDX_CONTROL_HANDLE(IDOK,							m_buttonOK)
		DDX_CONTROL_HANDLE(IDC_EDIT_MAXIMUM_DOWNLOAD_TIME,	m_editMaximumDownloadTime)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobRetryDelaySettingDlg)
		MSG_WM_INITDIALOG(OnInitDialog)
		COMMAND_ID_HANDLER_EX(IDOK,		OnOK)
		COMMAND_ID_HANDLER_EX(IDCANCEL,	OnCancel)
		COMMAND_HANDLER_EX(IDC_EDIT_MAXIMUM_DOWNLOAD_TIME, EN_CHANGE, OnEnChangeMaximumDownloadTime)
	END_MSG_MAP()

	CJobMaximumDownloadTimeSettingDlg(void);
	~CJobMaximumDownloadTimeSettingDlg(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob4>& spJob4);

private:
	CButton m_buttonOK;
	CEdit	m_editMaximumDownloadTime;

	CComPtr<IBackgroundCopyManager>	m_spBITSManager;
	CComPtr<IBackgroundCopyJob4>	m_spJob4;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeMaximumDownloadTime(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);

	bool InitDialogControls(void);
};
