#pragma once
#include "resource.h"
#include "JobPropertySheetDef.h"


class CJobGeneralPropertyPage: public CPropertyPageImpl<CJobGeneralPropertyPage>,
							   public CWinDataExchange<CJobGeneralPropertyPage>
{
public:
	enum { IDD = IDD_PROPPAGE_JOB_GENERAL };

	BEGIN_DDX_MAP(CJobGeneralPropertyPage)
		DDX_CONTROL_HANDLE(IDC_EDIT_JOB_DISPLAY_NAME,	m_editJobDisplayName)
		DDX_TEXT          (IDC_EDIT_JOB_DISPLAY_NAME,	m_strJobDisplayName)
		DDX_CONTROL_HANDLE(IDC_COMBO_JOB_TYPE,			m_comboJobType)
		DDX_CONTROL_HANDLE(IDC_COMBO_JOB_PRIORITY,		m_comboJobPriority)
		DDX_CONTROL_HANDLE(IDC_EDIT_JOB_DESCRIPTION,	m_editJobDescription)
		DDX_TEXT          (IDC_EDIT_JOB_DESCRIPTION,	m_strJobDescription)
		DDX_CONTROL_HANDLE(IDC_LIST_JOB_FILE_LIST,		m_listCtrlJobFileList)
		DDX_CONTROL_HANDLE(IDC_BUTTON_ADD_FILE,			m_buttonAddFile)
		DDX_CONTROL_HANDLE(IDC_BUTTON_REMOVE_FILE,		m_buttonRemoveFile)
		DDX_CONTROL_HANDLE(IDC_CHECK_JOB_AUTO_START,	m_checkJobAutoStart)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobGeneralPropertyPage)
		MSG_WM_INITDIALOG(OnInitDialog)
		MSG_WM_DESTROY(OnDestroy)
		COMMAND_ID_HANDLER_EX(IDC_BUTTON_ADD_FILE,		OnAddFileButtonDown)
		COMMAND_ID_HANDLER_EX(IDC_BUTTON_REMOVE_FILE,	OnRemoveFileButtonDown)
		COMMAND_HANDLER_EX(IDC_EDIT_JOB_DISPLAY_NAME, EN_CHANGE,	OnEnChangeJobName)
		COMMAND_HANDLER_EX(IDC_COMBO_JOB_PRIORITY,	CBN_SELCHANGE,	OnSelChangeJobPriority)
		COMMAND_HANDLER_EX(IDC_EDIT_JOB_DESCRIPTION,	EN_CHANGE,	OnEnChangeJobDescription)
		NOTIFY_HANDLER_EX(IDC_LIST_JOB_FILE_LIST, LVN_ITEMCHANGED,	OnJobFileListItemChanged)
		CHAIN_MSG_MAP(CPropertyPageImpl<CJobGeneralPropertyPage>)
	END_MSG_MAP()

	static const DWORD LOCAL_FILE_COLUMN_INDEX		= 0;
	static const DWORD LOCAL_FILE_COLUMN_WIDTH		= 230;
	static const DWORD REMOTE_FILE_COLUMN_INDEX		= 1;
	static const DWORD REMOTE_FILE_COLUMN_WIDTH		= 230;

	CJobGeneralPropertyPage(void);

	int OnApply(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager> spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);

	inline __checkReturn JOB_EDIT_MODE GetJobEditMode(void) const
	{
		return m_jobEditMode; 
	}

	inline void SetJobEditMode(__in JOB_EDIT_MODE jobEditMode)
	{
		ATLASSERT(INVALID_JOB_EDIT_MODE != jobEditMode);
		m_jobEditMode = jobEditMode;
	}


private:
	CEdit			m_editJobDisplayName;
	CString			m_strJobDisplayName;
	CComboBox		m_comboJobType;
	CComboBox		m_comboJobPriority;
	CEdit			m_editJobDescription;
	CString			m_strJobDescription;
	CListViewCtrl 	m_listCtrlJobFileList;
	CButton			m_buttonAddFile;
	CButton			m_buttonRemoveFile;
	CButton			m_checkJobAutoStart;

	CComPtr<IBackgroundCopyManager>	m_spBITSManager;
	CComPtr<IBackgroundCopyJob>		m_spJob;
	CComQIPtr<IBackgroundCopyJob3>	m_spJob3;
	JOB_EDIT_MODE					m_jobEditMode;
	bool							m_bModified;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnDestroy(void);
	LRESULT OnAddFileButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnRemoveFileButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeJobName(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnSelChangeJobPriority(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeJobDescription(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnJobFileListItemChanged(LPNMHDR /*pnmh*/);

	void AssertValidState(void);

	__checkReturn BG_JOB_TYPE GetJobTypeFromComboBox(void);
	bool SetJobTypeToComboBox(BG_JOB_TYPE jobType);
	__checkReturn BG_JOB_PRIORITY GetJobPriorityFromComboBox(void);
	bool SetJobPriorityToComboBox(BG_JOB_PRIORITY jobPriority);

	bool InitPropertyPageControls(void);
	bool InitJobTypeComboBox(void);
	bool InitJobPriorityComboBox(void);
	bool InitJobFileListCtrl(void);

	__checkReturn bool CreateJob(void);
	bool EditJob(void);

	bool LoadJobProperty(void);
	bool LoadJobFiles(__in const CComPtr<IEnumBackgroundCopyFiles>& spFiles);

	bool UpdatePropertyPageControls(void);
	bool UpdateRemoveFileButton(void);
	bool UpdateJobAutoStartCheckbox(void);

	bool DeleteListItem(int nItemIndex);
	bool DeleteAllListItems(void);

	__checkReturn int GetNewCopyFileCount(void);
	bool SetJobCopyFileAttribute(__in int nFileListIndex, __in PJOB_COPY_FILE_INFO pjobCopyfileInfo);
	__checkReturn bool IsJobCopyFileNew(__in int nFileListIndex);
	__checkReturn bool CheckJobProperty(void);
	__checkReturn bool CheckJobDisplayName(void);
	__checkReturn bool CheckJobType(void);
	__checkReturn bool CheckJobPriority(void);
	__checkReturn bool CheckJobDescription(void);

	__checkReturn bool IsBITS20Supported(void);

	__checkReturn HRESULT AddFiles(void);
	__checkReturn HRESULT AddFilesWithRange(__in int nItemIndex);
};
