#pragma once
#include "resource.h"


class CJobEditNotifyCommandDlg: public CDialogImpl<CJobEditNotifyCommandDlg>,
	public CWinDataExchange<CJobEditNotifyCommandDlg>
{
public:
	enum { IDD = IDD_EDIT_NOTIFY_COMMAND };

	BEGIN_DDX_MAP(CJobEditNotifyCommandDlg)
		DDX_CONTROL_HANDLE(IDC_EDIT_NOTIFY_COMMAND_PATH,	m_editNotifyCommandPath)
		DDX_CONTROL_HANDLE(IDC_EDIT_NOTIFY_COMMAND_ARG,		m_editNotifyCommandArg)
		DDX_CONTROL_HANDLE(IDOK,							m_buttonOK)
		DDX_CONTROL_HANDLE(IDC_BUTTON_BROWSE,				m_buttonBrowse)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobEditNotifyCommandDlg)
		MSG_WM_INITDIALOG(OnInitDialog)
		COMMAND_ID_HANDLER_EX(IDOK,					OnOK)
		COMMAND_ID_HANDLER_EX(IDCANCEL,				OnCancel)
		COMMAND_ID_HANDLER_EX(IDC_BUTTON_BROWSE,	OnBrowseButtonDown)
	END_MSG_MAP()

	CJobEditNotifyCommandDlg(void);
	~CJobEditNotifyCommandDlg(void);

	__checkReturn CString GetNotifyCommandPath(void);
	bool SetNotifyCommandPath(__in LPCWSTR lpszNotifyCommandPath);
	__checkReturn CString GetNotifyCommandArg(void);
	bool SetNotifyCommandArg(__in LPCWSTR lpszNotifyCommandArg);


private:
	CEdit	m_editNotifyCommandPath;
	CEdit	m_editNotifyCommandArg;
	CButton m_buttonBrowse;
	CButton	m_buttonOK;

	CString	m_strNotifyCommandPath;
	CString m_strNotifyCommandArg;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnBrowseButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);

	bool InitDialogControls(void);

	bool RefreshNotifyCommandVariables(void);

	__checkReturn bool CheckNotifyCommandPath(void);
};
