#pragma once
#include "resource.h"
#include "JobPropertySheetDef.h"


class CJobStatusPropertyPage:public CPropertyPageImpl<CJobStatusPropertyPage>,
							 public CWinDataExchange<CJobStatusPropertyPage>
{
public:
	enum { IDD = IDD_PROPPAGE_JOB_STATUS };

	BEGIN_DDX_MAP(CJobStatusPropertyPage)
		DDX_TEXT(IDC_STATIC_JOB_TYPE,				m_strJobType)
		DDX_TEXT(IDC_STATIC_JOB_PRIORITY,			m_strJobPriority)
		DDX_TEXT(IDC_STATIC_JOB_OWNER,				m_strJobOwner)
		DDX_TEXT(IDC_STATIC_JOB_CREATION_TIME,		m_strCreationTime)
		DDX_TEXT(IDC_STATIC_JOB_MODIFICATION_TIME,	m_strModificationTime)
		DDX_TEXT(IDC_STATIC_JOB_COMPLETION_TIME,	m_strCompletionTime)
		DDX_TEXT(IDC_STATIC_NOTIFY_INTERFACE,		m_strNotifyInterface)
		DDX_TEXT(IDC_STATIC_JOB_STATE,				m_strJobState)
		DDX_TEXT(IDC_STATIC_TOTAL_BYTE,				m_strTotalByte)
		DDX_TEXT(IDC_STATIC_BYTE_TRANSFERRED,		m_strByteTransferred)
		DDX_TEXT(IDC_STATIC_ERROR_COUNT,			m_strErrorCount)
		DDX_TEXT(IDC_STATIC_TOTAL_FILE,				m_strTotalFile)
		DDX_TEXT(IDC_STATIC_FILE_TRANSFERRED,		m_strFileTransferred)
		DDX_TEXT(IDC_STATIC_RETRY_DELAY,			m_strRetryDelay)
		DDX_TEXT(IDC_STATIC_NO_PROGRESS_TIMEOUT,	m_strNoProgressTimeout)
		DDX_CONTROL_HANDLE(IDC_EDIT_JOB_DISPLAY_NAME,				m_editJobDisplayName)
		DDX_CONTROL_HANDLE(IDC_EDIT_JOB_ID,							m_editJobId)
		DDX_CONTROL_HANDLE(IDC_STATIC_NOTIFY_JOB_ERROR,				m_staticNotifyJobError)
		DDX_CONTROL_HANDLE(IDC_STATIC_NOTIFY_DISABLE,				m_staticNotifyDisabled)
		DDX_CONTROL_HANDLE(IDC_STATIC_NOTIFY_JOB_TRANSFERRED,		m_staticNotifyJobTransferred)
		DDX_CONTROL_HANDLE(IDC_STATIC_NOTIFY_JOB_MODIFICATION,		m_staticNotifyJobModification)
		DDX_CONTROL_HANDLE(IDC_STATIC_NOTIFY_FILE_TRANSFERRED,		m_staticNotifyFileTransferred)
		DDX_CONTROL_HANDLE(IDC_BUTTON_TAKE_OWNERSHIP,				m_buttonTakeOwnership)
		DDX_CONTROL_HANDLE(IDC_BUTTON_MODIFY_RETRY_DELAY,			m_buttonModifyRetryDelay)
		DDX_CONTROL_HANDLE(IDC_BUTTON_MODIFY_NO_PROGRESS_TIMEOUT,	m_buttonModifyNoProgressTimeout)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobStatusPropertyPage)
		MSG_WM_INITDIALOG(OnInitDialog)
		MSG_WM_DESTROY(OnDestroy)
		MSG_WM_TIMER(OnTimer)
		COMMAND_ID_HANDLER_EX(IDC_BUTTON_MODIFY_RETRY_DELAY,			OnModifyRetryDelayButtonDown)
		COMMAND_ID_HANDLER_EX(IDC_BUTTON_MODIFY_NO_PROGRESS_TIMEOUT,	OnModifyNoProgressTimeoutButtonDown)
		COMMAND_ID_HANDLER_EX(IDC_BUTTON_TAKE_OWNERSHIP,				OnTakeOwnershipButtonDown)
	END_MSG_MAP()

	static const DWORD REFRESH_TIMER_ID	= 128;	
	static const DWORD REFRESH_INTERVAL	= 1 * 1000;

	CJobStatusPropertyPage(void);
	~CJobStatusPropertyPage(void);

	int OnApply(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);

private:
	CString m_strJobDisplayName;
	CString m_strJobId;
	CString m_strJobType;
	CString m_strJobPriority;
	CString m_strJobOwner;
	CString m_strCreationTime;
	CString m_strModificationTime;
	CString m_strCompletionTime;
	CString m_strNotifyInterface;
	CString m_strJobState;
	CString m_strTotalByte;
	CString m_strByteTransferred;
	CString m_strErrorCount;
	CString m_strTotalFile;
	CString m_strFileTransferred;
	CString m_strRetryDelay;
	CString m_strNoProgressTimeout;

	CStatic m_staticNotifyJobError;
	CStatic m_staticNotifyDisabled;
	CStatic m_staticNotifyJobTransferred;
	CStatic m_staticNotifyJobModification;
	CStatic m_staticNotifyFileTransferred;

	CEdit	m_editJobDisplayName;
	CEdit	m_editJobId;

	CButton m_buttonTakeOwnership;
	CButton	m_buttonModifyRetryDelay;
	CButton m_buttonModifyNoProgressTimeout;

	CComPtr<IBackgroundCopyManager>	m_spBITSManager;
	CComPtr<IBackgroundCopyJob>		m_spJob;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnDestroy(void);
	LRESULT OnTimer(__in UINT_PTR nIDEvent);

	LRESULT OnModifyRetryDelayButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnModifyNoProgressTimeoutButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnTakeOwnershipButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);

	bool RefreshUI(void);

	bool RefreshOtherProperty(void);
	bool RefreshNotifyProperty(void);
	bool RefreshGeneralProperty(void);
	bool RefreshTimeInfo(void);
	bool RefreshProgressInfo(void);
};
