#include "StdAfx.h"
#include "JobProxySettingPage.h"
#include "WTLCtrlUtil.h"
#include "BITSDef.h"
#include "BITSUtil.h"
#include "MiscUtil.h"


CJobProxySettingPage::CJobProxySettingPage(void):
	m_bModified(false)
{
	NULL;
}


CJobProxySettingPage::~CJobProxySettingPage(void)
{
	NULL;
}


LRESULT CJobProxySettingPage::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLVERIFY(DoDataExchange(FALSE));

	ATLVERIFY(InitPropertyPageControls());
	ATLVERIFY(RefreshByJobObject());

	return TRUE;
}


int CJobProxySettingPage::OnApply(void)
{
	ATLVERIFY(DoDataExchange(TRUE));

	if (false == BITSUtil::IsJobEditableState(m_spJob)) {
		return 1;
	}

	if (false == CheckInputAndShowErrorMessage()) {
		return 0;
	}

	if (false == m_bModified) {
		return 1;
	}

	HRESULT hr = BITSUtil::SetJobProxySettings(m_spJob, GetProxySettingComboBox(), m_strProxyUrl, m_strProxyBypassList);
	if (FAILED(hr)) {
		ATLASSERT(false);
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_EDIT_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	m_bModified = false;

	return 1;
}


BOOL CJobProxySettingPage::OnKillActive(void)
{
	if (false == CheckInputAndShowErrorMessage()) {
		return 0;
	}

	return 1;
}


bool CJobProxySettingPage::InitPropertyPageControls(void)
{
	ATLASSERT(m_spJob);

	ATLVERIFY(InitProxySettingComboBox());

	return true;
}


bool CJobProxySettingPage::InitProxySettingComboBox(void)
{
	int nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboProxySetting, IDS_JOB_PROXY_USAGE_PRECONFIG,
		static_cast<DWORD_PTR>(BG_JOB_PROXY_USAGE_PRECONFIG));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboProxySetting, IDS_JOB_PROXY_USAGE_NO_PROXY,
		static_cast<DWORD_PTR>(BG_JOB_PROXY_USAGE_NO_PROXY));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboProxySetting, IDS_JOB_PROXY_USAGE_AUTODETECT,
		static_cast<DWORD_PTR>(BG_JOB_PROXY_USAGE_AUTODETECT));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboProxySetting, IDS_JOB_PROXY_USAGE_OVERRIDE,
		static_cast<DWORD_PTR>(BG_JOB_PROXY_USAGE_OVERRIDE));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(SetProxySettingComboBox(BG_JOB_PROXY_USAGE_PRECONFIG));

	m_editProxyBypassList.SetLimitText(BITS_MAX_PROXY_BYPASS_LIST_LEN);

	return true;
}


LRESULT CJobProxySettingPage::OnSelChangeProxyUsage(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	ATLVERIFY(DoDataExchange(TRUE));

	BG_JOB_PROXY_USAGE proxyUsage = GetProxySettingComboBox();
	ATLVERIFY(Refresh(proxyUsage, m_strProxyUrl, m_strProxyBypassList));

	SetModified(TRUE);
	m_bModified = true;

	return 0;
}


LRESULT CJobProxySettingPage::OnEnChangeProxyUrl(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	SetModified(TRUE);
	m_bModified = true;

	return 0;
}


LRESULT CJobProxySettingPage::OnEnChangeProxyBypassList(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	SetModified(TRUE);
	m_bModified = true;

	return 0;
}


__checkReturn BG_JOB_PROXY_USAGE CJobProxySettingPage::GetProxySettingComboBox(void)
{
	int nCurSel = m_comboProxySetting.GetCurSel();
	ATLASSERT(CB_ERR != nCurSel);

	return static_cast<BG_JOB_PROXY_USAGE>(m_comboProxySetting.GetItemData(nCurSel));
}


bool CJobProxySettingPage::SetProxySettingComboBox(__in BG_JOB_PROXY_USAGE jobProxyUsage)
{
	ATLASSERT(BITSUtil::VerifyJobProxyUsage(jobProxyUsage));

	int nItemCount = m_comboProxySetting.GetCount();
	for (int nIndex = 0; nIndex < nItemCount; nIndex++) {
		if (jobProxyUsage == static_cast<BG_JOB_PROXY_USAGE>(m_comboProxySetting.GetItemData(nIndex))) {
			m_comboProxySetting.SetCurSel(nIndex);
			return true;
		}
	}

	ATLASSERT(false);
	return false;
}


bool CJobProxySettingPage::Refresh(__in BG_JOB_PROXY_USAGE jobProxyUsage, __in LPCWSTR lpszProxyList, __in LPCWSTR lpszProxyBypassList)
{
	if (BG_JOB_PROXY_USAGE_OVERRIDE == jobProxyUsage) {
		m_editProxyUrl.EnableWindow(TRUE);
		m_editProxyBypassList.EnableWindow(TRUE);
		m_strProxyUrl		= lpszProxyList;
		m_strProxyBypassList	= lpszProxyBypassList;
	} else {
		m_editProxyUrl.EnableWindow(FALSE);
		m_editProxyBypassList.EnableWindow(FALSE);
	}
	ATLVERIFY(SetProxySettingComboBox(jobProxyUsage));

	ATLVERIFY(DoDataExchange(FALSE));

	return true;
}


bool CJobProxySettingPage::RefreshByJobObject(void)
{
	BG_JOB_PROXY_USAGE jobProxyUsage = BG_JOB_PROXY_USAGE_PRECONFIG;
	CString strProxyList;
	CString strProxyBypassList;
	HRESULT hr = BITSUtil::GetJobProxySettings(m_spJob, &jobProxyUsage, &strProxyList, &strProxyBypassList);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	return Refresh(jobProxyUsage, strProxyList, strProxyBypassList);
}


bool CJobProxySettingPage::CheckInputAndShowErrorMessage(void)
{
	ATLVERIFY(DoDataExchange(TRUE));

	BG_JOB_PROXY_USAGE proxyUsage = GetProxySettingComboBox();
	if (BG_JOB_PROXY_USAGE_OVERRIDE == proxyUsage) {
		CString strProxyUrl = m_strProxyUrl;
		strProxyUrl.Trim();
		if (true == strProxyUrl.IsEmpty()) {
			MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_PROXY_URL_EMPTY, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);
			m_editProxyUrl.SetFocus();
			return false;
		}
	}

	return true;
}


void CJobProxySettingPage::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);
	if (m_spJob) {
		ATLASSERT(false);
		m_spJob.Release();
	}

	m_spJob = spJob;

	return;
}


void CJobProxySettingPage::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}
