#include "StdAfx.h"
#include "FileEditDlg.h"
#include "BITSUtil.h"
#include "MiscUtil.h"


CFileEditDlg::CFileEditDlg(__in BG_JOB_TYPE jobType, bool bBITS20Supported):
	m_jobType(jobType),
	m_bBITS20Supported(bBITS20Supported)
{
	NULL;
}


LRESULT CFileEditDlg::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLVERIFY(CenterWindow(GetParent()));
	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(InitDialogControls());

	return TRUE;
}


LRESULT CFileEditDlg::OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	ATLVERIFY(DoDataExchange(TRUE));

	if (false == BITSUtil::VerifyLocalFileName(m_strLocalFileName)) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_INVALID_LOCAL_FILE_NAME, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);
		m_editLocalFileName.SetFocus();

		return 0;
	}
	if (false == BITSUtil::VerifyRemoteFileName(m_strRemoteFileName)) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_INVALID_REMOTE_FILE_NAME, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);
		m_editRemoteFileName.SetFocus();

		return 0;
	}

	if (BG_JOB_TYPE_DOWNLOAD == m_jobType) {
		if (TRUE == ::PathFileExists(m_strLocalFileName)) {
			CString strMessage;
			strMessage.Format(IDS_QUESTION_LOCAL_FILE_OVERWRITE, m_strLocalFileName);
			int nAnswer = MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONQUESTION | MB_YESNO | MB_DEFBUTTON2);
			if (IDNO == nAnswer) {
				m_editLocalFileName.SetFocus();
				return 0;
			}
		}
	} else if (BG_JOB_TYPE_UPLOAD == m_jobType || BG_JOB_TYPE_UPLOAD_REPLY == m_jobType) {
		if (FALSE == ::PathFileExists(m_strLocalFileName)) {
			MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_NO_UPLOAD_FILE_EXIST, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);
			m_editLocalFileName.SetFocus();

			return 0;
		}
	} else {
		ATLASSERT(false);
	}

	ATLVERIFY(SaveFileRangeList());
	ATLVERIFY(DeleteAllListItems());

	EndDialog(nID);

	return 0;
}


LRESULT CFileEditDlg::OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	ATLVERIFY(DeleteAllListItems());

	EndDialog(nID);

	return 0;
}


LRESULT CFileEditDlg::OnAddRangeButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	BOOL bSuccess = FALSE;
	UINT ulOffset = GetDlgItemInt(IDC_EDIT_OFFSET, &bSuccess, FALSE);
	if (FALSE == bSuccess) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_INVALID_FILE_RANGE, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		return 0;
	}
	CString strOffset;
	strOffset.Format(L"%u", ulOffset);

	CString strSize;
	m_editSize.GetWindowText(strSize);

	ATLASSERT(!(true == strSize.IsEmpty() && BST_UNCHECKED == m_checkEOF.GetCheck()));

	UINT ulSize = 0;
	if (BST_UNCHECKED == m_checkEOF.GetCheck()) {
		bSuccess = FALSE;
		ulSize = GetDlgItemInt(IDC_EDIT_SIZE, &bSuccess, FALSE);
		if (FALSE == bSuccess) {
			MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_INVALID_FILE_RANGE, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

			return 0;
		}
	}

	int nItemIndex = m_listFileRange.GetItemCount();
	int nNewItemIndex = m_listFileRange.InsertItem(nItemIndex, strOffset);
	ATLASSERT(-1 != nNewItemIndex);

	BG_FILE_RANGE FileRange = {0};
	FileRange.InitialOffset = ulOffset;
	if (BST_CHECKED == m_checkEOF.GetCheck()) {
		CString strEOF = MiscUtil::LoadEOFString();

		ATLVERIFY(m_listFileRange.SetItemText(nItemIndex, FILE_SIZE_COLUMN_INDEX, strEOF));
		FileRange.Length = BG_LENGTH_TO_EOF;
	} else {
		ATLVERIFY(m_listFileRange.SetItemText(nItemIndex, FILE_SIZE_COLUMN_INDEX, strSize));
		FileRange.Length = ulSize;
	}
	ATLVERIFY(SetFileRangeInfoToListItem(nNewItemIndex, &FileRange));

	m_editOffset.SetWindowText(L"");
	m_editSize.SetWindowText(L"");
	m_checkEOF.SetCheck(BST_UNCHECKED);

	ATLVERIFY(UpdateUI());

	return 0;
}


LRESULT CFileEditDlg::OnFileRangeListItemChanged(LPNMHDR /*pnmh*/)
{
	ATLVERIFY(UpdateRemoveRangeButton());

	return 0;
}


LRESULT CFileEditDlg::OnEnChangeFileName(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	ATLVERIFY(DoDataExchange(TRUE));

	// OnInitDialogĂ΂ꂽ͂܂{^EBhEA^b`ĂȂ
	if (0 == ::IsWindow(m_buttonOK)) {
		return 0;
	}

	ATLVERIFY(UpdateUI());

	return 0;
}


LRESULT CFileEditDlg::OnEnChangeRangeInfo(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	ATLVERIFY(UpdateUI());

	return 0;
}


bool CFileEditDlg::InitDialogControls(void)
{
	ATLVERIFY(SetDialogTitle());
	ATLVERIFY(InitFileRangeList());

	m_buttonOK.EnableWindow(FALSE);

	return true;
}


bool CFileEditDlg::InitFileRangeList(void)
{
	CString strColumnName;
	if (0 == strColumnName.LoadString(IDS_COLUMN_FILE_OFFSET)) {
		ATLASSERT(false);
		return false;
	}
	int nResult = m_listFileRange.InsertColumn(FILE_OFFSET_COLUMN_INDEX, strColumnName, LVCFMT_LEFT,
		FILE_OFFSET_COLUMN_WIDTH);
	if (-1 == nResult) {
		ATLASSERT(false);
		return false;
	}

	if (0 == strColumnName.LoadString(IDS_COLUMN_FILE_SIZE)) {
		ATLASSERT(false);
		return false;
	}
	nResult = m_listFileRange.InsertColumn(FILE_SIZE_COLUMN_INDEX, strColumnName, LVCFMT_LEFT,
		FILE_SIZE_COLUMN_WIDTH);
	if (-1 == nResult) {
		ATLASSERT(false);
		return false;
	}

	m_listFileRange.SetExtendedListViewStyle(m_listFileRange.GetExtendedListViewStyle() |
		LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);

	if (false == m_bBITS20Supported) {
		m_editOffset.EnableWindow(FALSE);
		m_editSize.EnableWindow(FALSE);
		m_checkEOF.EnableWindow(FALSE);
		m_listFileRange.EnableWindow(FALSE);
		m_buttonAddRange.EnableWindow(FALSE);
		m_buttonRemoveRange.EnableWindow(FALSE);
	}

	return true;
}


bool CFileEditDlg::SetDialogTitle(void)
{
	UINT uTitleID = IDS_TITLE_ADD_DOWNLOAD_FILE;
	switch (m_jobType) {
		case BG_JOB_TYPE_DOWNLOAD:
			uTitleID = IDS_TITLE_ADD_DOWNLOAD_FILE;
			break;

		case BG_JOB_TYPE_UPLOAD:
		case BG_JOB_TYPE_UPLOAD_REPLY:
			uTitleID = IDS_TITLE_ADD_UPLOAD_FILE;
			break;

		default:
			ATLASSERT(false);
			return false;
	}

	CString strTitle;
	if (FALSE == strTitle.LoadString(uTitleID)) {
		return false;
	}

	if (FALSE == SetWindowText(strTitle)) {
		return false;
	}

	return true;
}


bool CFileEditDlg::SetFileRangeInfoToListItem(int nItemIndex, BG_FILE_RANGE* pFileRange)
{
	if (-1 == nItemIndex || NULL == pFileRange) {
		ATLASSERT(false);
		return false;
	}

	BG_FILE_RANGE* pNewFileRange = new BG_FILE_RANGE;
	*pNewFileRange = *pFileRange;

	BOOL bResult = m_listFileRange.SetItemData(nItemIndex, reinterpret_cast<DWORD_PTR>(pNewFileRange));
	pNewFileRange = NULL;

	return FALSE == bResult? false: true;
}


bool CFileEditDlg::UpdateUI(void)
{
	if (true == m_strLocalFileName.IsEmpty() || true == m_strRemoteFileName.IsEmpty()) {
		m_buttonOK.EnableWindow(FALSE);
	} else {
		m_buttonOK.EnableWindow(TRUE);
	}

	return UpdateRangeUI();
}


bool CFileEditDlg::UpdateRangeUI(void)
{
	if (false == m_bBITS20Supported) {
		return true;
	}

	ATLVERIFY(UpdateRemoveRangeButton());

	CString strOffset;
	CString strSize;
	if (BST_CHECKED == m_checkEOF.GetCheck()) {
		m_editSize.EnableWindow(FALSE);

		m_editOffset.GetWindowText(strOffset);
		if (false == strOffset.IsEmpty()) {
			m_buttonAddRange.EnableWindow(TRUE);
		} else {
			m_buttonAddRange.EnableWindow(FALSE);
		}
	} else {
		m_editSize.EnableWindow(TRUE);

		m_editOffset.GetWindowText(strOffset);
		m_editSize.GetWindowText(strSize);
		if (true == strOffset.IsEmpty() || true == strSize.IsEmpty()) {
			m_buttonAddRange.EnableWindow(FALSE);
		} else {
			m_buttonAddRange.EnableWindow(TRUE);
		}
	}

	return true;
}


bool CFileEditDlg::UpdateRemoveRangeButton(void)
{
	int nSelectedIndex = m_listFileRange.GetSelectedIndex();
	if (-1 == nSelectedIndex) {
		m_buttonRemoveRange.EnableWindow(FALSE);
		return true;
	}
	m_buttonRemoveRange.EnableWindow(TRUE);

	return true;
}


bool CFileEditDlg::SaveFileRangeList(void)
{
	m_FileRangeArray.RemoveAll();

	for (int nIndex = 0; nIndex < m_listFileRange.GetItemCount(); nIndex++) {
		m_FileRangeArray.Add(*(reinterpret_cast<BG_FILE_RANGE*>(m_listFileRange.GetItemData(nIndex))));
	}

	return true;
}


bool CFileEditDlg::DeleteListItem(int nItemIndex)
{
	if (-1 == nItemIndex) {
		ATLASSERT(false);
		return false;
	}

	BG_FILE_RANGE* pFileRange = reinterpret_cast<BG_FILE_RANGE*>(m_listFileRange.GetItemData(nItemIndex));
	ATLASSERT(pFileRange);
	delete pFileRange;
	pFileRange = NULL;

	BOOL bResult = m_listFileRange.DeleteItem(nItemIndex);

	return FALSE == bResult? false: true;
}


bool CFileEditDlg::DeleteAllListItems(void)
{
	for (int nIndex = m_listFileRange.GetItemCount() - 1; 0 <= nIndex; nIndex--) {
		ATLVERIFY(DeleteListItem(nIndex));
	}

	m_listFileRange.DeleteAllItems();

	return true;
}

