/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * EditorPane.java
 *
 * Created on 2011/06/30, 13:44:44
 */

package beluga;


import org.apache.http.*;
import org.apache.http.client.entity.*;
import org.apache.http.client.methods.*;
import org.apache.http.impl.client.*;
import org.apache.http.message.*;
import org.apache.http.protocol.*;

import javax.swing.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;


/**
 *
 * @author g9133
 */
public class EditorPane extends javax.swing.JPanel {
    private PodBean podBean = null;

    /** Creates new form EditorPane */
    public EditorPane(PodBean podBean) {
        this.podBean = podBean;

        initComponents();

        jTextField_topic.addFocusListener(new IMEControl(IMEControl.KANJI));
        jTextField_topic.setText(podBean.getPodTitle());
        jTextArea_emails.addFocusListener(new IMEControl(IMEControl.LATIN));
        jTextArea_emails.addKeyListener(new KeyAdapter() {
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == e.VK_TAB) {
                    e.consume();
                }
            }
        });

        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                jTextField_topic.requestFocus();
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel_topic = new javax.swing.JLabel();
        jTextField_topic = new javax.swing.JTextField();
        jLabel_member = new javax.swing.JLabel();
        jScrollPane = new javax.swing.JScrollPane();
        jTextArea_emails = new javax.swing.JTextArea();
        jPanel_button = new javax.swing.JPanel();
        jButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jLabel_topic.setText("Topic");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(10, 15, 0, 0);
        add(jLabel_topic, gridBagConstraints);

        jTextField_topic.setColumns(30);
        jTextField_topic.setMinimumSize(new java.awt.Dimension(186, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        add(jTextField_topic, gridBagConstraints);

        jLabel_member.setText("Add Members");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(10, 15, 0, 0);
        add(jLabel_member, gridBagConstraints);

        jTextArea_emails.setColumns(40);
        jTextArea_emails.setLineWrap(true);
        jTextArea_emails.setRows(5);
        jTextArea_emails.setWrapStyleWord(true);
        jScrollPane.setViewportView(jTextArea_emails);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        add(jScrollPane, gridBagConstraints);

        jPanel_button.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT, 0, 0));

        jButton.setText("Save");
        jButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonActionPerformed(evt);
            }
        });
        jPanel_button.add(jButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(10, 15, 10, 10);
        add(jPanel_button, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonActionPerformed
        if (jTextField_topic.getText().length() < 1) {
            JOptionPane.showMessageDialog(this, "<html><font color='red'>A pod must have a topic.", "Error", JOptionPane.ERROR_MESSAGE);
            return;
        }

        try {
            DefaultHttpClient    client = BelugaClient.getHttpClient();
            HttpPost             post   = new HttpPost("http://belugapods.com/edit/" + podBean.getId());
            List<NameValuePair>  nvps   = new ArrayList <NameValuePair>();
    
            nvps.add(new BasicNameValuePair("_xsrf" , client.getCookieStore().getCookies().get(0).getValue()));
            nvps.add(new BasicNameValuePair("podid" , podBean.getId()));
            nvps.add(new BasicNameValuePair("what"  , jTextField_topic.getText()));
            
            if (jTextArea_emails.getText().length() > 0) {
                nvps.add(new BasicNameValuePair("emails", jTextArea_emails.getText()));
            }
    
            post.setEntity(new UrlEncodedFormEntity(nvps, HTTP.UTF_8));

            HttpResponse res = BelugaClient.getHttpClient().execute(post);
            HttpEntity   ent = res.getEntity();

            BufferedReader reader = new BufferedReader(new InputStreamReader(ent.getContent(), "UTF8"));
            String         line   = "";
            
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }//GEN-LAST:event_jButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton;
    private javax.swing.JLabel jLabel_member;
    private javax.swing.JLabel jLabel_topic;
    private javax.swing.JPanel jPanel_button;
    private javax.swing.JScrollPane jScrollPane;
    private javax.swing.JTextArea jTextArea_emails;
    private javax.swing.JTextField jTextField_topic;
    // End of variables declaration//GEN-END:variables

}
