/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * BelugaFrame.java
 *
 * Created on 2011/06/23, 13:38:15
 */

package beluga;


import org.apache.http.*;
import org.apache.http.client.methods.*;
import org.apache.http.impl.client.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.util.prefs.Preferences;
import java.util.regex.*;


/**
 *
 * @author g9133
 */
public class BelugaFrame extends javax.swing.JFrame implements IFBelugaFrame {

    /** Creates new form BelugaFrame */
    public BelugaFrame() {
        initComponents();

        this.setIconImage(new ImageIcon(this.getClass().getResource("favicon.png")).getImage());

        setLocationRelativeTo(null);

        Preferences pref = Preferences.userNodeForPackage(this.getClass());
        
        try {
            jCheckBoxMenuItem_auto_login.setSelected(pref.getBoolean("login.auto", false));
            
            jTextField_ident.setText(pref.get("login.id", ""));
            jPasswordField_password.setText(pref.get("login.pass", ""));

            jCheckBoxMenuItem_user  .setSelected(pref.getBoolean("icon.user"  , true));
            jCheckBoxMenuItem_pod   .setSelected(pref.getBoolean("icon.pod"   , true));
            jCheckBoxMenuItem_member.setSelected(pref.getBoolean("icon.member", true));

            jSplitPane.setDividerLocation(pref.getInt("div.size", 50));

            this.setLocation(pref.getInt("loc.x", this.getX()), pref.getInt("loc.y", this.getY()));
            this.setSize    (pref.getInt("size.width", this.getWidth()), pref.getInt("size.height", this.getHeight()));

            jCheckBoxMenuItem_ontop   .setSelected(pref.getBoolean("start.ontop"  , false));
            jCheckBoxMenuItem_startup .setSelected(pref.getBoolean("start.up"     , false));
            jCheckBoxMenuItem_always  .setSelected(pref.getBoolean("task.always"  , false));
            jCheckBoxMenuItem_close   .setSelected(pref.getBoolean("task.close"   , false));
            jCheckBoxMenuItem_minimize.setSelected(pref.getBoolean("task.minimize", false));

            this.setAlwaysOnTop(jCheckBoxMenuItem_ontop.isSelected());

            if (jCheckBoxMenuItem_always.isSelected()) {
                checkTaskTray(false);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        jTextArea_message.addFocusListener(new IMEControl(IMEControl.KANJI));
        jTabbedPane_pods.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                PodPane pp = getSelectedPodPane();
                
                if (pp == null) {
                    return;
                }
                
                String  action = (String)  jLabel_status.getClientProperty(pp.getPodBean().getId());

                pp.show(action);

                if ("Updates".equals(action)) {
                    jToggleButton_updates.setSelected(true);
                } else if ("Members".equals(action)) {
                    jToggleButton_members.setSelected(true);
                } else if ("Map".equals(action)) {
                    jToggleButton_map.setSelected(true);
                } else if ("Edit".equals(action)) {
                    jToggleButton_edit.setSelected(true);
                }

                jTextArea_message.requestFocus();
            }
        });
    }
    
    public void open() {
        if (!jCheckBoxMenuItem_startup.isSelected()) {
            this.setVisible(true);
        }

        new Thread() {
            public void run() {
                if (jCheckBoxMenuItem_auto_login.isSelected()) {
                    jToggleButton_loginActionPerformed(null);
                }
            }
        }.start();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup = new javax.swing.ButtonGroup();
        jPopupMenu = new javax.swing.JPopupMenu();
        jMenuItem_paste1 = new javax.swing.JMenuItem();
        jPanel_context = new javax.swing.JPanel();
        jPanel_north = new javax.swing.JPanel();
        jPanel_top = new javax.swing.JPanel();
        jLabel_ident = new javax.swing.JLabel();
        jTextField_ident = new javax.swing.JTextField();
        jLabel_password = new javax.swing.JLabel();
        jPasswordField_password = new javax.swing.JPasswordField();
        jToggleButton_login = new javax.swing.JToggleButton();
        jSeparator = new javax.swing.JSeparator();
        jPanel_center = new javax.swing.JPanel();
        jSplitPane = new javax.swing.JSplitPane();
        jPanel_input = new javax.swing.JPanel();
        jScrollPane = new javax.swing.JScrollPane();
        jTextArea_message = new javax.swing.JTextArea();
        jButton_send = new javax.swing.JButton();
        jLabel_icon = new javax.swing.JLabel();
        jTabbedPane_pods = new javax.swing.JTabbedPane();
        jPanel_south = new javax.swing.JPanel();
        jPanel_buttons = new javax.swing.JPanel();
        jButton_reload = new javax.swing.JButton();
        jToggleButton_updates = new javax.swing.JToggleButton();
        jToggleButton_members = new javax.swing.JToggleButton();
        jToggleButton_map = new javax.swing.JToggleButton();
        jToggleButton_edit = new javax.swing.JToggleButton();
        jLabel_status = new javax.swing.JLabel();
        jMenuBar = new javax.swing.JMenuBar();
        jMenu_file = new javax.swing.JMenu();
        jMenuItem_logout = new javax.swing.JMenuItem();
        jCheckBoxMenuItem_auto_login = new javax.swing.JCheckBoxMenuItem();
        jMenuItem_quit = new javax.swing.JMenuItem();
        jMenu_edit = new javax.swing.JMenu();
        jMenuItem_copy = new javax.swing.JMenuItem();
        jMenuItem_paste = new javax.swing.JMenuItem();
        jMenuItem_option = new javax.swing.JMenuItem();
        jMenu_view = new javax.swing.JMenu();
        jCheckBoxMenuItem_user = new javax.swing.JCheckBoxMenuItem();
        jCheckBoxMenuItem_pod = new javax.swing.JCheckBoxMenuItem();
        jCheckBoxMenuItem_member = new javax.swing.JCheckBoxMenuItem();
        jSeparator1 = new javax.swing.JPopupMenu.Separator();
        jCheckBoxMenuItem_ontop = new javax.swing.JCheckBoxMenuItem();
        jSeparator2 = new javax.swing.JPopupMenu.Separator();
        jCheckBoxMenuItem_startup = new javax.swing.JCheckBoxMenuItem();
        jCheckBoxMenuItem_always = new javax.swing.JCheckBoxMenuItem();
        jCheckBoxMenuItem_minimize = new javax.swing.JCheckBoxMenuItem();
        jCheckBoxMenuItem_close = new javax.swing.JCheckBoxMenuItem();
        jMenu_help = new javax.swing.JMenu();
        jMenuItem_version = new javax.swing.JMenuItem();

        jMenuItem_paste1.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_V, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem_paste1.setMnemonic('P');
        jMenuItem_paste1.setText("Paste");
        jMenuItem_paste1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_paste1ActionPerformed(evt);
            }
        });
        jPopupMenu.add(jMenuItem_paste1);

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("Beluga Client for Java");
        setMinimumSize(new java.awt.Dimension(420, 367));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
            public void windowIconified(java.awt.event.WindowEvent evt) {
                formWindowIconified(evt);
            }
        });

        jPanel_context.setLayout(new java.awt.BorderLayout());

        jPanel_north.setLayout(new java.awt.BorderLayout());

        jPanel_top.setLayout(new java.awt.GridBagLayout());

        jLabel_ident.setText("E-Mail");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 0);
        jPanel_top.add(jLabel_ident, gridBagConstraints);

        jTextField_ident.setColumns(12);
        jTextField_ident.setText("zeebra@v7.com");
        jTextField_ident.setMinimumSize(new java.awt.Dimension(100, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 0);
        jPanel_top.add(jTextField_ident, gridBagConstraints);

        jLabel_password.setText("Password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 0);
        jPanel_top.add(jLabel_password, gridBagConstraints);

        jPasswordField_password.setColumns(12);
        jPasswordField_password.setText("noel2lip");
        jPasswordField_password.setMinimumSize(new java.awt.Dimension(100, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 0);
        jPanel_top.add(jPasswordField_password, gridBagConstraints);

        jToggleButton_login.setText("Login");
        jToggleButton_login.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton_loginActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel_top.add(jToggleButton_login, gridBagConstraints);

        jPanel_north.add(jPanel_top, java.awt.BorderLayout.PAGE_START);

        jSeparator.setMinimumSize(new java.awt.Dimension(0, 4));
        jSeparator.setPreferredSize(new java.awt.Dimension(0, 4));
        jPanel_north.add(jSeparator, java.awt.BorderLayout.CENTER);

        jPanel_context.add(jPanel_north, java.awt.BorderLayout.NORTH);

        jPanel_center.setLayout(new java.awt.BorderLayout());

        jSplitPane.setBorder(null);
        jSplitPane.setDividerLocation(50);
        jSplitPane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jPanel_input.setLayout(new java.awt.BorderLayout());

        jScrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPane.setMinimumSize(new java.awt.Dimension(270, 50));
        jScrollPane.setPreferredSize(new java.awt.Dimension(270, 50));
        jScrollPane.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jScrollPaneMouseReleased(evt);
            }
        });

        jTextArea_message.setColumns(38);
        jTextArea_message.setLineWrap(true);
        jTextArea_message.setRows(3);
        jTextArea_message.setTabSize(0);
        jTextArea_message.setWrapStyleWord(true);
        jTextArea_message.setMinimumSize(new java.awt.Dimension(140, 50));
        jTextArea_message.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jTextArea_messageMouseReleased(evt);
            }
        });
        jTextArea_message.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextArea_messageKeyTyped(evt);
            }
        });
        jScrollPane.setViewportView(jTextArea_message);

        jPanel_input.add(jScrollPane, java.awt.BorderLayout.CENTER);

        jButton_send.setText("Send");
        jButton_send.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButton_send.setMaximumSize(new java.awt.Dimension(50, 50));
        jButton_send.setMinimumSize(new java.awt.Dimension(50, 50));
        jButton_send.setPreferredSize(new java.awt.Dimension(50, 50));
        jButton_send.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_sendActionPerformed(evt);
            }
        });
        jPanel_input.add(jButton_send, java.awt.BorderLayout.EAST);

        jLabel_icon.setAlignmentY(0.0F);
        jLabel_icon.setIconTextGap(0);
        jLabel_icon.setMaximumSize(new java.awt.Dimension(50, 50));
        jLabel_icon.setMinimumSize(new java.awt.Dimension(50, 50));
        jLabel_icon.setPreferredSize(new java.awt.Dimension(50, 50));
        jPanel_input.add(jLabel_icon, java.awt.BorderLayout.WEST);

        jSplitPane.setTopComponent(jPanel_input);

        jTabbedPane_pods.setTabLayoutPolicy(javax.swing.JTabbedPane.SCROLL_TAB_LAYOUT);
        jTabbedPane_pods.setRequestFocusEnabled(false);
        jSplitPane.setBottomComponent(jTabbedPane_pods);

        jPanel_center.add(jSplitPane, java.awt.BorderLayout.CENTER);

        jPanel_context.add(jPanel_center, java.awt.BorderLayout.CENTER);

        jPanel_south.setLayout(new java.awt.BorderLayout());

        jPanel_buttons.setLayout(new java.awt.GridLayout(0, 5));

        jButton_reload.setText("Reload");
        jButton_reload.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_reloadActionPerformed(evt);
            }
        });
        jPanel_buttons.add(jButton_reload);

        buttonGroup.add(jToggleButton_updates);
        jToggleButton_updates.setSelected(true);
        jToggleButton_updates.setText("Updates");
        jToggleButton_updates.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton_updatesActionPerformed(evt);
            }
        });
        jPanel_buttons.add(jToggleButton_updates);

        buttonGroup.add(jToggleButton_members);
        jToggleButton_members.setText("Members");
        jToggleButton_members.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton_membersActionPerformed(evt);
            }
        });
        jPanel_buttons.add(jToggleButton_members);

        buttonGroup.add(jToggleButton_map);
        jToggleButton_map.setText("Map");
        jToggleButton_map.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton_mapActionPerformed(evt);
            }
        });
        jPanel_buttons.add(jToggleButton_map);

        buttonGroup.add(jToggleButton_edit);
        jToggleButton_edit.setText("Edit");
        jToggleButton_edit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton_editActionPerformed(evt);
            }
        });
        jPanel_buttons.add(jToggleButton_edit);

        jPanel_south.add(jPanel_buttons, java.awt.BorderLayout.CENTER);

        jLabel_status.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
        jLabel_status.setMinimumSize(new java.awt.Dimension(4, 19));
        jLabel_status.setPreferredSize(new java.awt.Dimension(4, 19));
        jPanel_south.add(jLabel_status, java.awt.BorderLayout.SOUTH);

        jPanel_context.add(jPanel_south, java.awt.BorderLayout.SOUTH);

        getContentPane().add(jPanel_context, java.awt.BorderLayout.CENTER);

        jMenu_file.setMnemonic('F');
        jMenu_file.setText("File");

        jMenuItem_logout.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_L, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem_logout.setMnemonic('L');
        jMenuItem_logout.setText("Logout");
        jMenuItem_logout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_logoutActionPerformed(evt);
            }
        });
        jMenu_file.add(jMenuItem_logout);

        jCheckBoxMenuItem_auto_login.setText("Auto Login");
        jMenu_file.add(jCheckBoxMenuItem_auto_login);

        jMenuItem_quit.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Q, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem_quit.setMnemonic('Q');
        jMenuItem_quit.setText("Quit");
        jMenuItem_quit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_quitActionPerformed(evt);
            }
        });
        jMenu_file.add(jMenuItem_quit);

        jMenuBar.add(jMenu_file);

        jMenu_edit.setMnemonic('E');
        jMenu_edit.setText("Edit");

        jMenuItem_copy.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem_copy.setMnemonic('C');
        jMenuItem_copy.setText("Copy");
        jMenu_edit.add(jMenuItem_copy);

        jMenuItem_paste.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_V, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem_paste.setMnemonic('P');
        jMenuItem_paste.setText("Paste");
        jMenu_edit.add(jMenuItem_paste);

        jMenuItem_option.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem_option.setMnemonic('O');
        jMenuItem_option.setText("Option");
        jMenuItem_option.setEnabled(false);
        jMenuItem_option.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_optionActionPerformed(evt);
            }
        });
        jMenu_edit.add(jMenuItem_option);

        jMenuBar.add(jMenu_edit);

        jMenu_view.setMnemonic('V');
        jMenu_view.setText("View");

        jCheckBoxMenuItem_user.setSelected(true);
        jCheckBoxMenuItem_user.setText("Your Icon");
        jCheckBoxMenuItem_user.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCheckBoxMenuItem_userItemStateChanged(evt);
            }
        });
        jMenu_view.add(jCheckBoxMenuItem_user);

        jCheckBoxMenuItem_pod.setSelected(true);
        jCheckBoxMenuItem_pod.setText("Pod Icon");
        jCheckBoxMenuItem_pod.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCheckBoxMenuItem_podItemStateChanged(evt);
            }
        });
        jMenu_view.add(jCheckBoxMenuItem_pod);

        jCheckBoxMenuItem_member.setSelected(true);
        jCheckBoxMenuItem_member.setText("Member Icon");
        jCheckBoxMenuItem_member.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCheckBoxMenuItem_memberItemStateChanged(evt);
            }
        });
        jMenu_view.add(jCheckBoxMenuItem_member);
        jMenu_view.add(jSeparator1);

        jCheckBoxMenuItem_ontop.setSelected(true);
        jCheckBoxMenuItem_ontop.setText("Always on Top");
        jCheckBoxMenuItem_ontop.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCheckBoxMenuItem_ontopItemStateChanged(evt);
            }
        });
        jMenu_view.add(jCheckBoxMenuItem_ontop);
        jMenu_view.add(jSeparator2);

        jCheckBoxMenuItem_startup.setText("Startup with Tray");
        jMenu_view.add(jCheckBoxMenuItem_startup);

        jCheckBoxMenuItem_always.setText("Always on Tray");
        jCheckBoxMenuItem_always.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCheckBoxMenuItem_alwaysItemStateChanged(evt);
            }
        });
        jMenu_view.add(jCheckBoxMenuItem_always);

        jCheckBoxMenuItem_minimize.setText("Minimize to Tray");
        jMenu_view.add(jCheckBoxMenuItem_minimize);

        jCheckBoxMenuItem_close.setText("Close to Tray");
        jMenu_view.add(jCheckBoxMenuItem_close);

        jMenuBar.add(jMenu_view);

        jMenu_help.setMnemonic('H');
        jMenu_help.setText("Help");

        jMenuItem_version.setMnemonic('V');
        jMenuItem_version.setText("Version");
        jMenuItem_version.setEnabled(false);
        jMenuItem_version.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_versionActionPerformed(evt);
            }
        });
        jMenu_help.add(jMenuItem_version);

        jMenuBar.add(jMenu_help);

        setJMenuBar(jMenuBar);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private HashMap    constant_map = null;
    private WaitWindow waitWindow    = null;

    private void jToggleButton_loginActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton_loginActionPerformed
        if (isShowing()) {
            showWaitWindow("Please wait logging...");
        }
        
        try {
            if ((constant_map = login()) == null) {
                closeWaitWindow();
                return;
            }

            displayMessage("Beluga", "Login Successfly", TrayIcon.MessageType.INFO);
        } catch (Exception ex) {
            ex.printStackTrace();
            displayMessage("Error", "Network error\n" + ex.getMessage(), TrayIcon.MessageType.ERROR);

            setVisible(true);
            setExtendedState(JFrame.NORMAL);
            return;
        } finally {
            closeWaitWindow();
        }

        jPanel_north.setVisible(false);

        this.setHttpClient((DefaultHttpClient) constant_map.get("client"));

        jLabel_icon.setIcon(getImageIcon(getHttpClient(), (String) constant_map.get("user_image")));

        SwingUtilities.invokeLater(new Runnable() {
               public void run() {
                   podsSetting();
               }
           });
        
    }//GEN-LAST:event_jToggleButton_loginActionPerformed

    public HashMap getConstantMap() {
        return constant_map;
    }

    private DefaultHttpClient client = null;
    
    private void setHttpClient(DefaultHttpClient client) {
        this.client = client;
    }
    
    public DefaultHttpClient getHttpClient() {
        return this.client;
    }
    
    private void jToggleButton_updatesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton_updatesActionPerformed
        if (getSelectedPodPane() == null) {
            return;
        }

        getSelectedPodPane().show(evt.getActionCommand());
        jLabel_status.putClientProperty(getSelectedPodPane().getPodBean().getId(), evt.getActionCommand());
    }//GEN-LAST:event_jToggleButton_updatesActionPerformed

    private void jToggleButton_membersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton_membersActionPerformed
        if (getSelectedPodPane() == null) {
            return;
        }

        getSelectedPodPane().show(evt.getActionCommand());
        jLabel_status.putClientProperty(getSelectedPodPane().getPodBean().getId(), evt.getActionCommand());
    }//GEN-LAST:event_jToggleButton_membersActionPerformed

    private void jToggleButton_mapActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton_mapActionPerformed
        JOptionPane.showMessageDialog(this, "Map is not supported.", "Info", JOptionPane.WARNING_MESSAGE);

        if (true) {
            return;
        }

        if (getSelectedPodPane() == null) {
            return;
        }

        getSelectedPodPane().show(evt.getActionCommand());
        jLabel_status.putClientProperty(getSelectedPodPane().getPodBean().getId(), evt.getActionCommand());
    }//GEN-LAST:event_jToggleButton_mapActionPerformed

    private void jToggleButton_editActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton_editActionPerformed
        if (getSelectedPodPane() == null) {
            return;
        }

        getSelectedPodPane().show(evt.getActionCommand());
        jLabel_status.putClientProperty(getSelectedPodPane().getPodBean().getId(), evt.getActionCommand());
    }//GEN-LAST:event_jToggleButton_editActionPerformed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        if (jCheckBoxMenuItem_close.isSelected()) {
            checkTaskTray(true);
            return;
        }

        systemExit(true);
    }//GEN-LAST:event_formWindowClosing
    
    private void systemExit(boolean isConfirm) {
        if (isConfirm) {
            int ans = JOptionPane.showConfirmDialog(this, "Quit?", "Question", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
    
            if (ans != JOptionPane.YES_OPTION) {
                return;
            }
        }

        if (this.getHttpClient() != null) {
            this.getHttpClient().getConnectionManager().shutdown();
        }

        Preferences pref = Preferences.userNodeForPackage(this.getClass());

        try {
            pref.putBoolean("login.auto" , jCheckBoxMenuItem_auto_login.isSelected());
            pref.put       ("login.id"   , jTextField_ident.getText());
            pref.put       ("login.pass" , String.valueOf(jPasswordField_password.getPassword()));
            pref.putBoolean("icon.user"  , jCheckBoxMenuItem_user.isSelected());
            pref.putBoolean("icon.pod"   , jCheckBoxMenuItem_pod.isSelected());
            pref.putBoolean("icon.member", jCheckBoxMenuItem_member.isSelected());

            try {
                pref.putInt("div.size"   , jSplitPane.getDividerLocation());
                pref.putInt("loc.x"      , getLocation().x);
                pref.putInt("loc.y"      , getLocation().y);
                pref.putInt("size.width" , getWidth());
                pref.putInt("size.height", getHeight());
            } catch (Exception ex) {
            }

            pref.putBoolean("start.ontop"  , jCheckBoxMenuItem_ontop.isSelected());
            pref.putBoolean("start.up"     , jCheckBoxMenuItem_startup.isSelected());
            pref.putBoolean("task.always"  , jCheckBoxMenuItem_always.isSelected());
            pref.putBoolean("task.close"   , jCheckBoxMenuItem_always.isSelected());
            pref.putBoolean("task.minimize", jCheckBoxMenuItem_always.isSelected());

            pref.flush();
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        System.exit(0);
    }

    private void jButton_sendActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_sendActionPerformed
        try {
            if (getSelectedPodPane() == null) {
                return;
            }

            if (jTextArea_message.getText().length() < 1) {
                return;
            }

            getSelectedPodPane().send(jTextArea_message.getText());

            jToggleButton_updatesActionPerformed(new ActionEvent(jToggleButton_updates, 0, jToggleButton_updates.getActionCommand()));
        } catch (Exception ex) {
            ex.printStackTrace();

            JOptionPane.showMessageDialog(this, "Send Error.\nPlease check me connection.", "Error", JOptionPane.ERROR_MESSAGE);
            return;
        }

        jTextArea_message.setText("");
    }//GEN-LAST:event_jButton_sendActionPerformed

    private void jButton_reloadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_reloadActionPerformed
        try {
            new Thread() {
                public void run() {
                    showWaitWindow("Please wait reload...");

                    if (getSelectedPodPane() != null) {
                        getSelectedPodPane().updatePod();
                    }

                    closeWaitWindow();
                }
            }.start();
        } catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }//GEN-LAST:event_jButton_reloadActionPerformed

    private void jMenuItem_quitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_quitActionPerformed
        systemExit(true);
    }//GEN-LAST:event_jMenuItem_quitActionPerformed

    private void jMenuItem_optionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_optionActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jMenuItem_optionActionPerformed

    private void jMenuItem_versionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_versionActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jMenuItem_versionActionPerformed

    private void jTextArea_messageKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextArea_messageKeyTyped
        if (evt.getKeyChar() == evt.VK_TAB) {
            evt.consume();
            jButton_send.requestFocus();
        }

        if (evt.getKeyChar() == evt.VK_ESCAPE) {
            evt.consume();
            
            jTextArea_message.setText("");
        }
    }//GEN-LAST:event_jTextArea_messageKeyTyped

    private void jMenuItem_paste1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_paste1ActionPerformed
        Transferable object = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);

        try {
            jTextArea_message.setText((String) object.getTransferData(DataFlavor.stringFlavor));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }//GEN-LAST:event_jMenuItem_paste1ActionPerformed

    private void jScrollPaneMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jScrollPaneMouseReleased
        jMenuItem_paste1ActionPerformed(null);
    }//GEN-LAST:event_jScrollPaneMouseReleased

    private void jTextArea_messageMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTextArea_messageMouseReleased
        if (!evt.isPopupTrigger()) {
            return;
        }

        jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
    }//GEN-LAST:event_jTextArea_messageMouseReleased

    private void jCheckBoxMenuItem_userItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItem_userItemStateChanged
        if (jCheckBoxMenuItem_user.isSelected()) {
            jPanel_input.add(jLabel_icon, "West");
        } else {
            jPanel_input.remove(jLabel_icon);
        }

        jPanel_input.updateUI();
    }//GEN-LAST:event_jCheckBoxMenuItem_userItemStateChanged

    private void jCheckBoxMenuItem_podItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItem_podItemStateChanged
        for (int i = 0; i < jTabbedPane_pods.getTabCount(); i++) {
            jTabbedPane_pods.setIconAt(i, jCheckBoxMenuItem_pod.isSelected() ? getPodPaneAt(i).getPodImage() : null);
            
            if (jTabbedPane_pods.getTabComponentAt(i) != null) {
                ((JLabel) jTabbedPane_pods.getTabComponentAt(i)).setIcon(jCheckBoxMenuItem_pod.isSelected() ? getPodPaneAt(i).getPodImage() : null);
            }
        }
    }//GEN-LAST:event_jCheckBoxMenuItem_podItemStateChanged

    private void jCheckBoxMenuItem_memberItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItem_memberItemStateChanged
        new Thread() {
            public void run() {
                for (int i = 0; i < jTabbedPane_pods.getTabCount(); i++) {
                    getPodPaneAt(i).setVisibleIcon(jCheckBoxMenuItem_member.isSelected());
                    getPodPaneAt(i).updateUI();
                }
            }
        }.start();
    }//GEN-LAST:event_jCheckBoxMenuItem_memberItemStateChanged

    private void formWindowIconified(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowIconified
        if (jCheckBoxMenuItem_always.isSelected() || jCheckBoxMenuItem_minimize.isSelected()) {
            checkTaskTray(true);
            return;
        }
    }//GEN-LAST:event_formWindowIconified

    private void jCheckBoxMenuItem_alwaysItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItem_alwaysItemStateChanged
        jCheckBoxMenuItem_minimize.setEnabled(!jCheckBoxMenuItem_always.isSelected());
        jCheckBoxMenuItem_close   .setEnabled(!jCheckBoxMenuItem_always.isSelected());
    }//GEN-LAST:event_jCheckBoxMenuItem_alwaysItemStateChanged

    private void jMenuItem_logoutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_logoutActionPerformed
        jPanel_north.setVisible(true);
        jTabbedPane_pods.removeAll();
    }//GEN-LAST:event_jMenuItem_logoutActionPerformed

    private void jCheckBoxMenuItem_ontopItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItem_ontopItemStateChanged
        this.setAlwaysOnTop(jCheckBoxMenuItem_ontop.isSelected());
    }//GEN-LAST:event_jCheckBoxMenuItem_ontopItemStateChanged

    private PodPane getSelectedPodPane() {
        return getPodPaneAt(jTabbedPane_pods.getSelectedIndex());
    }

    private PodPane getPodPaneAt(int index) {
        if (index < 0) {
            return null;
        }
        
        if (jTabbedPane_pods.getComponentAt(index) == null) {
            return null;
        }
        
        Component compo = jTabbedPane_pods.getComponentAt(index);

        if (compo == null || !(compo instanceof PodPane)) {
            return null;
        }

        PodPane podPane = (PodPane) compo;

        if (podPane == null) {
            return null;
        }

        return podPane;
    }
    
    private boolean checkInputField() {
        if (jTextField_ident.getText().length() < 1) {
            if (!isShowing()) {
                setVisible(true);
                setExtendedState(JFrame.NORMAL);
            }

            JOptionPane.showMessageDialog(this, "Please input [ E-Mail ] field.", "Input error", JOptionPane.ERROR_MESSAGE);

            SwingUtilities.invokeLater(new Runnable() {
                                            public void run() {
                                                jTextField_ident.requestFocus();
                                                jTextField_ident.selectAll();
                                                jToggleButton_login.setSelected(false);
                                            }
                                        });

            return false;
        }

        if (!Pattern.compile("[\\w\\.\\-]+@(?:[\\w\\-]+\\.)+[\\w\\-]+").matcher(jTextField_ident.getText()).matches()) {
            if (!isShowing()) {
                setVisible(true);
                setExtendedState(JFrame.NORMAL);
            }

            JOptionPane.showMessageDialog(this, "Please input [ E-Mail ] field.", "Format error", JOptionPane.ERROR_MESSAGE);

            SwingUtilities.invokeLater(new Runnable() {
                                            public void run() {
                                                jTextField_ident.requestFocus();
                                                jTextField_ident.selectAll();
                                                jToggleButton_login.setSelected(false);
                                            }
                                        });

            return false;
        }

        if (jPasswordField_password.getPassword().length < 1) {
            if (!isShowing()) {
                setVisible(true);
                setExtendedState(JFrame.NORMAL);
            }

            JOptionPane.showMessageDialog(this, "Please input [ Password ] field.", "Input error", JOptionPane.ERROR_MESSAGE);

            SwingUtilities.invokeLater(new Runnable() {
                                            public void run() {
                                                jPasswordField_password.requestFocus();
                                                jToggleButton_login.setSelected(false);
                                            }
                                        });

            return false;
        }

        return true;
    }

    private HashMap login() throws Exception {
        if (!checkInputField()) {
            return null;
        }

        try {
            HashMap map = BelugaClient.login(jTextField_ident.getText(), String.valueOf(jPasswordField_password.getPassword()));
    
            if (map == null) {
                closeWaitWindow();

                if (!isShowing()) {
                    setVisible(true);
                    setExtendedState(JFrame.NORMAL);
                }

                JOptionPane.showMessageDialog(this, "Please check [ E-Mail ] or [ Password ] field.", "Login error", JOptionPane.ERROR_MESSAGE);
    
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        jTextField_ident.selectAll();
                        jTextField_ident.requestFocus();
                        jToggleButton_login.setSelected(false);
                    }
                });
            }

            return map;
        } catch (Exception ex) {
            throw ex;
        }
    }
    
    private void podsSetting() {
        PodBean[] pods = getPodBean();

        for (final PodBean pb : pods) {
            new Thread() {
                public void run() { 
                    PodPane podPane = new PodPane(BelugaFrame.this, pb);

                    jTabbedPane_pods.addTab(pb.getPodTitle(), jCheckBoxMenuItem_pod.isSelected() ? podPane.getPodImage() : null, podPane);
                    jTabbedPane_pods.setTabComponentAt(jTabbedPane_pods.getTabCount() - 1, new JLabel(pb.getPodTitle(), jCheckBoxMenuItem_pod.isSelected() ? podPane.getPodImage() : null, JLabel.HORIZONTAL));
                    jLabel_status.putClientProperty(pb.getId(), "Updates");
                    
                    podPane.setVisibleIcon(jCheckBoxMenuItem_member.isSelected());

                    jPanel_context.updateUI();

                    if (jTabbedPane_pods.getTabCount() > 0) {
                        jButton_send.setEnabled(true);
                        jButton_reload.setEnabled(true);
                        jToggleButton_updates.setEnabled(true);
                        jToggleButton_members.setEnabled(true);
                        jToggleButton_map.setEnabled(true);
                        jToggleButton_edit.setEnabled(true);
                    }

                    closeWaitWindow();
                }
            }.start();
        }
    }


    private HashMap image_map = new HashMap();
    
    public ImageIcon getImageIcon(DefaultHttpClient cli, String uri) {
        if (!image_map.containsKey(uri)) {
            try {
                HttpGet      get = new HttpGet("http://belugapods.com" + uri);
                HttpResponse res = cli.execute(get);
                HttpEntity   ent = res.getEntity();
        
                BufferedInputStream   bis  = new BufferedInputStream(ent.getContent());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[]                data = new byte[512];
                int                   len  = -1;
                
                while ((len = bis.read(data, 0, data.length)) != -1) {
                    baos.write(data, 0, len);
                }
        
                image_map.put(uri, new ImageIcon(new ImageIcon(baos.toByteArray()).getImage().getScaledInstance(50, 50, Image.SCALE_SMOOTH)));
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        return (ImageIcon) image_map.get(uri);
    }
    
    public PodBean[] getPodBean() {
        return (PodBean[]) constant_map.get("pods");
    }

    public HashMap getImageMap() {
        return image_map;
    }
    
    public JLabel getStatusBar() {
        return jLabel_status;
    }
    
    public void setStatusBar(String status) {
        jLabel_status.setText(status);
    }
    
    private void showWaitWindow(final String message) {
//        waitWindow = new WaitWindow(this);
//
//        new Thread() {
//            public void run() {
//                waitWindow.setMessage(message);
//                waitWindow.start();
//            }
//        }.start();
    }

    private void closeWaitWindow() {
//        if (waitWindow == null) {
//            return;
//        }
//
//        waitWindow.dispose();
//        waitWindow = null;
    }

    private class WaitWindow extends Thread {
        private JDialog jDialog = null;
        JLabel jLabel_message = null;

        public WaitWindow(JFrame parent) {
            super();

            jDialog = new JDialog(parent, true);
            jDialog.setUndecorated(true);
            jDialog.setSize(200, 80);
            jDialog.setLocationRelativeTo(parent);
            
            Container con = jDialog.getContentPane();

            jLabel_message = new JLabel();
            jLabel_message.setHorizontalAlignment(JLabel.CENTER);
            jLabel_message.setBackground(SystemColor.control);
            jLabel_message.setBorder(BorderFactory.createEtchedBorder());
            jLabel_message.addMouseListener(new MouseAdapter() {
                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == e.BUTTON1 && e.getClickCount() == 2) {
                        jDialog.dispose();
                    }
                }
            });
            
            con.add(jLabel_message, "Center");
        }

        public void run() {
            jDialog.setVisible(true);
        }

        public void setMessage(String message) {
            jLabel_message.setText(message);
        }

        public void dispose() {
            jDialog.dispose();
        }
    }

    private TrayIcon icon = null;

    private void checkTaskTray(boolean isClose) {
        try {
            if (icon == null) {
                if (!SystemTray.isSupported()) {
                    return;
                }

                PopupMenu popupMenu = new PopupMenu();
                MenuItem  menuItem  = new MenuItem("Quit");
                
                menuItem.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        systemExit(false);
                    }
                });

                popupMenu.add(menuItem);

                icon = new TrayIcon(getIconImage(), "Beluga Client for Java", popupMenu);

                icon.addMouseListener(new MouseAdapter() {
                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (e.getButton() == e.BUTTON1) {
                            try {
                                if (!isShowing()) {
                                    setVisible(true);
                                    setExtendedState(JFrame.NORMAL);
                                } else {
                                    setVisible(false);
                                    setExtendedState(JFrame.ICONIFIED);
                                }
                            } finally {
                                if (!jCheckBoxMenuItem_startup.isSelected() || !jCheckBoxMenuItem_always.isSelected()) {
                                    SystemTray.getSystemTray().remove(icon);
                                }
                            }
                        }
                    }
                });
            }

            try {
                SystemTray.getSystemTray().add(icon);
            } catch (Exception ex) {}

            if (isClose) {
                this.setState(JFrame.ICONIFIED);
                this.setVisible(false);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    
    public void setMessage(String message) {
        setMessage(message, false);
    }

    public void setMessage(String message, boolean isTop) {
        jTextArea_message.setText(message.replaceAll("<br>", "").replaceAll("</.*>", "").replaceAll("<.*>", ""));

        if (isTop) {
            jTextArea_message.getCaret().moveDot(0);
        } else {
            jTextArea_message.getCaret().moveDot(jTextArea_message.getText().length());
        }

        jTextArea_message.select(0, 0);
    }
        
    public void displayMessage(String caption, String message, TrayIcon.MessageType type) {
        if (icon == null) {
            return;
        }

        icon.displayMessage(caption, message, type);
    }

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            
            System.setProperty("awt.useSystemAAFontSettings", "on");
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new BelugaFrame().open();
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup;
    private javax.swing.JButton jButton_reload;
    private javax.swing.JButton jButton_send;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem_always;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem_auto_login;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem_close;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem_member;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem_minimize;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem_ontop;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem_pod;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem_startup;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem_user;
    private javax.swing.JLabel jLabel_icon;
    private javax.swing.JLabel jLabel_ident;
    private javax.swing.JLabel jLabel_password;
    private javax.swing.JLabel jLabel_status;
    private javax.swing.JMenuBar jMenuBar;
    private javax.swing.JMenuItem jMenuItem_copy;
    private javax.swing.JMenuItem jMenuItem_logout;
    private javax.swing.JMenuItem jMenuItem_option;
    private javax.swing.JMenuItem jMenuItem_paste;
    private javax.swing.JMenuItem jMenuItem_paste1;
    private javax.swing.JMenuItem jMenuItem_quit;
    private javax.swing.JMenuItem jMenuItem_version;
    private javax.swing.JMenu jMenu_edit;
    private javax.swing.JMenu jMenu_file;
    private javax.swing.JMenu jMenu_help;
    private javax.swing.JMenu jMenu_view;
    private javax.swing.JPanel jPanel_buttons;
    private javax.swing.JPanel jPanel_center;
    private javax.swing.JPanel jPanel_context;
    private javax.swing.JPanel jPanel_input;
    private javax.swing.JPanel jPanel_north;
    private javax.swing.JPanel jPanel_south;
    private javax.swing.JPanel jPanel_top;
    private javax.swing.JPasswordField jPasswordField_password;
    private javax.swing.JPopupMenu jPopupMenu;
    private javax.swing.JScrollPane jScrollPane;
    private javax.swing.JSeparator jSeparator;
    private javax.swing.JPopupMenu.Separator jSeparator1;
    private javax.swing.JPopupMenu.Separator jSeparator2;
    private javax.swing.JSplitPane jSplitPane;
    private javax.swing.JTabbedPane jTabbedPane_pods;
    private javax.swing.JTextArea jTextArea_message;
    private javax.swing.JTextField jTextField_ident;
    private javax.swing.JToggleButton jToggleButton_edit;
    private javax.swing.JToggleButton jToggleButton_login;
    private javax.swing.JToggleButton jToggleButton_map;
    private javax.swing.JToggleButton jToggleButton_members;
    private javax.swing.JToggleButton jToggleButton_updates;
    // End of variables declaration//GEN-END:variables

}
