/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


function b2rGlobalThreadUtils(){
		// getBoardType ŗpOI URL ̃Xg( 2ch ǔȂ URL)
	this._exHosts = new Array(
		"find.2ch.net",
		"info.2ch.net",
		"epg.2ch.net",
		"headline.2ch.net",
		"newsnavi.2ch.net",
		"headline.bbspink.com"
	);

}

b2rGlobalThreadUtils.prototype = {

	getBoardType: function(aThreadURL){
		if(aThreadURL === null){
			throw Components.results.NS_ERROR_INVALID_POINTER;
		}

			// HTTP ȊO
		if(aThreadURL.scheme != "http") return Ci.b2rIGlobalService.BOARD_TYPE_PAGE;
			// HOST  URL
		if(aThreadURL.directory.length == 1) return Ci.b2rIGlobalService.BOARD_TYPE_PAGE;

		if(this._exHosts.indexOf(aThreadURL.host) != -1) return Ci.b2rIGlobalService.BOARD_TYPE_PAGE;

			// Be@2ch.net
		if(aThreadURL.host == "be.2ch.net") return Ci.b2rIGlobalService.BOARD_TYPE_BE2CH;
			// 2ch.net
		if(aThreadURL.host.indexOf(".2ch.net") != -1) return Ci.b2rIGlobalService.BOARD_TYPE_2CH;
			// bbspink.com
		if(aThreadURL.host.indexOf(".bbspink.com") != -1) return Ci.b2rIGlobalService.BOARD_TYPE_2CH;
			// ܂BBS
		if(aThreadURL.host.indexOf(".machi.to") != -1) return Ci.b2rIGlobalService.BOARD_TYPE_MACHI;
			// JBBS
		if(aThreadURL.host == "jbbs.livedoor.jp") return Ci.b2rIGlobalService.BOARD_TYPE_JBBS;

			// Xbh URL
		if(aThreadURL.directory.indexOf("/test/read.cgi/") != -1) return Ci.b2rIGlobalService.BOARD_TYPE_2CH;
		if((aThreadURL.fileName == "read.cgi") && (aThreadURL.query.indexOf("key=") != -1))
				return Ci.b2rIGlobalService.BOARD_TYPE_OLD2CH;

		return Ci.b2rIGlobalService.BOARD_TYPE_PAGE;
	},


	getBoardID: function(aBoardURL){
		if(aBoardURL === null){
			throw Components.results.NS_ERROR_INVALID_POINTER;
		}

		var boardID = "/";
		if(aBoardURL.host.indexOf(".2ch.net")!=-1){
			boardID += "2ch" + aBoardURL.path;
		}else if(aBoardURL.host.indexOf(".machi.to")!=-1){
			boardID += "machi" + aBoardURL.path;
		}else if(aBoardURL.host.indexOf(".bbspink.com")!=-1){
			boardID += "bbspink" + aBoardURL.path;
		}else if(aBoardURL.host == "jbbs.livedoor.jp"){
			boardID += "jbbs" + aBoardURL.path;
		}else{
			boardID += "outside/";
			boardID += aBoardURL.host +  aBoardURL.path;
		}
		return boardID;
	},


	getBoardURL: function(aURL){
		if(aURL === null){
			throw Components.results.NS_ERROR_INVALID_POINTER;
		}

		var boardURLSpec = aURL.resolve("../");

		switch(this.getBoardType(aURL)){
			case Ci.b2rIGlobalService.BOARD_TYPE_2CH:
			case Ci.b2rIGlobalService.BOARD_TYPE_BE2CH:
				boardURLSpec = boardURLSpec.replace("/test/read.cgi/", "/");
				break;
			case Ci.b2rIGlobalService.BOARD_TYPE_JBBS:
				boardURLSpec = boardURLSpec.replace("/bbs/read.cgi/", "/");
				break;
			case Ci.b2rIGlobalService.BOARD_TYPE_OLD2CH:
			case Ci.b2rIGlobalService.BOARD_TYPE_MACHI:
				boardURLSpec += aURL.query.match(/bbs=(\w+)/i) ? RegExp.$1 + "/" : null;
				break;
			case Ci.b2rIGlobalService.BOARD_TYPE_PAGE:
				throw Components.results.NS_ERROR_INVALID_ARG;
				break;
		}

		var ioService = XPC.getService("@mozilla.org/network/io-service;1", "nsIIOService");
		return ioService.newURI(boardURLSpec, null, null).QueryInterface(Ci.nsIURL);
	}

};