/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.events {
	import flash.events.Event;
	
	import jp.sourceforge.aramaki.net.Peer;
	
	/**
	 * メッセージイベント
	 */
	public class PeerMessageEvent extends PeerEvent {
		/**
		 * メッセージ受信イベント
		 * @eventType peerMessage
		 */
		public static const PEER_MESSAGE:String="peerMessage";
		/**
		 * @private
		 */
		private var _handlerName:String;
		/**
		 * @private
		 */
		private var _args:Array;
		
		/**
		 * @param id メッセージを送ってきたピアのID
		 * @param handlerName ハンドラの名前
		 * @param args ハンドラの引数
		 */
		public function PeerMessageEvent(type:String,bubbles:Boolean=false,cancelable:Boolean=false,peer:Peer=null,handlerName:String=null,args:Array=null) {
			super(type,bubbles,cancelable,peer);
			
			_handlerName=handlerName;
			_args=args;
		}
		
		/**
		 * ハンドラの名前
		 */
		public function get handlerName():String {
			return _handlerName;
		}
		
		/**
		 * ハンドラの引数
		 */
		public function get args():Array {
			return _args;
		}
		
		/**
		 * @inheritDoc
		 */
		public override function clone():Event {
			return new PeerMessageEvent(type,bubbles,cancelable,_peer,_handlerName,_args);
		}
		
		/**
		 * @inheritDoc
		 */
		public override function toString():String {
			return formatToString("PeerEvent","type","bubbles","cancelable","eventPhase","_peer","_handlerName","_args"); 
		}
	}
}