/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.events {
	import flash.events.Event;
	
	import jp.sourceforge.aramaki.net.Peer;
	
	public class PeerEvent extends Event {
		/**
		 * ピア接続イベント
		 * @eventType peerConnect
		 */
		public static const PEER_CONNECT:String="peerConnect";
		/**
		 * ピア接続失敗イベント
		 * @eventType peerConnectFailed
		 */
		public static const PEER_CONNECT_FAILED:String="peerConnectFailed";
		/**
		 * ピア切断イベント
		 * @eventType peerClose
		 */
		public static const PEER_CLOSE:String="peerClose";
		/**
		 * @private
		 */
		protected var _peer:Peer;
		
		/**
		 * @param peer ピア
		 */
		public function PeerEvent(type:String,bubbles:Boolean=false,cancelable:Boolean=false,peer:Peer=null) {
			_peer=peer;
			
			super(type,bubbles,cancelable);
		}
		
		/**
		 * ピア
		 */
		public function get peer():Peer {
			return _peer;
		}
		
		/**
		 * @inheritDoc
		 */
		public override function clone():Event {
			return new PeerEvent(type,bubbles,cancelable,_peer);
		}
		
		/**
		 * @inheritDoc
		 */
		public override function toString():String {
			return formatToString("PeerEvent","type","bubbles","cancelable","eventPhase","_peer"); 
		}
	}
}