﻿/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

package jp.sourceforge.aramaki.controls {
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.geom.Matrix;
	
	import mx.core.UIComponent;
	
	public class Sky extends UIComponent {
		/**
		 * コンストラクタ以外の何者でもない
		 * 
		 * ビットマップキャッシュを有効にする
		 */
		public function Sky() {
			cacheAsBitmap=true;
		}
		
		/**
		 * @inheritDoc
		 * 
		 * 空を描画
		 */
		override protected function updateDisplayList(unscaledWidth:Number,unscaledHeight:Number):void {
			super.updateDisplayList(unscaledWidth,unscaledHeight);
			
			var gradientBoxMatrix:Matrix = new Matrix;
			var g:Graphics = graphics;
			
			gradientBoxMatrix.createGradientBox(width, height, Math.PI/2);
			
			g.clear();
			g.beginGradientFill(GradientType.LINEAR, [0x00055c, 0x9cd6fc, 0xffffff], [1, 1, 1], [0, 128, 255], gradientBoxMatrix);
			g.drawRect(0, 0, width, height);
			g.endFill();
		}
	}
}