/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LOGINDIALOG_H_
#define LOGINDIALOG_H_

#include "gui.h"

class LoginDialog : public LoginDialogBase {
	//設定XMLのファイル名
	static const char *configXmlFileName;
	//ネットワークリストXMLのファイル名
	static const char *networkListXmlFileName;
	//名前欄が空欄のときの名前
	static const wxString anonymousName;
	//ブートストラップスクリプトのリスト
	wxArrayString bootstrapScriptList;

	//設定を読み込む
	void loadConfig();
	//設定を保存
	void saveConfig() const;
	//ネットワークリストを読み込む
	void loadNetworkList();
	//ログインボタンが押された
	void onClickLoginButton(wxCommandEvent &);
public:
	LoginDialog(wxWindow *parent);

	inline wxString getName() const {
		wxString name=nameEdit->GetValue();

		if (name.IsEmpty()) {
			return anonymousName;
		} else {
			return name;
		}
	}

	inline uint16_t getPort() const {
		long port;
		portEdit->GetValue().ToLong(&port);
		return port;
	}

	inline const wxString &getNetwork() const {
		return bootstrapScriptList[networkList->GetSelection()];
	}

	inline void setStatusText(const wxString &status) {
		statusText->SetLabel(status);
	}
};

#endif /* LOGINDIALOG_H_ */
