/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "LoginDialog.h"
#include "tinyxml.h"

const char *LoginDialog::configXmlFileName="config.xml";
const char *LoginDialog::networkListXmlFileName="networks.xml";
const wxString LoginDialog::anonymousName(wxT("名無しさん"));

LoginDialog::LoginDialog(wxWindow *parent) : LoginDialogBase(parent) {
	loadNetworkList();
	loadConfig();

	portEdit->SetValidator(wxTextValidator(wxFILTER_NUMERIC));
}

void LoginDialog::loadConfig() {
	TiXmlDocument configXml(configXmlFileName);
	TiXmlElement *rootElement;
	const char *name,*port,*network;

	//設定XMLをロード
	if (!configXml.LoadFile()) return;

	if (!(rootElement=configXml.RootElement())) return;

	//名前を取得
	if (name=rootElement->Attribute("name")) nameEdit->SetValue(wxString::FromUTF8(name));

	//ポートを取得
	if (port=rootElement->Attribute("port")) portEdit->SetValue(wxString::FromUTF8(port));

	//ネットワークを取得
	if (network=rootElement->Attribute("network")) networkList->SetStringSelection(wxString::FromUTF8(network));
}

void LoginDialog::saveConfig() const {
	TiXmlDocument configXml(configXmlFileName);
	TiXmlElement rootElement("map");
	TiXmlDeclaration decl("1.0","UTF-8","yes");
	configXml.InsertEndChild(decl);

	//名前を記録
	rootElement.SetAttribute("name",nameEdit->GetValue().utf8_str());

	//ポートを記録
	rootElement.SetAttribute("port",portEdit->GetValue().utf8_str());

	//ネットワークを記録
	rootElement.SetAttribute("network",networkList->GetStringSelection().utf8_str());

	//ルートエレメントを追加
	configXml.InsertEndChild(rootElement);

	//保存
	configXml.SaveFile();
}

void LoginDialog::loadNetworkList() {
	TiXmlDocument networkListXml(networkListXmlFileName);
	TiXmlElement *rootElement;

	//ネットワークリストXMLをロード
	if (!networkListXml.LoadFile()) goto error;

	if (!(rootElement=networkListXml.RootElement())) goto error;

	//ネットワークをリストに追加
	for (TiXmlElement *element=rootElement->FirstChildElement("network");element;element=element->NextSiblingElement("network")) {
		const char *name,*bootstrapScript;

		if (!(name=element->Attribute("name"))) goto error;
		if (!(bootstrapScript=element->Attribute("bootstrapScript"))) goto error;

		networkList->Append(wxString::FromUTF8(name));
		bootstrapScriptList.push_back(wxString::FromUTF8(bootstrapScript));
	}

	networkList->SetSelection(0);

	return;
error:
	wxLogFatalError(wxT("ネットワークリストの読み込みに失敗"));
}

void LoginDialog::onClickLoginButton(wxCommandEvent &) {
	saveConfig();

	EndModal(wxID_OK);
}
