/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CHARACTER_H_
#define CHARACTER_H_

#include "Model.h"
#include "Point3d.h"
#include "TextPolygon.h"
#include <wx/sound.h>
#include "Balloon.h"

class Model;

class Character {
	//モデルデータ
	static Model *model;
	//ログイン音
	static wxSound *loginSound;
	//ログアウト音
	static wxSound *logoutSound;
	//発言音
	static wxSound *saySound;
	//効果音有効フラグ
	static bool enableSe;

	Character(const Character &);
	void operator=(const Character &);
protected:
	//位置
	Point3d position;
	//名前
	TextPolygon name;
	//ふきだし
	Balloon balloon;
public:
	Character();
	virtual ~Character();
	//モデルを描画
	void render() const;
	virtual const Point3d &getPosition() const;
	virtual void setPosition(const Point3d &_value);
	virtual const wxString &getName() const;
	virtual void setName(const wxString &_value);
	virtual const wxString &getMessage() const;
	virtual void setMessage(const wxString &_value);
	//初期化
	static void initialize();
	//後処理
	static void finalize();

	static inline bool isEnableSe() {
		return enableSe;
	}

	static inline void setEnableSe(bool _value) {
		enableSe=_value;
	}
};

#endif /*CHARACTER_H_*/
