/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "MainFrame.h"

#if !defined(__WXMSW__)&&!defined(__WXPM__)
//Win32/OS2以外のOS用アイコン
#include "aramakiIcon.xpm"
#endif

BEGIN_EVENT_TABLE(MainFrame,wxFrame)
	EVT_BUTTON(MainFrame::ID_SEND_BUTTON,MainFrame::onClickSendButton)
	EVT_TOGGLEBUTTON(MainFrame::ID_TOPMOST_BUTTON,MainFrame::onToggleTopmostButton)
	EVT_TOGGLEBUTTON(MainFrame::ID_SE_ENABLE_BUTTON,MainFrame::onToggleSeEnableButton)
	EVT_BUTTON(MainFrame::ID_LOGOUT_BUTTON,MainFrame::onClickLogoutButton)
	EVT_TEXT_SHIFT_ENTER(MainFrame::ID_MESSAGE_TEXT,MainFrame::onClickSendButton)
	EVT_CLOSE(MainFrame::onClose)
	EVT_TEXT_TAB(MainFrame::ID_MESSAGE_TEXT,MainFrame::onTabDown)
END_EVENT_TABLE()

MainFrame::MainFrame() : wxFrame((wxFrame *)NULL,wxID_ANY,wxString(wxT("荒巻オンライン"))+VERSION,wxDefaultPosition,wxSize(640,491)),loggingIn(false) {
	//アイコンを設定
	SetIcon(wxICON(aramakiIcon));

	//コントロールを作成
	sizer=new wxBoxSizer(wxVERTICAL);

	canvas=new Canvas(this);
	sizer->Add(canvas,1,wxEXPAND,0,NULL);

	subSizer=new wxBoxSizer(wxHORIZONTAL);
	sizer->Add(subSizer,0,wxEXPAND,0,NULL);

	messageText=new MessageTextCtrl(this,ID_MESSAGE_TEXT,wxEmptyString,wxDefaultPosition,wxSize(0,40),wxTE_MULTILINE);
	messageText->SetMaxLength(240);
	subSizer->Add(messageText,1,0,0,NULL);

	sendButton=new wxButton(this,ID_SEND_BUTTON,wxT("発言"),wxDefaultPosition,wxSize(70,40));
	subSizer->Add(sendButton,0,0,0,NULL);

	topmostButton=new wxToggleButton(this,ID_TOPMOST_BUTTON,wxT("最前面表示"),wxDefaultPosition,wxSize(70,40));
	subSizer->Add(topmostButton,0,0,0,NULL);

	seEnableButton=new wxToggleButton(this,ID_SE_ENABLE_BUTTON,wxT("効果音"),wxDefaultPosition,wxSize(70,40));
	subSizer->Add(seEnableButton,0,0,0,NULL);

	logoutButton=new wxButton(this,ID_LOGOUT_BUTTON,wxT("ログアウト"),wxDefaultPosition,wxSize(70,40));
	subSizer->Add(logoutButton,0,0,0,NULL);

	logText=new wxTextCtrl(this,wxID_ANY,wxEmptyString,wxDefaultPosition,wxSize(0,70),wxTE_MULTILINE|wxTE_READONLY);
	sizer->Add(logText,0,wxEXPAND,0,NULL);

	SetSizer(sizer);

	//ログインダイアログを表示
	login();
}

void MainFrame::onClickSendButton(wxCommandEvent &WXUNUSED(event)) {
	world->getMyCharacter().setMessage(messageText->GetValue());
	messageText->Clear();
	canvas->Refresh(false);
}

void MainFrame::onToggleTopmostButton(wxCommandEvent &WXUNUSED(event)) {
	ToggleWindowStyle(wxSTAY_ON_TOP);
}

void MainFrame::onToggleSeEnableButton(wxCommandEvent &WXUNUSED(event)) {
	Character::setEnableSe(seEnableButton->GetValue());
}

void MainFrame::onClickLogoutButton(wxCommandEvent &WXUNUSED(event)) {
	logout();
	Hide();
	login();
	Show();
}

void MainFrame::login() {
	LoginDialog loginDialog(this);

	switch(loginDialog.ShowModal()) {
	case LoginDialog::ID_BUTTON_CONNECT_TO_NETWORK:
		//ネットワークへ接続
		if (loginDialog.getInitNodeHost().IsEmpty()) {
			wxMessageBox(wxT("初期ノードが指定されていません"),wxT("ログイン"),wxOK|wxICON_ERROR,this);

			//もう一度ログイン
			login();

			return;
		}
		world=new World(loginDialog.getListenPort(),loginDialog.getInitNodeHost(),loginDialog.getInitNodePort());
		break;
	case LoginDialog::ID_BUTTON_CREATE_NETWORK:
		//ネットワークを作成
		world=new World(loginDialog.getListenPort());
		break;
	case wxID_CANCEL:
		//終了
		Close();
		return;
	}

	if (world->isError()) {
		wxMessageBox(world->getErrorMessage(),wxT("ログイン"),wxOK|wxICON_ERROR,this);
		delete world;

		//もう一度ログイン
		login();

		return;
	}

	if (loginDialog.getName().IsEmpty()) {
		world->getMyCharacter().setName(wxT("名無しさん"));
	} else {
		world->getMyCharacter().setName(loginDialog.getName());
	}

	loggingIn=true;

	canvas->SetFocus();
	canvas->Refresh(false);
}

void MainFrame::logout() {
	if (loggingIn) {
		loggingIn=false;
		delete world;
	}
}

void MainFrame::onClose(wxCloseEvent &event) {
	logout();
	event.Skip();
}

void MainFrame::onTabDown(wxCommandEvent &WXUNUSED(event)) {
	//Canvasにフォーカスをセット
	canvas->SetFocus();
}
