/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DISPLAYLIST_H_
#define DISPLAYLIST_H_

#include <wx/glcanvas.h>

class DisplayList {
	//ディスプレイリスト
	GLuint displayList;

	DisplayList(const DisplayList &);
	DisplayList &operator=(const DisplayList &);
public:
	//ディスプレイリストを作成
	DisplayList() : displayList(glGenLists(1)) {}

	~DisplayList() {
		//ディスプレイリストを削除
		glDeleteLists(displayList,1);
	}

	//描画コマンドを記録
	void compile() const {
		glNewList(displayList,GL_COMPILE);
	}

	//記録を終了
	void end() const {
		glEndList();
	}

	//描画コマンドを再生
	void call() const {
		glCallList(displayList);
	}
};

#endif /* DISPLAYLIST_H_ */
