/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "Character.h"
#include "AramakiOnline.h"
#include "MainFrame.h"

Model *Character::model;
wxSound Character::loginSound;
wxSound Character::logoutSound;
wxSound Character::saySound;
bool Character::enableSe;
bool Character::initialized;

Character::Character() {
	if (!initialized) initialize();

	//フォントを設定
	name.setFont(wxFont(9,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_BOLD,false,wxT("ＭＳ Ｐゴシック"),wxFONTENCODING_CP932));
	name.setTextColor(*wxBLUE);
	name.setTransparent(true);

	balloon.setFont(wxFont(9,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,wxT("ＭＳ Ｐゴシック"),wxFONTENCODING_CP932));
	balloon.setTextColor(*wxBLACK);

	if (enableSe) loginSound.Play(wxSOUND_ASYNC);
}

Character::~Character() {
	if (enableSe) logoutSound.Play(wxSOUND_ASYNC);
}

void Character::initialize() {
	model=new Model(wxT("aramaki.obj"));

	loginSound.Create(wxT("login.wav"));
	if (!loginSound.IsOk()) wxLogFatalError("ログイン音のロードに失敗");

	logoutSound.Create(wxT("logout.wav"));
	if (!logoutSound.IsOk()) wxLogFatalError("ログアウト音のロードに失敗");

	saySound.Create(wxT("say.wav"));
	if (!saySound.IsOk()) wxLogFatalError("発言音のロードに失敗");

	initialized=true;
}

void Character::draw() const {
	glPushMatrix();

	//ずらして描画
	glTranslated(position.x,position.y,position.z);
	//ビルボード表示
	glRotated(360-getWorld().getMyCharacter().getDirection(),0,1,0);
	model->draw();
	if (!balloon.getText().IsEmpty()) balloon.draw();
	name.draw();

	glPopMatrix();
}

const Point3d &Character::getPosition() const {
	return position;
}

void Character::setPosition(const Point3d &_value) {
	position=_value;
}

const wxString &Character::getName() const {
	return name.getText();
}

void Character::setName(const wxString &_value) {
	name.setText(_value);
	name.setPosition(Point3d(-name.getWidth()/2,0.65,0));
}

const wxString &Character::getMessage() const {
	return balloon.getText();
}

void Character::setMessage(const wxString &_value) {
	balloon.setText(_value);
	balloon.setPosition(Point3d(-balloon.getWidth()/2,1.1,0));

	if (enableSe&&!_value.IsEmpty()) saySound.Play(wxSOUND_ASYNC);

	if (!_value.IsEmpty()) {
		//改行を削除
		getMainFrame().appendLog(name.getText(),balloon.getText());
	}
}
