/* keylistener.js

{{IS_NOTE
	Purpose:
		zk.KeyListener
	Description:
		Keylistener component for ZK. 
}}IS_NOTE

Copyright 2007 by Easit AB. All rights reserved.

{{IS_RIGHT
	This program is distributed under GPL Version 2.0 in the hope that
	it will be useful, but WITHOUT ANY WARRANTY.
}}IS_RIGHT
*/
zkKeyListener = {};

zk.KeyListener = Class.create();
zk.KeyListener.prototype = {	
	initialize: function (comp) {
		this.id = comp.id;
		zkau.setMeta(comp, this);
		this.comp = comp;
		this.init();
	},
	init: function () {
		var el = $e(this.id);
		if (!el) return;	
		this.element = el;
		var meta = this;	
		this.fnOnKeyDown = function (evt) {
			meta.keyDown(evt);													
		};
		zk.listen(document, "keydown", this.fnOnKeyDown);
	},
	keyDown: function(evt) {
		if (!evt) evt = window.event;

		var keycode = evt.keyCode, zkcode; //zkcode used to search z.ctkeys
		switch (keycode) {
			case 13: //ENTER
				zkcode = 'K';
			break;
			case 27: //ESC
			break;
			case 16: //Shift
			case 17: //Ctrl
			case 18: //Alt
			return true;
			case 44: //Ins
			case 45: //Del
				zkcode = keycode == 44 ? 'I': 'J';
			break;
			default:
				if (keycode >= 33 && keycode <= 40) { //PgUp, PgDn, End, Home, L, U, R, D
					zkcode = String.fromCharCode('A'.charCodeAt(0) + (keycode - 33));
						//A~H: PgUp, ...
					break;
				} else if (keycode >= 112 && keycode <= 123) { //F1: 112, F12: 123
					zkcode = String.fromCharCode('P'.charCodeAt(0) + (keycode - 112));
						//M~Z: F1~F12
					break;
				} else if (evt.ctrlKey || evt.altKey) {
					zkcode = String.fromCharCode(keycode).toLowerCase();
					break;
				}
			return true;
		}

		// If keyboard command is registered for this component, send request
		if(this.inCtrlKeys(evt, zkcode, getZKAttr(this.comp, "ctkeys")) ) {
		
			// If autoblur is specified, set focus to keylistener to trigger onBlur for focused component
			if(getZKAttr(this.comp, "autoblur")=="true"){
				this.comp.tabIndex = 32000;
				this.comp.focus();
				this.comp.tabIndex = 0;
			}
			
			var req = {uuid: this.comp.id, cmd: "onCtrlKey", ctl: true, data: [keycode, evt.ctrlKey, evt.shiftKey, evt.altKey]};
			
			// Do not send request directly, otherwise onChange events won't be fired correctly in IE
			setTimeout(function () {
					zkau.send(req, 38);		
					
			}, 10);

			Event.stop(evt);

			// Special handling for IE that Event.stop doesn't support
			if (document.all && window.event && !evt.preventDefault) {
				evt.keyCode = 0;
			}
			return false;
		} 
		return true;
	},
	inCtrlKeys: function(evt, zkcode, keys) {
		if (keys) {
			//format: ctl+k;alt+k;shft+k;k
			var cc = evt.ctrlKey ? '^': evt.altKey ? '@': evt.shiftKey ? '$': '#';
			var j = keys.indexOf(cc), k = keys.indexOf(';', j + 1);
			if (j >=0 && k >= 0) {
				keys = keys.substring(j + 1, k);
				return keys.indexOf(zkcode) >= 0;
			}
		}
		return false;	
	},
	cleanup: function ()  {
		zk.unlisten(document, "keydown", this.fnOnKeyDown);
	}
};



zkKeyListener.init = function (cmp) {
	var meta = zkau.getMeta(cmp);
	if (meta) meta.init();
	else new zk.KeyListener(cmp);	
};

zkKeyListener.setAttr = function (cmp, nm, val) {
	return false;
};

zkKeyListener.cleanup = function(cmp) {
	var meta = zkau.getMeta(cmp);
	if (meta) meta.cleanup();
};